/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.util.HashMap;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.PatchDefinition;

public class PatchDefinitionFactory
implements RenderPatchFactory {
    private HashMap<PatchDefinition, PatchDefinition> patches = new HashMap();
    private Object lock = new Object();
    private PatchDefinition lookup = new PatchDefinition();
    private Map<String, PatchDefinition> namemap = null;

    public void setPatchNameMape(Map<String, PatchDefinition> nmap) {
        this.namemap = nmap;
    }

    @Override
    public RenderPatch getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        return this.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, 100.0, sidevis, textureids);
    }

    @Override
    public RenderPatch getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        return this.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, 0.0, 1.0, 0.0, 1.0, uplusvmax, sidevis, textureids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchDefinition getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        Object object = this.lock;
        synchronized (object) {
            this.lookup.update(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, uplusvmax, sidevis, textureids);
            if (!this.lookup.validate()) {
                return null;
            }
            PatchDefinition pd2 = this.patches.get(this.lookup);
            if (pd2 == null) {
                PatchDefinition pd = new PatchDefinition(this.lookup);
                this.patches.put(pd, pd);
                pd2 = pd;
            }
            return pd2;
        }
    }

    @Override
    public RenderPatch getRotatedPatch(RenderPatch patch, int xrot, int yrot, int zrot, int textureindex) {
        return this.getPatch((PatchDefinition)patch, xrot, yrot, zrot, textureindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchDefinition getPatch(PatchDefinition patch, int xrot, int yrot, int zrot, int textureindex) {
        PatchDefinition pd = new PatchDefinition(patch, xrot, yrot, zrot, textureindex);
        if (!pd.validate()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            PatchDefinition pd2 = this.patches.get(pd);
            if (pd2 == null) {
                this.patches.put(pd, pd);
                pd2 = pd;
            }
            return pd2;
        }
    }

    @Override
    public RenderPatch getRotatedPatchAutoTexCoords(RenderPatch patch, int xrot, int yrot, int zrot, int textureindex) {
        return this.getPatchAutoTexCoords((PatchDefinition)patch, xrot, yrot, zrot, textureindex);
    }

    public PatchDefinition getPatchAutoTexCoords(PatchDefinition patch, int xrot, int yrot, int zrot, int textureindex) {
        PatchDefinition pd = new PatchDefinition(patch, xrot, yrot, zrot, textureindex);
        if (!pd.validate()) {
            return null;
        }
        PatchDefinitionFactory.autoTexCoords(pd);
        return pd;
    }

    @Override
    public RenderPatch getNamedPatch(String name, int textureidx) {
        return this.getPatchByName(name, textureidx);
    }

    public PatchDefinition getPatchByName(String name, int textureidx) {
        PatchDefinition pd = null;
        if (this.namemap != null) {
            pd = this.namemap.get(name);
            if (pd != null && textureidx != pd.textureindex) {
                pd = null;
            }
            if (pd == null) {
                String patchid = name;
                int txt_idx = -1;
                int off = patchid.lastIndexOf(35);
                if (off > 0) {
                    try {
                        txt_idx = Integer.valueOf(patchid.substring(off + 1));
                    }
                    catch (NumberFormatException nfx) {
                        return null;
                    }
                    patchid = patchid.substring(0, off);
                }
                int rotx = 0;
                int roty = 0;
                int rotz = 0;
                off = patchid.indexOf(64);
                if (off > 0) {
                    String[] rv = patchid.substring(off + 1).split("/");
                    if (rv.length == 1) {
                        roty = Integer.parseInt(rv[0]);
                    } else if (rv.length == 2) {
                        rotx = Integer.parseInt(rv[0]);
                        roty = Integer.parseInt(rv[1]);
                    } else if (rv.length == 3) {
                        rotx = Integer.parseInt(rv[0]);
                        roty = Integer.parseInt(rv[1]);
                        rotz = Integer.parseInt(rv[2]);
                    }
                    patchid = patchid.substring(0, off);
                }
                if ((pd = this.namemap.get(patchid)) == null) {
                    return null;
                }
                pd = txt_idx >= 0 ? this.getPatch(pd, rotx, roty, rotz, txt_idx) : this.getPatch(pd, rotx, roty, rotz, textureidx);
                if (pd != null) {
                    this.namemap.put(name, pd);
                }
            }
        }
        return pd;
    }

    @Override
    public int getTextureIndexFromMap(String id, int key) {
        return TexturePack.getTextureIndexFromTextureMap(id, key);
    }

    @Override
    public int getTextureCountFromMap(String id) {
        return TexturePack.getTextureMapLength(id);
    }

    @Override
    public RenderPatch getTriangleExplTexCoords(double x0, double y0, double z0, double tu0, double tv0, double x1, double y1, double z1, double tu1, double tv1, double x2, double y2, double z2, double tu2, double tv2, RenderPatchFactory.SideVisible sidevis, int textureidx) {
        PatchDefinition ret = new PatchDefinition();
        ret.update(x0, y0, z0, x1, y1, z1, x2, y2, z2, 0.0, 1.0, 0.0, 1.0, 1.0, sidevis, textureidx);
        ret.explicitTexCoords = new double[]{tu0, tv0, tu1, tv1, tu2, tv2};
        return ret;
    }

    @Override
    public RenderPatch getPatchExplTexCoords(double x0, double y0, double z0, double tu0, double tv0, double x1, double y1, double z1, double tu1, double tv1, double x2, double y2, double z2, double tu2, double tv2, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureidx) {
        PatchDefinition ret = new PatchDefinition();
        ret.update(x0, y0, z0, x1, y1, z1, x2, y2, z2, 0.0, 1.0, 0.0, 1.0, uplusvmax, sidevis, textureidx);
        ret.explicitTexCoords = new double[]{tu0, tv0, tu1, tv1, tu2, tv2};
        return ret;
    }

    @Override
    public RenderPatch getTriangleAutoTexCoords(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, RenderPatchFactory.SideVisible sidevis, int textureidx) {
        return this.getTriangleAutoTexCoords(x0, y0, z0, x1, y1, z1, x2, y2, z2, 1.0, sidevis, textureidx);
    }

    @Override
    public RenderPatch getTriangleAutoTexCoords(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureidx) {
        PatchDefinition ret = new PatchDefinition();
        ret.update(x0, y0, z0, x1, y1, z1, x2, y2, z2, 0.0, 1.0, 0.0, 1.0, uplusvmax, sidevis, textureidx);
        PatchDefinitionFactory.autoTexCoords(ret);
        return ret;
    }

    @Override
    public RenderPatch getQuadAutoTexCoords(double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2, RenderPatchFactory.SideVisible sidevis, int textureidx) {
        PatchDefinition ret = new PatchDefinition();
        ret.update(x0, y0, z0, x1, y1, z1, x2, y2, z2, 0.0, 1.0, 0.0, 1.0, 100.0, sidevis, textureidx);
        PatchDefinitionFactory.autoTexCoords(ret);
        return ret;
    }

    private static void autoTexCoords(PatchDefinition ret) {
        switch (ret.step) {
            case X_PLUS: {
                ret.explicitTexCoords = new double[]{1.0 - ret.z0, ret.y0, 1.0 - ret.zu, ret.yu, 1.0 - ret.zv, ret.yv};
                break;
            }
            case Y_PLUS: {
                ret.explicitTexCoords = new double[]{ret.x0, 1.0 - ret.z0, ret.xu, 1.0 - ret.zu, ret.xv, 1.0 - ret.zv};
                break;
            }
            case Z_PLUS: {
                ret.explicitTexCoords = new double[]{1.0 - ret.x0, ret.y0, 1.0 - ret.xu, ret.yu, 1.0 - ret.xv, ret.yv};
                break;
            }
            case X_MINUS: {
                ret.explicitTexCoords = new double[]{ret.z0, ret.y0, ret.zu, ret.yu, ret.zv, ret.yv};
                break;
            }
            case Y_MINUS: {
                ret.explicitTexCoords = new double[]{ret.x0, ret.z0, ret.xu, ret.zu, ret.xv, ret.zv};
                break;
            }
            case Z_MINUS: {
                ret.explicitTexCoords = new double[]{ret.x0, ret.y0, ret.xu, ret.yu, ret.xv, ret.yv};
            }
        }
    }
}

