/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.shadow.org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.dynmap.shadow.org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor {
    private boolean DEBUG;
    private int port;
    private String key;
    private boolean exitVm;
    private ServerSocket serverSocket;
    private ShutdownMonitorThread thread;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    private ShutdownMonitor() {
        Properties props = System.getProperties();
        this.DEBUG = props.containsKey("DEBUG");
        this.port = Integer.parseInt(props.getProperty("STOP.PORT", "-1"));
        this.key = props.getProperty("STOP.KEY", null);
        this.exitVm = true;
    }

    private void close(ServerSocket server) {
        if (server == null) {
            return;
        }
        try {
            server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void debug(String format, Object ... args) {
        if (this.DEBUG) {
            System.err.printf("[ShutdownMonitor] " + format + "%n", args);
        }
    }

    private void debug(Throwable t) {
        if (this.DEBUG) {
            t.printStackTrace(System.err);
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setDebug(boolean flag) {
        this.DEBUG = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExitVm(boolean exitVm) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.exitVm = exitVm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String key) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.key = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.port = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        ShutdownMonitorThread t = null;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                return;
            }
            t = this.thread = new ShutdownMonitorThread();
        }
        if (t != null) {
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAlive() {
        boolean result = false;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            result = this.thread != null && this.thread.isAlive();
        }
        return result;
    }

    public String toString() {
        return String.format("%s[port=%d]", this.getClass().getName(), this.port);
    }

    public class ShutdownMonitorThread
    extends Thread {
        public ShutdownMonitorThread() {
            this.setDaemon(true);
            this.setName("ShutdownMonitor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ShutdownMonitor.this.serverSocket == null) {
                return;
            }
            while (ShutdownMonitor.this.serverSocket != null) {
                Socket socket = null;
                try {
                    socket = ShutdownMonitor.this.serverSocket.accept();
                    LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                    String receivedKey = lin.readLine();
                    if (!ShutdownMonitor.this.key.equals(receivedKey)) {
                        System.err.println("Ignoring command with incorrect key");
                        continue;
                    }
                    OutputStream out = socket.getOutputStream();
                    String cmd = lin.readLine();
                    ShutdownMonitor.this.debug("command=%s", new Object[]{cmd});
                    if ("stop".equals(cmd)) {
                        ShutdownMonitor.this.debug("Issuing graceful shutdown..", new Object[0]);
                        ShutdownThread.getInstance().run();
                        ShutdownMonitor.this.debug("Informing client that we are stopped.", new Object[0]);
                        out.write("Stopped\r\n".getBytes("UTF-8"));
                        out.flush();
                        ShutdownMonitor.this.debug("Shutting down monitor", new Object[0]);
                        ShutdownMonitor.this.close(socket);
                        socket = null;
                        ShutdownMonitor.this.close(ShutdownMonitor.this.serverSocket);
                        ShutdownMonitor.this.serverSocket = null;
                        if (!ShutdownMonitor.this.exitVm) continue;
                        ShutdownMonitor.this.debug("Killing JVM", new Object[0]);
                        System.exit(0);
                        continue;
                    }
                    if (!"status".equals(cmd)) continue;
                    out.write("OK\r\n".getBytes("UTF-8"));
                    out.flush();
                }
                catch (Exception e) {
                    ShutdownMonitor.this.debug(e);
                    System.err.println(e.toString());
                }
                finally {
                    ShutdownMonitor.this.close(socket);
                    socket = null;
                }
            }
        }

        @Override
        public void start() {
            if (this.isAlive()) {
                System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                return;
            }
            this.startListenSocket();
            if (ShutdownMonitor.this.serverSocket == null) {
                return;
            }
            if (ShutdownMonitor.this.DEBUG) {
                System.err.println("Starting ShutdownMonitorThread");
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startListenSocket() {
            block7: {
                if (ShutdownMonitor.this.port < 0) {
                    if (ShutdownMonitor.this.DEBUG) {
                        System.err.println("ShutdownMonitor not in use (port < 0): " + ShutdownMonitor.this.port);
                    }
                    return;
                }
                try {
                    ShutdownMonitor.this.serverSocket = new ServerSocket(ShutdownMonitor.this.port, 1, InetAddress.getByName("127.0.0.1"));
                    if (ShutdownMonitor.this.port == 0) {
                        ShutdownMonitor.this.port = ShutdownMonitor.this.serverSocket.getLocalPort();
                        System.out.printf("STOP.PORT=%d%n", ShutdownMonitor.this.port);
                    }
                    if (ShutdownMonitor.this.key != null) break block7;
                    ShutdownMonitor.this.key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                    System.out.printf("STOP.KEY=%s%n", ShutdownMonitor.this.key);
                }
                catch (Exception e) {
                    try {
                        ShutdownMonitor.this.debug(e);
                        System.err.println("Error binding monitor port " + ShutdownMonitor.this.port + ": " + e.toString());
                        ShutdownMonitor.this.serverSocket = null;
                    }
                    catch (Throwable throwable) {
                        ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                        ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                        ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                        throw throwable;
                    }
                    ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                    ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                    ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                }
            }
            ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
            ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
            ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
        }
    }

    static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor();

        Holder() {
        }
    }
}

