/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.modsupport.BlockMatcher;

public class GWM_Util {
    static boolean initialized;
    static Map<String, Integer> blockIdMap;
    static Map<String, Integer> unlocalizedNameToIdMap;
    static Map<String, Integer> textureNameToIdMap;
    public static HashMap<String, ArrayList<Object>> blockGroups;
    static BlockMatcher.AdvancedConditionParser dummyConditionParser;

    public static void initialize(DynmapCore core) {
        if (initialized) {
            return;
        }
        blockIdMap = core.getBlockIDMap();
        unlocalizedNameToIdMap = new HashMap<String, Integer>();
        FMLControlledNamespacedRegistry blockRegistry = GameData.getBlockRegistry();
        for (Map.Entry<String, Integer> entry : blockIdMap.entrySet()) {
            Block block = (Block)blockRegistry.func_148754_a(entry.getValue().intValue());
            unlocalizedNameToIdMap.put(block.func_149739_a(), entry.getValue());
        }
        initialized = true;
    }

    public static int blockNameToId(String stringId) {
        return GWM_Util.blockNameToId(stringId, false);
    }

    public static int blockNameToId(String stringId, boolean alsoCheckUnlocalizedNames) {
        Integer intId = blockIdMap.get(stringId);
        if (intId != null) {
            return intId;
        }
        if (alsoCheckUnlocalizedNames && (intId = unlocalizedNameToIdMap.get(stringId)) != null) {
            return intId;
        }
        return GWM_Util.objectToInt(stringId, 0);
    }

    public static int objectToInt(Object obj, int def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        try {
            if (obj instanceof String) {
                return Integer.parseInt((String)obj);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    public static void tryRegisterTextureByName(String name, int id) {
        if (textureNameToIdMap.get(name) == null) {
            textureNameToIdMap.put(name, id);
        }
    }

    public static int tryGetTextureIdByName(String name) {
        Integer exact = textureNameToIdMap.get(name);
        if (exact != null) {
            return exact;
        }
        String noColon = name.replace(':', '/');
        Integer noColonAttempt = textureNameToIdMap.get(noColon);
        if (noColonAttempt != null) {
            return noColonAttempt;
        }
        String prependMinecraft = "minecraft/" + noColon;
        Integer prependMinecraftAttempt = textureNameToIdMap.get(prependMinecraft);
        if (prependMinecraftAttempt != null) {
            return prependMinecraftAttempt;
        }
        return -1;
    }

    public static void loadBlockGroups(DynmapCore core) {
        if (!initialized) {
            GWM_Util.initialize(core);
        }
        Log.verboseinfo("Loading block groups...");
        File f = new File(core.getDataFolder(), "blockgroups.yml");
        if (!core.updateUsingDefaultResource("/blockgroups.yml", f, "block-groups")) {
            return;
        }
        ConfigurationNode builtIn = new ConfigurationNode(f);
        builtIn.load();
        GWM_Util.addBlockGroups(builtIn);
        f = new File(core.getDataFolder(), "blockgroups.yml");
        core.createDefaultFileFromResource("/blockgroups.yml", f);
        if (f.exists()) {
            ConfigurationNode custom = new ConfigurationNode(f);
            custom.load();
            GWM_Util.addBlockGroups(custom);
        }
    }

    private static void addBlockGroups(ConfigurationNode builtIn) {
        for (Map<String, Object> cn : builtIn.getMapList("block-groups")) {
            for (Map.Entry<String, Object> ent : cn.entrySet()) {
                String key = ent.getKey();
                Object value = ent.getValue();
                if (value instanceof ArrayList) {
                    blockGroups.put(key, (ArrayList)value);
                    continue;
                }
                blockGroups.put(key, new ArrayList());
            }
        }
    }

    public static BlockMatcher getBlockMatcher(ArrayList<Object> entries) {
        BlockMatcher ret = new BlockMatcher();
        HashSet visitedGroups = new HashSet();
        GWM_Util.addList(entries, ret, visitedGroups);
        return ret;
    }

    private static void addList(ArrayList<Object> entries, BlockMatcher bm, HashSet visitedGroups) {
        for (Object o : entries) {
            int idx;
            if (o instanceof Integer) {
                bm.addBlock((Integer)o);
                continue;
            }
            if (!(o instanceof String)) continue;
            String s = (String)o;
            if (s.startsWith("@")) {
                ArrayList<Object> group;
                String sub = s.substring(1);
                if (visitedGroups.contains(sub) || (group = blockGroups.get(sub)) == null) continue;
                visitedGroups.add(sub);
                GWM_Util.addList(group, bm, visitedGroups);
                continue;
            }
            String blockName = s.trim();
            Integer blockId = blockIdMap.get(blockName);
            if (blockId == null) continue;
            String cond = null;
            int meta = 15;
            if (blockName.contains("[")) {
                idx = blockName.indexOf(91);
                int lastIdx = blockName.lastIndexOf(93);
                cond = blockName.substring(idx + 1, lastIdx);
                blockName = blockName.substring(0, idx);
            }
            if (blockName.contains("#")) {
                idx = blockName.indexOf(35);
                String metaStr = blockName.substring(idx + 1);
                blockName = blockName.substring(0, idx);
                meta = metaStr.startsWith("m") ? Integer.parseInt(metaStr.substring(1)) : 1 << Integer.parseInt(metaStr);
            }
            if (cond != null) {
                bm.addBlockWithCondition(blockId, meta, GWM_Util.parseCondition(cond));
                continue;
            }
            bm.addBlockMetaMask(blockId, meta);
        }
    }

    private static BlockMatcher.AdvancedCondition parseCondition(String cond) {
        return dummyConditionParser.parseExpression(cond);
    }

    static {
        textureNameToIdMap = new HashMap<String, Integer>();
        blockGroups = new HashMap();
        dummyConditionParser = new BlockMatcher.AdvancedConditionParser();
    }
}

