/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.textureprocessor;

import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.textureprocessor.CustomTextureProcessor;

public class ExtraUtilitiesGreenScreenProcessor
extends CustomTextureProcessor {
    int[] colorMul = new int[]{0xFFFFFF, 0xFF7F00, 0xFF00FF, 32728, 0xFFFF00, 65280, 16751013, 0x7F7F7F, 0xCCCCCC, 65535, 11678719, 255, 8336128, 39168, 0xFF0000, 0};

    @Override
    public void patchTextures(TexturePack texturePack, int[] tileToDyntile, int[] argb, int w, int h, int native_scale) {
        for (int i = 0; i < 16; ++i) {
            int[] blended = new int[native_scale * native_scale];
            TexturePack.scaleTerrainPNGSubImage(w, native_scale, argb, blended);
            if (this.colorMul[i] != 0xFFFFFF) {
                int mulR = (this.colorMul[i] & 0xFF0000) >> 16;
                int mulG = (this.colorMul[i] & 0xFF00) >> 8;
                int mulB = this.colorMul[i] & 0xFF;
                for (int p = 0; p < blended.length; ++p) {
                    int srcR = (blended[p] & 0xFF0000) >> 16;
                    int srcG = (blended[p] & 0xFF00) >> 8;
                    int srcB = blended[p] & 0xFF;
                    int dstR = mulR * srcR / 255 & 0xFF;
                    int dstG = mulG * srcG / 255 & 0xFF;
                    int dstB = mulB * srcB / 255 & 0xFF;
                    blended[p] = blended[p] & 0xFF000000 | dstR << 16 | dstG << 8 | dstB;
                }
            }
            texturePack.setTileARGB(tileToDyntile[i], blended);
        }
    }

    @Override
    public int getTextureCount() {
        return 16;
    }
}

