/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.textureprocessor;

import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.textureprocessor.CustomTextureProcessor;

public class AE2MonitorProcessor
extends CustomTextureProcessor {
    int[] otherColorMul = new int[]{0xFFFFFF, 0xFF7F00, 0xFF00FF, 32728, 0xFFFF00, 65280, 16751013, 0x7F7F7F, 0xCCCCCC, 65535, 11678719, 255, 8336128, 39168, 0xFF0000, 0, 8870822};
    static int[] darkColorMul = new int[]{0xD8D8D8, 16231491, 11938230, 8432356, 16120905, 12188752, 16102356, 0x9E9E9E, 0xCBCBCB, 5286084, 10638028, 5261820, 11900029, 6283309, 16515131, 0x555555, 8870822};
    static int[] brightColorMul = new int[]{0xF7F7F7, 15850433, 12818118, 14021628, 16579813, 15004884, 15004884, 0xC7C7C7, 0xECECEC, 11328241, 12952010, 14345212, 14536646, 0xE0EFE0, 16573418, 0x828282, 13941225};
    static int[] mediumColorMul = new int[]{0xBCBCBC, 16160056, 8396416, 6392777, 16577704, 8125513, 14257075, 0x7B7B7B, 0x9B9B9B, 3053987, 8400816, 2893982, 7425332, 4496929, 10682408, 0x2A2A2A, 1778499};

    @Override
    public void patchTextures(TexturePack texturePack, int[] tileToDyntile, int[] argb, int w, int h, int native_scale) {
        for (int i = 0; i < darkColorMul.length; ++i) {
            int[] blended = new int[native_scale * native_scale];
            TexturePack.scaleTerrainPNGSubImage(w, native_scale, argb, blended);
            if (darkColorMul[i] != 0xFFFFFF) {
                int mulR = (darkColorMul[i] & 0xFF0000) >> 16;
                int mulG = (darkColorMul[i] & 0xFF00) >> 8;
                int mulB = darkColorMul[i] & 0xFF;
                for (int p = 0; p < blended.length; ++p) {
                    int srcR = (blended[p] & 0xFF0000) >> 16;
                    int srcG = (blended[p] & 0xFF00) >> 8;
                    int srcB = blended[p] & 0xFF;
                    int dstR = mulR * srcR / 255 & 0xFF;
                    int dstG = mulG * srcG / 255 & 0xFF;
                    int dstB = mulB * srcB / 255 & 0xFF;
                    blended[p] = blended[p] & 0xFF000000 | dstR << 16 | dstG << 8 | dstB;
                }
            }
            texturePack.setTileARGB(tileToDyntile[i], blended);
        }
    }

    @Override
    public int getTextureCount() {
        return 17;
    }
}

