/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class TinkersClearGlassBlockRenderer
extends CustomRenderer {
    int block;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.block = blkid;
        return true;
    }

    int getVersion(MapDataContext mapDataCtx, ForgeDirection down, ForgeDirection up, ForgeDirection left, ForgeDirection right) {
        int version = 0;
        if (mapDataCtx.getBlockTypeIDAt(down.offsetX, down.offsetY, down.offsetZ) == this.block) {
            version |= 1;
        }
        if (mapDataCtx.getBlockTypeIDAt(up.offsetX, up.offsetY, up.offsetZ) == this.block) {
            version |= 2;
        }
        if (mapDataCtx.getBlockTypeIDAt(left.offsetX, left.offsetY, left.offsetZ) == this.block) {
            version |= 4;
        }
        if (mapDataCtx.getBlockTypeIDAt(right.offsetX, right.offsetY, right.offsetZ) == this.block) {
            version |= 8;
        }
        return version;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] versions = new int[6];
        block8: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            switch (dir) {
                case DOWN: {
                    versions[0] = this.getVersion(mapDataCtx, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST);
                    continue block8;
                }
                case UP: {
                    versions[1] = this.getVersion(mapDataCtx, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.EAST);
                    continue block8;
                }
                case NORTH: {
                    versions[4] = this.getVersion(mapDataCtx, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.WEST);
                    continue block8;
                }
                case SOUTH: {
                    versions[5] = this.getVersion(mapDataCtx, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.EAST);
                    continue block8;
                }
                case WEST: {
                    versions[2] = this.getVersion(mapDataCtx, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH);
                    continue block8;
                }
                case EAST: {
                    versions[3] = this.getVersion(mapDataCtx, ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.NORTH);
                    continue block8;
                }
            }
        }
        CustomRenderer.addBox(mapDataCtx.getPatchFactory(), list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, versions);
        return list.toArray(new RenderPatch[versions.length]);
    }
}

