/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ThaumcraftStoneDeviceRenderer
extends CustomRenderer {
    RenderPatch[] fullBlock;
    RenderPatch[] pedestal;
    RenderPatch[] matrix;
    RenderPatch[][] infusionBottom = new RenderPatch[4][];
    RenderPatch[][] infusionTop = new RenderPatch[4][];
    static String[] nbtFieldsNeeded = new String[]{"orientation"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.fullBlock = ThaumcraftStoneDeviceRenderer.getFullBlock(rpf, -1);
        this.pedestal = this.getPedestalModel(rpf);
        this.matrix = this.getMatrixModel(rpf);
        for (int i = 0; i < 4; ++i) {
            this.infusionBottom[i] = this.getInfusionBottomModel(rpf, i);
            this.infusionTop[i] = this.getInfusionTopModel(rpf, i);
        }
        return true;
    }

    private RenderPatch[] getMatrixModel(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    ThaumcraftStoneDeviceRenderer.addBox(rpf, list, 0.55 * (double)x, 0.55 * (double)x + 0.45, 0.55 * (double)y, 0.55 * (double)y + 0.45, 0.55 * (double)z, 0.55 * (double)z + 0.45, patchTextureIds);
                }
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] getInfusionTopModel(RenderPatchFactory rpf, int orientation) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        CustomRenderer.addBox(rpf, list, 0.7, 0.97, 0.75, 0.95, 0.7, 0.97, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.5, 0.92, 0.5, 0.75, 0.5, 0.92, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.35, 0.88, 0.25, 0.5, 0.35, 0.88, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.25, 0.85, 0.0, 0.25, 0.25, 0.85, patchTextureIds);
        return ThaumcraftStoneDeviceRenderer.getRotatedPatches(rpf, orientation, list);
    }

    private RenderPatch[] getInfusionBottomModel(RenderPatchFactory rpf, int orientation) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 0, 0, 0, 0, 0};
        CustomRenderer.addBox(rpf, list, 0.15, 0.85, 0.25, 1.0, 0.15, 0.85, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.25, 0.0, 1.0, patchTextureIds);
        return ThaumcraftStoneDeviceRenderer.getRotatedPatches(rpf, orientation, list);
    }

    private static RenderPatch[] getRotatedPatches(RenderPatchFactory rpf, int orientation, ArrayList<RenderPatch> list) {
        RenderPatch[] renderPatches = list.toArray(new RenderPatch[list.size()]);
        if (orientation != 0) {
            for (int i = 0; i < renderPatches.length; ++i) {
                renderPatches[i] = rpf.getRotatedPatch(renderPatches[i], 0, orientation * 90, 0, renderPatches[i].getTextureIndex());
            }
        }
        return renderPatches;
    }

    private RenderPatch[] getPedestalModel(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchTextureIds = new int[]{0, 0, 1, 1, 1, 1};
        CustomRenderer.addBox(rpf, list, 0.125, 0.875, 0.75, 1.0, 0.125, 0.875, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.25, 0.75, 0.25, 0.75, 0.25, 0.75, patchTextureIds);
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.25, 0.0, 1.0, patchTextureIds);
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int data = mapDataCtx.getBlockData();
        switch (data) {
            case 0: {
                return this.fullBlock;
            }
            case 1: {
                return this.pedestal;
            }
            case 2: {
                return this.matrix;
            }
            case 3: 
            case 4: {
                Object objOrientation = mapDataCtx.getBlockTileEntityField("orientation");
                int orientation = 0;
                if (objOrientation instanceof Byte) {
                    orientation = (Byte)objOrientation % 4;
                    switch (orientation) {
                        case 0: {
                            orientation = 1;
                            break;
                        }
                        case 1: {
                            orientation = 2;
                            break;
                        }
                        case 2: {
                            orientation = 0;
                            break;
                        }
                        case 3: {
                            orientation = 3;
                        }
                    }
                } else if (mapDataCtx.getBlockDataAt(1, 1, 1) == 2) {
                    orientation = 0;
                } else if (mapDataCtx.getBlockDataAt(-1, 1, 1) == 2) {
                    orientation = 1;
                } else if (mapDataCtx.getBlockDataAt(-1, 1, -1) == 2) {
                    orientation = 2;
                } else if (mapDataCtx.getBlockDataAt(1, 1, -1) == 2) {
                    orientation = 3;
                }
                if (data == 3) {
                    return this.infusionBottom[orientation];
                }
                return this.infusionTop[orientation];
            }
            case 5: 
            case 6: {
                break;
            }
        }
        return this.fullBlock;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

