/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RailCraftFireboxRenderer
extends CustomRenderer {
    RenderPatch[] inactive;
    RenderPatch[] active;
    int thisBlockId;
    static int[][] offsets = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, -1}, {-1, 1}, {1, -1}, {1, 1}};
    static String[] nbtFieldsNeeded = new String[]{"master", "burnTime"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        this.inactive = RailCraftFireboxRenderer.getBoxFull(rpf, new int[]{0, 0, 1, 1, 1, 1});
        this.active = RailCraftFireboxRenderer.getBoxFull(rpf, new int[]{0, 0, 2, 2, 2, 2});
        this.thisBlockId = blkid;
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        for (int i = 0; i < offsets.length; ++i) {
            if (mapDataCtx.getBlockTypeIDAt(offsets[i][0], 0, offsets[i][1]) != this.thisBlockId || GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityFieldAt("master", offsets[i][0], 0, offsets[i][1]), 0) != 1) continue;
            Object burnTime = mapDataCtx.getBlockTileEntityFieldAt("burnTime", offsets[i][0], 0, offsets[i][1]);
            if (burnTime instanceof Float && ((Float)burnTime).floatValue() > 0.0f) {
                return this.active;
            }
            if (burnTime instanceof Double && (Double)burnTime > 0.0) {
                return this.active;
            }
            return this.inactive;
        }
        return this.inactive;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

