/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.MECableRenderer;
import org.dynmap.hdmap.renderer.multipart.MultiPartHelper;
import org.dynmap.hdmap.renderer.multipart.MultiPartRenderer;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;

public class MultipartRenderer
extends CustomRenderer {
    public static MultipartRenderer INSTANCE = null;
    private static final int[] fullBlockPatchList = new int[]{0, 1, 4, 5, 2, 3};
    private RenderPatch[] fullBlock;
    private RenderPatch[][] facePatches;
    private RenderPatch[][] postPatches;
    private RenderPatch[][] cornerPatches;
    private RenderPatch[][] edgePatches;
    private RenderPatch[][] hollowPatches;
    public int blockId = -1000;
    static String[] nbtFieldsNeeded = new String[]{"parts"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, fullBlockPatchList);
        this.fullBlock = list.toArray(new RenderPatch[fullBlockPatchList.length]);
        this.initializeFacePatches(rpf);
        this.initializePostPatches(rpf);
        this.initializeCornerPatches(rpf);
        this.initializeEdgePatches(rpf);
        this.initializeHollowPatches(rpf);
        this.blockId = blkid;
        INSTANCE = this;
        if (MECableRenderer.INSTANCE != null) {
            MECableRenderer.INSTANCE.multipartBlockId = blkid;
        }
        return true;
    }

    private void initializeHollowPatches(RenderPatchFactory rpf) {
        this.hollowPatches = new RenderPatch[128][];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            block9: for (int i = 0; i < 7; ++i) {
                int id = dir.ordinal() + 16 * (i + 1);
                double w = (double)(i + 1) / 8.0;
                switch (dir) {
                    case DOWN: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 0.0, 0.25, 0.0, w, 0.0, 1.0), this.makeBox(rpf, 0.75, 1.0, 0.0, w, 0.0, 1.0), this.makeBox(rpf, 0.25, 0.75, 0.0, w, 0.0, 0.25), this.makeBox(rpf, 0.25, 0.75, 0.0, w, 0.75, 1.0)});
                        continue block9;
                    }
                    case UP: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 0.0, 0.25, 1.0 - w, 1.0, 0.0, 1.0), this.makeBox(rpf, 0.75, 1.0, 1.0 - w, 1.0, 0.0, 1.0), this.makeBox(rpf, 0.25, 0.75, 1.0 - w, 1.0, 0.0, 0.25), this.makeBox(rpf, 0.25, 0.75, 1.0 - w, 1.0, 0.75, 1.0)});
                        continue block9;
                    }
                    case NORTH: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 0.0, 0.25, 0.0, 1.0, 0.0, w), this.makeBox(rpf, 0.75, 1.0, 0.0, 1.0, 0.0, w), this.makeBox(rpf, 0.25, 0.75, 0.0, 0.25, 0.0, w), this.makeBox(rpf, 0.25, 0.75, 0.75, 1.0, 0.0, w)});
                        continue block9;
                    }
                    case SOUTH: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 0.0, 0.25, 0.0, 1.0, 1.0 - w, 1.0), this.makeBox(rpf, 0.75, 1.0, 0.0, 1.0, 1.0 - w, 1.0), this.makeBox(rpf, 0.25, 0.75, 0.0, 0.25, 1.0 - w, 1.0), this.makeBox(rpf, 0.25, 0.75, 0.75, 1.0, 1.0 - w, 1.0)});
                        continue block9;
                    }
                    case WEST: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 0.0, w, 0.0, 0.25, 0.0, 1.0), this.makeBox(rpf, 0.0, w, 0.75, 1.0, 0.0, 1.0), this.makeBox(rpf, 0.0, w, 0.25, 0.75, 0.0, 0.25), this.makeBox(rpf, 0.0, w, 0.25, 0.75, 0.75, 1.0)});
                        continue block9;
                    }
                    case EAST: {
                        this.hollowPatches[id] = MultipartRenderer.combineMultiple(new RenderPatch[][]{this.makeBox(rpf, 1.0 - w, 1.0, 0.0, 0.25, 0.0, 1.0), this.makeBox(rpf, 1.0 - w, 1.0, 0.75, 1.0, 0.0, 1.0), this.makeBox(rpf, 1.0 - w, 1.0, 0.25, 0.75, 0.0, 0.25), this.makeBox(rpf, 1.0 - w, 1.0, 0.25, 0.75, 0.75, 1.0)});
                        continue block9;
                    }
                }
            }
        }
    }

    private void initializeEdgePatches(RenderPatchFactory rpf) {
        this.edgePatches = new RenderPatch[256][];
        for (int c = 0; c < 12; ++c) {
            block15: for (int i = 0; i < 7; ++i) {
                int shape = c + 16 * (i + 1);
                double negativeMax = (double)(i + 1) * 0.125;
                double positiveMin = 1.0 - negativeMax;
                switch (c) {
                    case 0: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, negativeMax, 0.0, 1.0, 0.0, negativeMax);
                        continue block15;
                    }
                    case 1: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, negativeMax, 0.0, 1.0, positiveMin, 1.0);
                        continue block15;
                    }
                    case 2: {
                        this.edgePatches[shape] = this.makeBox(rpf, positiveMin, 1.0, 0.0, 1.0, 0.0, negativeMax);
                        continue block15;
                    }
                    case 3: {
                        this.edgePatches[shape] = this.makeBox(rpf, positiveMin, 1.0, 0.0, 1.0, positiveMin, 1.0);
                        continue block15;
                    }
                    case 4: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, negativeMax, 0.0, negativeMax, 0.0, 1.0);
                        continue block15;
                    }
                    case 5: {
                        this.edgePatches[shape] = this.makeBox(rpf, positiveMin, 1.0, 0.0, negativeMax, 0.0, 1.0);
                        continue block15;
                    }
                    case 6: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, negativeMax, positiveMin, 1.0, 0.0, 1.0);
                        continue block15;
                    }
                    case 7: {
                        this.edgePatches[shape] = this.makeBox(rpf, positiveMin, 1.0, positiveMin, 1.0, 0.0, 1.0);
                        continue block15;
                    }
                    case 8: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, 1.0, 0.0, negativeMax, 0.0, negativeMax);
                        continue block15;
                    }
                    case 9: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, 1.0, positiveMin, 1.0, 0.0, negativeMax);
                        continue block15;
                    }
                    case 10: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, 1.0, 0.0, negativeMax, positiveMin, 1.0);
                        continue block15;
                    }
                    case 11: {
                        this.edgePatches[shape] = this.makeBox(rpf, 0.0, 1.0, positiveMin, 1.0, positiveMin, 1.0);
                    }
                }
            }
        }
    }

    private void initializeCornerPatches(RenderPatchFactory rpf) {
        this.cornerPatches = new RenderPatch[256][];
        for (int c = 0; c < 8; ++c) {
            block11: for (int i = 0; i < 7; ++i) {
                int shape = c + 16 * (i + 1);
                double negativeMax = (double)(i + 1) * 0.125;
                double positiveMin = 1.0 - negativeMax;
                switch (c) {
                    case 0: {
                        this.cornerPatches[shape] = this.makeBox(rpf, 0.0, negativeMax, 0.0, negativeMax, 0.0, negativeMax);
                        continue block11;
                    }
                    case 1: {
                        this.cornerPatches[shape] = this.makeBox(rpf, 0.0, negativeMax, positiveMin, 1.0, 0.0, negativeMax);
                        continue block11;
                    }
                    case 2: {
                        this.cornerPatches[shape] = this.makeBox(rpf, 0.0, negativeMax, 0.0, negativeMax, positiveMin, 1.0);
                        continue block11;
                    }
                    case 3: {
                        this.cornerPatches[shape] = this.makeBox(rpf, 0.0, negativeMax, positiveMin, 1.0, positiveMin, 1.0);
                        continue block11;
                    }
                    case 4: {
                        this.cornerPatches[shape] = this.makeBox(rpf, positiveMin, 1.0, 0.0, negativeMax, 0.0, negativeMax);
                        continue block11;
                    }
                    case 5: {
                        this.cornerPatches[shape] = this.makeBox(rpf, positiveMin, 1.0, positiveMin, 1.0, 0.0, negativeMax);
                        continue block11;
                    }
                    case 6: {
                        this.cornerPatches[shape] = this.makeBox(rpf, positiveMin, 1.0, 0.0, negativeMax, positiveMin, 1.0);
                        continue block11;
                    }
                    case 7: {
                        this.cornerPatches[shape] = this.makeBox(rpf, positiveMin, 1.0, positiveMin, 1.0, positiveMin, 1.0);
                    }
                }
            }
        }
    }

    private void initializePostPatches(RenderPatchFactory rpf) {
        this.postPatches = new RenderPatch[256][];
        for (int i = 0; i < 7; ++i) {
            double min = 0.5 - ((double)i + 1.0) / 16.0;
            double max = 1.0 - min;
            this.postPatches[0 + 16 * (i + 1)] = this.makeBox(rpf, min, max, 0.0, 1.0, min, max);
            this.postPatches[1 + 16 * (i + 1)] = this.makeBox(rpf, min, max, min, max, 0.0, 1.0);
            this.postPatches[2 + 16 * (i + 1)] = this.makeBox(rpf, 0.0, 1.0, min, max, min, max);
        }
    }

    private void initializeFacePatches(RenderPatchFactory rpf) {
        this.facePatches = new RenderPatch[128][];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            block9: for (int i = 0; i < 7; ++i) {
                int id = dir.ordinal() + 16 * (i + 1);
                switch (dir) {
                    case DOWN: {
                        this.facePatches[id] = this.makeBox(rpf, 0.0, 1.0, 0.0, (double)(i + 1) / 8.0, 0.0, 1.0);
                        continue block9;
                    }
                    case UP: {
                        this.facePatches[id] = this.makeBox(rpf, 0.0, 1.0, 1.0 - (double)(i + 1) / 8.0, 1.0, 0.0, 1.0);
                        continue block9;
                    }
                    case NORTH: {
                        this.facePatches[id] = this.makeBox(rpf, 0.0, 1.0, 0.0, 1.0, 0.0, (double)(i + 1) / 8.0);
                        continue block9;
                    }
                    case SOUTH: {
                        this.facePatches[id] = this.makeBox(rpf, 0.0, 1.0, 0.0, 1.0, 1.0 - (double)(i + 1) / 8.0, 1.0);
                        continue block9;
                    }
                    case WEST: {
                        this.facePatches[id] = this.makeBox(rpf, 0.0, (double)(i + 1) / 8.0, 0.0, 1.0, 0.0, 1.0);
                        continue block9;
                    }
                    case EAST: {
                        this.facePatches[id] = this.makeBox(rpf, 1.0 - (double)(i + 1) / 8.0, 1.0, 0.0, 1.0, 0.0, 1.0);
                        continue block9;
                    }
                }
            }
        }
    }

    RenderPatch[] makeBox(RenderPatchFactory rpf, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, fullBlockPatchList);
        return list.toArray(new RenderPatch[fullBlockPatchList.length]);
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        Object rawParts = mapDataCtx.getBlockTileEntityField("parts");
        MyRenderData mrd = new MyRenderData();
        RenderPatchFactory rpf = mapDataCtx.getPatchFactory();
        if (rawParts instanceof ArrayList) {
            ArrayList parts = (ArrayList)rawParts;
            for (Object tmp : parts) {
                HashMap fields;
                Object rawId;
                if (!(tmp instanceof HashMap) || (rawId = (fields = (HashMap)tmp).get("id")) == null) continue;
                String strId = (String)rawId;
                int shape = 0;
                Object rawShape = fields.get("shape");
                if (rawShape instanceof Byte) {
                    shape = ((Byte)rawShape).byteValue();
                } else if (rawShape instanceof Short) {
                    shape = ((Short)rawShape).shortValue();
                } else if (rawShape instanceof Integer) {
                    shape = (Integer)rawShape;
                }
                String mat = "minecraft:stone";
                Object objMaterial = fields.get("material");
                if (objMaterial != null) {
                    mat = (String)objMaterial;
                }
                if (strId.equals("mcr_face")) {
                    if (this.facePatches[shape] == null) continue;
                    mrd.addSimpleShape(rpf, this.facePatches[shape], mat);
                    continue;
                }
                if (strId.equals("mcr_post")) {
                    if (this.postPatches[shape] == null) continue;
                    mrd.addSimpleShape(rpf, this.postPatches[shape], mat);
                    continue;
                }
                if (strId.equals("mcr_edge")) {
                    if (this.edgePatches[shape] == null) continue;
                    mrd.addSimpleShape(rpf, this.edgePatches[shape], mat);
                    continue;
                }
                if (strId.equals("mcr_cnr")) {
                    if (this.cornerPatches[shape] == null) continue;
                    mrd.addSimpleShape(rpf, this.cornerPatches[shape], mat);
                    continue;
                }
                if (strId.equals("mcr_hllw")) {
                    if (this.hollowPatches[shape] == null) continue;
                    mrd.addSimpleShape(rpf, this.hollowPatches[shape], mat);
                    continue;
                }
                if (strId.equals("ae2_cablebus") && MECableRenderer.INSTANCE != null) {
                    CustomRendererData crd = MECableRenderer.INSTANCE.getRenderData(mapDataCtx);
                    mrd.addComplexShape(rpf, crd, MECableRenderer.INSTANCE.meCableBusBlockId, 0);
                    continue;
                }
                MultiPartRenderer rend = MultiPartHelper.getRendererForPart(strId);
                if (rend == null) continue;
                CustomRendererData crd = rend.getRenderData(mapDataCtx, fields);
                mrd.addComplexShape(rpf, crd, 0, 0);
            }
        }
        return mrd;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        return this.fullBlock;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class MyColorMult
    extends CustomColorMultiplier {
        int color;

        public MyColorMult(int c) {
            this.color = c;
        }

        @Override
        public int getColorMultiplier(MapDataContext mapDataCtx) {
            return this.color;
        }
    }

    class MyRenderData
    extends CustomRendererData
    implements CustomTextureMapper {
        List<RenderPatch> patches;
        int patchNum;
        HashMap<Integer, Integer> patchToTex;
        HashMap<Integer, CustomColorMultiplier> patchToColorMult;

        public MyRenderData() {
            super(null, null, null);
            this.patches = new ArrayList<RenderPatch>();
            this.patchNum = 0;
            this.patchToTex = new HashMap();
            this.patchToColorMult = new HashMap();
        }

        public void addSimpleShape(RenderPatchFactory rpf, RenderPatch[] patches, String block) {
            String blockName = block;
            int data = 0;
            int lastIndexOfUnderscore = block.lastIndexOf(95);
            if (lastIndexOfUnderscore > 0) {
                try {
                    data = Integer.parseInt(block.substring(lastIndexOfUnderscore + 1));
                    if (data >= 0 && data <= 15) {
                        blockName = block.substring(0, lastIndexOfUnderscore);
                    } else {
                        data = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    data = 0;
                }
            }
            int blockId = GWM_Util.blockNameToId(blockName, true);
            TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(blockId, data, 0);
            for (RenderPatch rp : patches) {
                int patchId = rp.getTextureIndex();
                patchId = this.forgeDirToBlockStep(patchId);
                int textureId = map.getIndexForFace(patchId);
                this.patchToTex.put(this.patchNum, textureId);
                if (textureId / 1000000 == 17) {
                    int color = map.getColorMult();
                    this.patchToColorMult.put(this.patchNum, new MyColorMult(color));
                }
                this.patches.add(rpf.getRotatedPatch(rp, 0, 0, 0, this.patchNum++));
            }
        }

        int forgeDirToBlockStep(int dir) {
            switch (ForgeDirection.getOrientation((int)dir)) {
                case DOWN: {
                    return BlockStep.Y_PLUS.ordinal();
                }
                case UP: {
                    return BlockStep.Y_MINUS.ordinal();
                }
                case NORTH: {
                    return BlockStep.Z_PLUS.ordinal();
                }
                case SOUTH: {
                    return BlockStep.Z_MINUS.ordinal();
                }
                case WEST: {
                    return BlockStep.X_PLUS.ordinal();
                }
                case EAST: {
                    return BlockStep.X_MINUS.ordinal();
                }
            }
            return 0;
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            return new int[]{this.patchToTex.get(patchId)};
        }

        @Override
        public RenderPatch[] getCustomMesh() {
            return this.patches.toArray(new RenderPatch[this.patches.size()]);
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            return this;
        }

        @Override
        public CustomColorMultiplier getCustomColorMultiplier(int patchId, int layer) {
            return this.patchToColorMult.get(patchId);
        }

        public void addComplexShape(RenderPatchFactory rpf, CustomRendererData crd, int blockId, int blockMeta) {
            CustomTextureMapper ctm = crd.getCustomTextureMapper();
            TexturePack.HDTextureMap map = TexturePack.HDTextureMap.getMap(blockId, blockMeta, 0);
            if (ctm != null) {
                for (RenderPatch rp : crd.getCustomMesh()) {
                    int[] textureLayersForPatchId = ctm.getTextureLayersForPatchId(rp.getTextureIndex());
                    if (textureLayersForPatchId != null) {
                        if (textureLayersForPatchId.length <= 0) continue;
                        this.patchToTex.put(this.patchNum, textureLayersForPatchId[0]);
                        this.patches.add(rpf.getRotatedPatch(rp, 0, 0, 0, this.patchNum++));
                        continue;
                    }
                    this.patchToTex.put(this.patchNum, map.getIndexForFace(rp.getTextureIndex()));
                    this.patches.add(rpf.getRotatedPatch(rp, 0, 0, 0, this.patchNum++));
                }
            } else {
                for (RenderPatch rp : crd.getCustomMesh()) {
                    this.patchToTex.put(this.patchNum, map.getIndexForFace(rp.getTextureIndex()));
                    this.patches.add(rpf.getRotatedPatch(rp, 0, 0, 0, this.patchNum++));
                }
            }
        }
    }
}

