/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.renderer.BuildCraftPipeRenderer;
import org.dynmap.hdmap.renderer.PipeRendererBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class LogisticsPipesPipeRenderer
extends PipeRendererBase {
    RenderPatch[][] pipes;
    static String[] nbtFieldsNeeded = new String[]{"BC_Pipe_NBT"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.pipes = this.generateSingleSize(rpf, 0.25, 0.25, 0, 0);
        BuildCraftPipeRenderer.buildCraftCompatiblePipeBlocks.set(blkid);
        return true;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object bcPipeNbt = mapDataCtx.getBlockTileEntityField("BC_Pipe_NBT");
        int open = 63;
        if (bcPipeNbt instanceof HashMap) {
            HashMap hm = (HashMap)bcPipeNbt;
            open = GWM_Util.objectToInt(hm.get("inputOpen"), 63);
        }
        int version = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int id;
            if ((open & 1 << dir.ordinal()) == 0 || !BuildCraftPipeRenderer.buildCraftCompatiblePipeBlocks.get(id = mapDataCtx.getBlockTypeIDAt(dir.offsetX, dir.offsetY, dir.offsetZ))) continue;
            version |= dir.flag;
        }
        return this.pipes[version];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

