/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ForestryWoodEtcRenderer
extends CustomRenderer {
    String nbtKey = "WT";
    int max = 29;
    BlockType type = BlockType.Wood;
    RenderPatch[][][] modelByTypeAndMeta;
    String[] nbtFieldsNeeded;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (custparm.get("key") != null) {
            this.nbtKey = custparm.get("key");
        }
        if (custparm.get("max") != null) {
            this.max = Integer.parseInt(custparm.get("max"));
        }
        if (custparm.get("type") != null) {
            this.type = BlockType.valueOf(custparm.get("type"));
        }
        switch (this.type) {
            case Wood: {
                this.modelByTypeAndMeta = new RenderPatch[this.max][3][];
                for (int i = 0; i < this.max; ++i) {
                    int idx = i * 2;
                    this.modelByTypeAndMeta[i][0] = CustomRenderer.getBoxFull(rpf, new int[]{idx + 1, idx + 1, idx, idx, idx, idx});
                    this.modelByTypeAndMeta[i][1] = CustomRenderer.getBoxFull(rpf, new int[]{idx, idx, idx + 1, idx + 1, idx, idx});
                    this.modelByTypeAndMeta[i][2] = CustomRenderer.getBoxFull(rpf, new int[]{idx, idx, idx, idx, idx + 1, idx + 1});
                }
                break;
            }
            case Plank: {
                this.modelByTypeAndMeta = new RenderPatch[this.max][1][];
                for (int i = 0; i < this.max; ++i) {
                    this.modelByTypeAndMeta[i][0] = CustomRenderer.getBoxFull(rpf, new int[]{i, i, i, i, i, i});
                }
                break;
            }
            case Slab: {
                this.modelByTypeAndMeta = new RenderPatch[this.max][2][];
                for (int i = 0; i < this.max; ++i) {
                    this.modelByTypeAndMeta[i][0] = CustomRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 8, 0, 16, i, false);
                    this.modelByTypeAndMeta[i][1] = CustomRenderer.getBoxSingleTextureInt(rpf, 0, 16, 8, 16, 0, 16, i, false);
                }
                break;
            }
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int woodType = GWM_Util.objectToInt(mapDataCtx.getBlockTileEntityField(this.nbtKey), 0);
        if (woodType < 0 || woodType >= this.max) {
            woodType = 0;
        }
        int meta = mapDataCtx.getBlockData();
        switch (this.type) {
            case Wood: {
                meta = ((meta & 0xC) >> 2) % 3;
                break;
            }
            case Plank: {
                meta = 0;
                break;
            }
            case Slab: {
                meta = ((meta & 8) >> 3) % 2;
            }
        }
        return this.modelByTypeAndMeta[woodType][meta];
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        if (this.nbtFieldsNeeded == null) {
            this.nbtFieldsNeeded = new String[]{this.nbtKey};
        }
        return this.nbtFieldsNeeded;
    }

    public static enum BlockType {
        Wood,
        Plank,
        Slab;

    }
}

