/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.CarpentersBlocksRenderer;
import org.dynmap.hdmap.renderer.FenceGateBase;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CarpentersFenceRenderer
extends FenceGateBase {
    RenderPatch[][][] postVersions;
    RenderPatch[][][] wallVersions;
    private static final int SIDE_XP = 1;
    private static final int SIDE_XN = 2;
    private static final int SIDE_X = 3;
    private static final int SIDE_ZP = 4;
    private static final int SIDE_ZN = 8;
    private static final int SIDE_Z = 12;
    private static final int SIDE_YP = 16;
    private static int[][] sides = new int[][]{{1, 0, 0, 1}, {-1, 0, 0, 2}, {0, 0, 1, 4}, {0, 0, -1, 8}};
    int thisBlockId;
    static String[] nbtFieldsNeeded = new String[]{"cbMetadata", "cbAttrList"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        String lid;
        int i;
        this.thisBlockId = blkid;
        this.postVersions = new RenderPatch[8][][];
        this.postVersions[0] = this.makeFencePostVersions(rpf);
        this.postVersions[6] = this.makeWallPostVersions(rpf);
        this.wallVersions = new RenderPatch[8][][];
        this.wallVersions[0] = this.makeFenceWallVersions(rpf);
        this.wallVersions[6] = this.makeWallWallVersions(rpf);
        for (i = 1; i < this.postVersions.length; ++i) {
            if (this.postVersions[i] == null) {
                this.postVersions[i] = this.postVersions[0];
            }
            if (this.wallVersions[i] != null) continue;
            this.wallVersions[i] = this.wallVersions[0];
        }
        link_ids.set(blkid);
        i = 0;
        while ((lid = custparm.get("link" + i)) != null) {
            link_ids.set(GWM_Util.blockNameToId(lid));
            ++i;
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    private RenderPatch[][] makeWallWallVersions(RenderPatchFactory rpf) {
        RenderPatch[][] ret = new RenderPatch[][]{CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 13, 5, 11, 0, false), CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 5, 11, 0, 13, 0, 16, 0, false), CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 5, 11, 0, false), CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 5, 11, 0, 16, 0, 16, 0, false)};
        return ret;
    }

    private RenderPatch[][] makeFenceWallVersions(RenderPatchFactory rpf) {
        RenderPatch[][] ret = new RenderPatch[][]{CarpentersFenceRenderer.combineMultiple(new RenderPatch[][]{CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 0, 16, 12, 15, 7, 9, 0, false), CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 0, 16, 6, 9, 7, 9, 0, false)}), CarpentersFenceRenderer.combineMultiple(new RenderPatch[][]{CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 7, 9, 12, 15, 0, 16, 0, false), CarpentersFenceRenderer.getBoxSingleTextureInt(rpf, 7, 9, 6, 9, 0, 16, 0, false)})};
        return ret;
    }

    private RenderPatch[][] makeWallPostVersions(RenderPatchFactory rpf) {
        RenderPatch[][] ret = new RenderPatch[32][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchIds = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < 32; ++i) {
            int ymax;
            CarpentersFenceRenderer.addBoxInt(rpf, list, 4, 12, 0, 16, 4, 12, patchIds);
            int n = ymax = (i & 0x10) == 0 ? 13 : 16;
            if ((i & 2) == 2) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 0, 4, 0, ymax, 5, 11, patchIds);
            }
            if ((i & 1) == 1) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 12, 16, 0, ymax, 5, 11, patchIds);
            }
            if ((i & 8) == 8) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 5, 11, 0, ymax, 0, 4, patchIds);
            }
            if ((i & 4) == 4) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 5, 11, 0, ymax, 12, 16, patchIds);
            }
            ret[i] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
        return ret;
    }

    private RenderPatch[][] makeFencePostVersions(RenderPatchFactory rpf) {
        RenderPatch[][] ret = new RenderPatch[16][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] patchIds = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < 16; ++i) {
            CarpentersFenceRenderer.addBoxInt(rpf, list, 6, 10, 0, 16, 6, 10, patchIds);
            if ((i & 2) == 2) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 0, 6, 12, 15, 7, 9, patchIds);
                CarpentersFenceRenderer.addBoxInt(rpf, list, 0, 6, 6, 9, 7, 9, patchIds);
            }
            if ((i & 1) == 1) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 10, 16, 12, 15, 7, 9, patchIds);
                CarpentersFenceRenderer.addBoxInt(rpf, list, 10, 16, 6, 9, 7, 9, patchIds);
            }
            if ((i & 8) == 8) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 7, 9, 12, 15, 0, 6, patchIds);
                CarpentersFenceRenderer.addBoxInt(rpf, list, 7, 9, 6, 9, 0, 6, patchIds);
            }
            if ((i & 4) == 4) {
                CarpentersFenceRenderer.addBoxInt(rpf, list, 7, 9, 12, 15, 10, 16, patchIds);
                CarpentersFenceRenderer.addBoxInt(rpf, list, 7, 9, 6, 9, 10, 16, patchIds);
            }
            ret[i] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
        return ret;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int meta = GWM_Util.objectToInt(ctx.getBlockTileEntityField("cbMetadata"), 0);
        if (meta < 0 || meta >= this.postVersions.length) {
            meta = 6;
        }
        boolean check_yplus = meta == 6;
        boolean allConnectsAreThisBlock = true;
        int connect = 0;
        for (int i = 0; i < sides.length; ++i) {
            int id = ctx.getBlockTypeIDAt(sides[i][0], sides[i][1], sides[i][2]);
            if (id == 0) continue;
            if (id == this.thisBlockId) {
                connect |= sides[i][3];
                continue;
            }
            if (!link_ids.get(id) && TexturePack.HDTextureMap.getTransparency(id) != TexturePack.BlockTransparency.OPAQUE) continue;
            connect |= sides[i][3];
            allConnectsAreThisBlock = false;
        }
        if (check_yplus && ctx.getBlockTypeIDAt(0, 1, 0) > 0) {
            connect |= 0x10;
        }
        if (allConnectsAreThisBlock && this.wallVersions[meta] != null && ((connect & 0xF) == 3 || (connect & 0xF) == 12)) {
            switch (connect) {
                case 3: {
                    if (this.wallVersions[meta][0] == null) break;
                    return this.wallVersions[meta][0];
                }
                case 12: {
                    if (this.wallVersions[meta][1] == null) break;
                    return this.wallVersions[meta][1];
                }
                case 19: {
                    if (this.wallVersions[meta][2] == null) break;
                    return this.wallVersions[meta][2];
                }
                case 28: {
                    if (this.wallVersions[meta][3] == null) break;
                    return this.wallVersions[meta][3];
                }
            }
        }
        return this.postVersions[meta][connect];
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, new CarpentersBlocksRenderer.TextureSelector(mapDataCtx));
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }
}

