/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.modsupport.botania.BotaniaSupport;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class BotaniaFlowerRenderer
extends CustomRenderer {
    RenderPatch[] model;
    RenderPatch[][] models;
    boolean plain;
    static String[] nbtFieldsNeeded = new String[]{"subTileName"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        String blockType = custparm.get("type");
        boolean bl = this.plain = custparm.get("plain") != null && custparm.get("plain").equals("true");
        if (blockType != null && blockType.equals("floating")) {
            double flowerMinXZ = 0.25;
            double flowerMaxXZ = 1.0 - flowerMinXZ;
            double flowerMinY = 0.3125;
            double flowerMaxY = flowerMinY + 0.5;
            this.model = BotaniaFlowerRenderer.combineMultiple(new RenderPatch[][]{BotaniaFlowerRenderer.getBoxMultiTextureInt(rpf, 3, 13, 3, 5, 3, 13, 0), BotaniaFlowerRenderer.combineMultiple(rpf.getPatch(flowerMinXZ, flowerMinY, flowerMinXZ, flowerMaxXZ, flowerMinY, flowerMaxXZ, flowerMinXZ, flowerMaxY, flowerMinXZ, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 6), rpf.getPatch(flowerMinXZ, flowerMinY, flowerMaxXZ, flowerMaxXZ, flowerMinY, flowerMinXZ, flowerMinXZ, flowerMaxY, flowerMaxXZ, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 6))});
            this.models = new RenderPatch[8][];
            this.models[0] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 3, 10, 0);
            this.models[1] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, -3, 8, 1);
            this.models[2] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 3, 15, 0);
            this.models[3] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 2, -14, 3);
            this.models[4] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 0, 7, 0);
            this.models[5] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 1, -9, -2);
            this.models[6] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, -2, 9, 0);
            this.models[7] = BotaniaFlowerRenderer.getRotatedSet(rpf, this.model, 3, 12, -2);
        }
        if (this.model == null) {
            double off = (Math.sqrt(2.0) - 1.0) / 2.0;
            double high = 1.0 - off;
            double low = off;
            this.model = BotaniaFlowerRenderer.combineMultiple(rpf.getPatch(low, 0.0, low, high, 0.0, high, low, 1.0, low, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 6), rpf.getPatch(low, 0.0, high, high, 0.0, low, low, 1.0, high, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.BOTH, 6));
        }
        return super.initializeRenderer(rpf, blkid, blockdatamask, custparm);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        if (this.models != null) {
            int x = mapDataCtx.getX();
            int y = mapDataCtx.getY();
            int z = mapDataCtx.getZ();
            int posHashThing = x * x + y * x + x * z + z * -z + y * z + y * -y;
            return this.models[posHashThing & 7];
        }
        return this.model;
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        if (this.plain) {
            return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, null);
        }
        Object objName = mapDataCtx.getBlockTileEntityField("subTileName");
        int tex = -1;
        if (objName instanceof String) {
            tex = BotaniaSupport.getTextureForFlower((String)objName);
        }
        return new CustomRendererData(this.getRenderPatchList(mapDataCtx), null, tex != -1 ? new TextureSelector(tex) : null);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    static class TextureSelector
    implements CustomTextureMapper {
        private final int[] tex;

        public TextureSelector(int tex) {
            this.tex = new int[]{tex};
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (patchId >= 6) {
                return this.tex;
            }
            return null;
        }
    }
}

