/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.hdmap.renderer.ArchitectureCraftModel;
import org.dynmap.modsupport.GWM_Util;
import org.dynmap.modsupport.SimpleColorMultiplier;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.CustomRendererData;
import org.dynmap.renderer.CustomTextureMapper;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class ArchitectureCraftShapeRenderer
extends CustomRenderer {
    RenderPatch[] basicBox;
    RenderPatch[][][][] renderPatchesPerShape;
    private static final int[] patchlist = new int[]{1, 4, 2, 5, 0, 3};
    private static final int[] patchlistZero = new int[]{0, 0, 0, 0, 0, 0};
    private static final int textureIdForOptionalSecondary = 12;
    static String[] nbtFieldsNeeded = new String[]{"turn", "Shape", "side", "BaseName", "BaseData", "Name2", "Data2"};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, patchlist);
        this.basicBox = list.toArray(new RenderPatch[patchlist.length]);
        this.renderPatchesPerShape = new RenderPatch[256][6][4][];
        for (int i = 0; i < 256; ++i) {
            this.renderPatchesPerShape[i][0][0] = this.getRenderPatchForShape(rpf, i);
        }
        return true;
    }

    RenderPatch[] getRenderPatchForShape(RenderPatchFactory rpf, int id) {
        switch (id) {
            case 0: {
                return ArchitectureCraftShapeRenderer.makeRoofPatches(rpf, 12);
            }
            case 1: {
                return ArchitectureCraftShapeRenderer.makeRoofOuterCornerPatches(rpf, 12);
            }
            case 2: {
                return ArchitectureCraftShapeRenderer.makeRoofInnerCornerPatches(rpf, 12);
            }
            case 3: {
                return this.makeRoofRidgePatches(rpf);
            }
            case 4: {
                return this.makeRoofSpikeTopPatches(rpf);
            }
            case 5: {
                return this.makeRoofValleyPatches(rpf);
            }
            case 6: {
                return this.makeRoofSpikeValleyPatches(rpf);
            }
            case 7: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang");
            }
            case 8: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_outer_corner");
            }
            case 9: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_inner_corner");
            }
            case 10: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_full_r8h16");
            }
            case 11: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_half_r8h16");
            }
            case 12: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_quarter_r8h16");
            }
            case 13: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_quarter_r16h16");
            }
            case 14: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "round_inner_corner");
            }
            case 15: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_r6h16");
            }
            case 16: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_r4h16");
            }
            case 17: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cylinder_r2h16");
            }
            case 18: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "bevelled_outer_corner");
            }
            case 19: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "bevelled_inner_corner");
            }
            case 20: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "pillar_base");
            }
            case 21: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "doric_capital");
            }
            case 22: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "ionic_capital");
            }
            case 23: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "corinthian_capital");
            }
            case 24: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "doric_triglyph");
            }
            case 25: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "doric_triglyph_corner");
            }
            case 26: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "doric_metope");
            }
            case 27: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "architrave");
            }
            case 28: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "architrave_corner");
            }
            case 30: {
                return ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 7, 9, 6, false);
            }
            case 31: {
                return ArchitectureCraftShapeRenderer.combineMultiple(new RenderPatch[][]{ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 6, 10, 0, 16, 6, 10, 0, false), ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 0, 9, 0, 16, 7, 9, 6, false), ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 7, 9, 0, 16, 9, 16, 6, false)});
            }
            case 32: {
                return ArchitectureCraftShapeRenderer.combineMultiple(new RenderPatch[][]{ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 6, 10, 0, 16, 6, 10, 0, false), ArchitectureCraftShapeRenderer.getBoxSingleTextureInt(rpf, 0, 16, 0, 16, 7, 9, 6, false)});
            }
            case 33: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_full_r8");
            }
            case 34: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_half_r8");
            }
            case 35: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_quarter_r8");
            }
            case 36: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_eighth_r8");
            }
            case 37: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_eighth_r16");
            }
            case 38: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "sphere_eighth_r16_rev");
            }
            case 40: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_lh");
            }
            case 41: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_rh");
            }
            case 42: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_end_lh");
            }
            case 43: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_end_rh");
            }
            case 44: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_ridge");
            }
            case 45: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "roof_overhang_gable_valley");
            }
            case 50: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_lh");
            }
            case 51: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_rh");
            }
            case 52: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_end_lh");
            }
            case 53: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_end_rh");
            }
            case 54: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_ridge");
            }
            case 55: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_valley");
            }
            case 56: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "cornice_bottom");
            }
            case 60: {
                break;
            }
            case 61: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d1");
            }
            case 62: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d2");
            }
            case 63: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d3a");
            }
            case 64: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d3b");
            }
            case 65: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d3c");
            }
            case 66: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d4a");
            }
            case 67: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d4b");
            }
            case 68: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "arch_d4c");
            }
            case 70: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_plain_bottom");
            }
            case 71: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_plain");
            }
            case 72: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_plain_top");
            }
            case 73: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_fancy");
            }
            case 74: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_fancy_corner");
            }
            case 75: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_fancy_with_newel");
            }
            case 76: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_fancy_newel");
            }
            case 77: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_plain");
            }
            case 78: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_plain_outer_corner");
            }
            case 79: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_plain_with_newel");
            }
            case 80: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_plain_end");
            }
            case 81: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_fancy_newel_tall");
            }
            case 82: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_plain_inner_corner");
            }
            case 83: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_plain_end");
            }
            case 84: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_fancy_bottom");
            }
            case 85: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_fancy");
            }
            case 86: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_fancy_top");
            }
            case 87: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_fancy_end");
            }
            case 88: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "balustrade_stair_plain_inner_corner");
            }
            case 90: {
                return this.makeSlab(rpf);
            }
            case 91: {
                return ArchitectureCraftShapeRenderer.makeStairs(rpf, 12);
            }
            case 92: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "stairs_outer_corner");
            }
            case 93: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "stairs_inner_corner");
            }
            case 94: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.5, 1.0);
            }
            case 95: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.5);
            }
            case 96: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.6666, 1.0);
            }
            case 97: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.3333, 0.6666);
            }
            case 98: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.3333);
            }
            case 99: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.75, 1.0);
            }
            case 100: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.5, 0.75);
            }
            case 101: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.25, 0.5);
            }
            case 102: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.25);
            }
            case 103: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.5, 1.0);
            }
            case 104: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.5);
            }
            case 105: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.6666, 1.0);
            }
            case 106: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.3333, 0.6666);
            }
            case 107: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.3333);
            }
            case 108: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.75, 1.0);
            }
            case 109: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.5, 0.75);
            }
            case 110: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.25, 0.5);
            }
            case 111: {
                return ArchitectureCraftShapeRenderer.makeSimpleSlopePatches(rpf, 0.0, 0.25);
            }
            case 112: {
                return ArchitectureCraftShapeRenderer.makeRoofPatches(rpf, 12);
            }
            case 113: {
                return this.basicBox;
            }
            case 114: {
                return this.makeSlab(rpf);
            }
            case 115: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "angled_roof_ridge");
            }
            case 116: {
                return ArchitectureCraftShapeRenderer.makePatchesFromModel(rpf, "double_roof_tile");
            }
        }
        return null;
    }

    private RenderPatch[] makeRoofValleyPatches(RenderPatchFactory rpf) {
        RenderPatch[] ret = new RenderPatch[]{rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.5, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.0, 0.5, 0.5, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.5, 0.5, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0)};
        return ret;
    }

    private RenderPatch[] makeRoofSpikeValleyPatches(RenderPatchFactory rpf) {
        RenderPatch[] ret = new RenderPatch[]{rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 1.0, 0.0, 0.5, 0.5, 0.5, 1.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(1.0, 1.0, 0.0, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(1.0, 1.0, 1.0, 0.5, 0.5, 0.5, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(0.0, 1.0, 1.0, 0.5, 0.5, 0.5, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0)};
        return ret;
    }

    private RenderPatch[] makeRoofSpikeTopPatches(RenderPatchFactory rpf) {
        RenderPatch[] ret = new RenderPatch[]{rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0), rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.5, 0.5, 0.5, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12), rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12)};
        return ret;
    }

    private RenderPatch[] makeRoofRidgePatches(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getTriangleAutoTexCoords(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5, 0.5, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.5, 0.5, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 12));
        list.add(rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.5, RenderPatchFactory.SideVisible.TOP, 12));
        return list.toArray(new RenderPatch[list.size()]);
    }

    private RenderPatch[] makeSlab(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        ArchitectureCraftShapeRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0, new int[]{0, 12, 0, 0, 0, 0, 0});
        return list.toArray(new RenderPatch[list.size()]);
    }

    public static RenderPatch[] makeStairs(RenderPatchFactory rpf, int secondary) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] localPatches = new int[]{0, secondary, 0, 0, secondary, 0};
        ArchitectureCraftShapeRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 0.5, 0.0, 1.0, localPatches);
        ArchitectureCraftShapeRenderer.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.5, 1.0, localPatches);
        return list.toArray(new RenderPatch[list.size()]);
    }

    public static RenderPatch[] makeRoofInnerCornerPatches(RenderPatchFactory rpf, int secondary) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getTriangleAutoTexCoords(0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, secondary));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, secondary));
        list.add(rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        RenderPatch[] renderPatches = list.toArray(new RenderPatch[list.size()]);
        for (int i = 0; i < renderPatches.length; ++i) {
            renderPatches[i] = rpf.getRotatedPatch(renderPatches[i], 0, 90, 0, renderPatches[i].getTextureIndex());
        }
        return renderPatches;
    }

    public static RenderPatch[] makeRoofOuterCornerPatches(RenderPatchFactory rpf, int secondary) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, secondary));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, secondary));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
        list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        RenderPatch[] renderPatches = list.toArray(new RenderPatch[list.size()]);
        for (int i = 0; i < renderPatches.length; ++i) {
            renderPatches[i] = rpf.getRotatedPatch(renderPatches[i], 0, 90, 0, renderPatches[i].getTextureIndex());
        }
        return renderPatches;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        Object shape = mapDataCtx.getBlockTileEntityField("Shape");
        RenderPatchFactory rpf = mapDataCtx.getPatchFactory();
        if (shape instanceof Integer) {
            int actualShape = (Integer)shape;
            Object turnObj = mapDataCtx.getBlockTileEntityField("turn");
            Object sideObj = mapDataCtx.getBlockTileEntityField("side");
            byte turn = 0;
            if (turnObj instanceof Byte) {
                turn = (Byte)turnObj;
            }
            byte side = 0;
            if (sideObj instanceof Byte) {
                side = (Byte)sideObj;
            }
            if (this.renderPatchesPerShape[actualShape][0][0] == null) {
                this.renderPatchesPerShape[actualShape][0][0] = this.getRenderPatchForShape(rpf, actualShape);
            }
            if (this.renderPatchesPerShape[actualShape][side][turn] == null) {
                RenderPatch[] arr = this.renderPatchesPerShape[actualShape][0][0];
                if (arr != null && arr.length > 0) {
                    if (turn != 0 || side != 0) {
                        arr = (RenderPatch[])arr.clone();
                        int xrot = 0;
                        int yrot = 0;
                        int zrot = 0;
                        for (int i = 0; i < arr.length; ++i) {
                            switch (ForgeDirection.getOrientation((int)side)) {
                                case DOWN: {
                                    yrot = 360 - 90 * turn;
                                    break;
                                }
                                case UP: {
                                    yrot = 90 * turn;
                                    arr[i] = rpf.getRotatedPatch(arr[i], 180, 0, 0, arr[i].getTextureIndex());
                                    break;
                                }
                                case NORTH: {
                                    zrot = 360 - 90 * turn;
                                    arr[i] = rpf.getRotatedPatch(arr[i], 270, 0, 0, arr[i].getTextureIndex());
                                    break;
                                }
                                case SOUTH: {
                                    zrot = 90 * turn;
                                    arr[i] = rpf.getRotatedPatch(arr[i], 90, 0, 180, arr[i].getTextureIndex());
                                    break;
                                }
                                case WEST: {
                                    xrot = 360 - 90 * turn;
                                    arr[i] = rpf.getRotatedPatch(arr[i], 0, 270, 90, arr[i].getTextureIndex());
                                    break;
                                }
                                case EAST: {
                                    xrot = 90 * turn;
                                    arr[i] = rpf.getRotatedPatch(arr[i], 0, 90, 270, arr[i].getTextureIndex());
                                    break;
                                }
                            }
                            arr[i] = rpf.getRotatedPatchAutoTexCoords(arr[i], xrot, yrot, zrot, arr[i].getTextureIndex());
                        }
                    }
                    this.renderPatchesPerShape[actualShape][side][turn] = arr;
                    return arr;
                }
            } else {
                return this.renderPatchesPerShape[actualShape][side][turn];
            }
        }
        return this.basicBox;
    }

    public static RenderPatch[] makeRoofPatches(RenderPatchFactory rpf, int secondary) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getPatch(0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, secondary));
        list.add(rpf.getTriangleAutoTexCoords(0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.BOTTOM, 0));
        list.add(rpf.getTriangleAutoTexCoords(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        return list.toArray(new RenderPatch[list.size()]);
    }

    private static RenderPatch[] makeSimpleSlopePatches(RenderPatchFactory rpf, double minY, double maxY) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        list.add(rpf.getPatch(0.0, maxY, 1.0, 1.0, maxY, 1.0, 0.0, minY, 0.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 12));
        if (minY > 0.0) {
            list.add(rpf.getPatch(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, minY, RenderPatchFactory.SideVisible.TOP, 0));
        }
        list.add(rpf.getTriangleAutoTexCoords(0.0, minY, 0.0, 0.0, minY, 1.0, 0.0, maxY, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        if (minY > 0.0) {
            list.add(rpf.getPatch(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, minY, RenderPatchFactory.SideVisible.TOP, 0));
        }
        list.add(rpf.getTriangleAutoTexCoords(1.0, minY, 1.0, 1.0, minY, 0.0, 1.0, maxY, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        if (minY > 0.0) {
            list.add(rpf.getPatch(1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, minY, RenderPatchFactory.SideVisible.TOP, 0));
        }
        list.add(rpf.getPatch(0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, maxY, RenderPatchFactory.SideVisible.TOP, 0));
        list.add(rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0));
        return list.toArray(new RenderPatch[list.size()]);
    }

    private static RenderPatch[] makePatchesFromModel(RenderPatchFactory rpf, String modelName) {
        ArchitectureCraftModel mod = ArchitectureCraftModel.getModel("shape/" + modelName + ".smeg");
        if (mod == null) {
            return new RenderPatch[0];
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int lowestTextureNum = 100;
        for (ArchitectureCraftModel.Face f : mod.faces) {
            if (f.texture >= lowestTextureNum) continue;
            lowestTextureNum = f.texture;
        }
        for (ArchitectureCraftModel.Face f : mod.faces) {
            for (int[] t : f.triangles) {
                double[] a = f.vertices[t[0]];
                double[] b = f.vertices[t[1]];
                double[] c = f.vertices[t[2]];
                list.add(rpf.getTriangleAutoTexCoords(a[0] + 0.5, a[1] + 0.5, a[2] + 0.5, b[0] + 0.5, b[1] + 0.5, b[2] + 0.5, c[0] + 0.5, c[1] + 0.5, c[2] + 0.5, RenderPatchFactory.SideVisible.TOP, f.texture == lowestTextureNum ? 0 : 12));
            }
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public CustomRendererData getRenderData(MapDataContext mapDataCtx) {
        return new ArchitectureCraftCustomRendererData(mapDataCtx);
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return nbtFieldsNeeded;
    }

    class ArchitectureCraftCustomRendererData
    extends CustomRendererData
    implements CustomTextureMapper {
        private MapDataContext mapDataCtx;
        int[][] textures;
        int[][] textures2;
        boolean foundSecondaryTextures;
        CustomColorMultiplier colorMultiplier;
        CustomColorMultiplier colorMultiplier2;

        public ArchitectureCraftCustomRendererData(MapDataContext mapDataCtx) {
            TexturePack.HDTextureMap map;
            int blockId;
            int data;
            String blockName;
            super(ArchitectureCraftShapeRenderer.this.getRenderPatchList(mapDataCtx), null, null);
            this.textures = new int[6][0];
            this.textures2 = new int[][]{{-1}, {-1}, {-1}, {-1}, {-1}, {-1}};
            this.foundSecondaryTextures = false;
            this.colorMultiplier = null;
            this.colorMultiplier2 = null;
            this.mapDataCtx = mapDataCtx;
            Object blockNameObj = mapDataCtx.getBlockTileEntityField("BaseName");
            Object blockDataObj = mapDataCtx.getBlockTileEntityField("BaseData");
            Object blockName2Obj = mapDataCtx.getBlockTileEntityField("Name2");
            Object blockData2Obj = mapDataCtx.getBlockTileEntityField("Data2");
            if (blockName2Obj instanceof String) {
                blockName = (String)blockName2Obj;
                data = 0;
                if (blockDataObj instanceof Integer) {
                    data = (Integer)blockData2Obj;
                }
                blockId = GWM_Util.blockNameToId(blockName);
                map = TexturePack.HDTextureMap.getMap(blockId, data, 0);
                this.textures2 = new int[][]{{map.getIndexForFace(0)}, {map.getIndexForFace(1)}, {map.getIndexForFace(2)}, {map.getIndexForFace(3)}, {map.getIndexForFace(4)}, {map.getIndexForFace(5)}};
                this.colorMultiplier2 = new SimpleColorMultiplier(map.getColorMult());
                this.foundSecondaryTextures = true;
            }
            if (blockNameObj instanceof String) {
                blockName = (String)blockNameObj;
                data = 0;
                if (blockDataObj instanceof Integer) {
                    data = (Integer)blockDataObj;
                }
                blockId = GWM_Util.blockNameToId(blockName);
                map = TexturePack.HDTextureMap.getMap(blockId, data, 0);
                this.textures = new int[][]{{map.getIndexForFace(0)}, {map.getIndexForFace(1)}, {map.getIndexForFace(2)}, {map.getIndexForFace(3)}, {map.getIndexForFace(4)}, {map.getIndexForFace(5)}};
                this.colorMultiplier = new SimpleColorMultiplier(map.getColorMult());
            }
        }

        @Override
        public int[] getTextureLayersForPatchId(int patchId) {
            if (patchId >= 6 && patchId < 12) {
                return this.textures2[patchId - 6];
            }
            if (patchId >= 12 && patchId < 18) {
                if (this.foundSecondaryTextures) {
                    return this.textures2[patchId - 12];
                }
                patchId -= 12;
            }
            return this.textures[patchId];
        }

        @Override
        public CustomTextureMapper getCustomTextureMapper() {
            return this;
        }

        @Override
        public CustomColorMultiplier getCustomColorMultiplier(int patchId, int layer) {
            if (patchId >= 6 && patchId < 12) {
                return this.colorMultiplier2;
            }
            if (patchId >= 12 && patchId < 18 && this.foundSecondaryTextures) {
                return this.colorMultiplier2;
            }
            return this.colorMultiplier;
        }
    }
}

