/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.util.ResourceLocation;
import org.dynmap.Log;

public class ArchitectureCraftModel {
    public double[] bounds;
    public Face[] faces;
    public double[][] boxes;
    static Gson gson = new Gson();

    public static ArchitectureCraftModel fromResource(ResourceLocation location) {
        String objsonPath;
        String path = String.format("/assets/%s/%s", location.func_110624_b(), location.func_110623_a());
        InputStream in = ArchitectureCraftModel.class.getResourceAsStream(path);
        if (in == null && (in = ArchitectureCraftModel.class.getResourceAsStream(objsonPath = path.replace(".smeg", ".objson"))) == null) {
            Log.warning(String.format("Cannot find ArchitectureCraft model %s", path));
            return null;
        }
        ArchitectureCraftModel model = (ArchitectureCraftModel)gson.fromJson((Reader)new InputStreamReader(in), ArchitectureCraftModel.class);
        return model;
    }

    public static ResourceLocation resourceLocation(String path) {
        if (path.contains(":")) {
            return new ResourceLocation(path);
        }
        return new ResourceLocation("architecturecraft", path);
    }

    public static ResourceLocation modelLocation(String path) {
        return ArchitectureCraftModel.resourceLocation("models/" + path);
    }

    public static ArchitectureCraftModel getModel(String name) {
        ResourceLocation loc = ArchitectureCraftModel.modelLocation(name);
        return ArchitectureCraftModel.fromResource(loc);
    }

    public class Vector3 {
        double x;
        double y;
        double z;

        public Vector3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String toString() {
            return String.format("(%.3f,%.3f,%.3f)", this.x, this.y, this.z);
        }
    }

    public static class Face {
        public int texture;
        public double[][] vertices;
        public int[][] triangles;
        Vector3 normal;
    }
}

