/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.biome.BiomeGenBase;
import org.dynmap.forge.DynmapPlugin;
import org.dynmap.forge.GwmSubCommand;

public class GwmCommand
extends CommandBase {
    static final HashMap<String, GwmSubCommand> subCommands = new HashMap();
    private final DynmapPlugin dynmapPlugin;

    public GwmCommand(DynmapPlugin dynmapPlugin) {
        this.dynmapPlugin = dynmapPlugin;
        GwmCommand.registerSubCommand(new BiomeDumpSubCommand());
    }

    public static void registerSubCommand(GwmSubCommand subCommand) {
        subCommands.put(subCommand.name, subCommand);
    }

    public String func_71517_b() {
        return "gwm";
    }

    public String func_71518_a(ICommandSender sender) {
        return "See docs";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            return;
        }
        GwmSubCommand sub = subCommands.get(args[0]);
        if (sub != null) {
            String[] argsCopy = new String[args.length - 1];
            for (int i = 0; i < argsCopy.length; ++i) {
                argsCopy[i] = args[i + 1];
            }
            sub.process(sender, argsCopy);
        }
    }

    static class BiomeDumpSubCommand
    extends GwmSubCommand {
        protected BiomeDumpSubCommand() {
            super("biomedump");
        }

        @Override
        protected void process(ICommandSender sender, String[] args) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter("gwm-biomes-dump.txt"));
                BiomeGenBase[] list = BiomeGenBase.func_150565_n();
                for (int i = 0; i < list.length; ++i) {
                    BiomeGenBase bb = list[i];
                    if (bb == null) continue;
                    String id = bb.field_76791_y;
                    int grassColor = bb.func_150558_b(8, 128, 8) & 0xFFFFFF | 0x1000000;
                    int foliageColor = bb.func_150571_c(8, 128, 8) & 0xFFFFFF | 0x1000000;
                    int waterColor = bb.field_76759_H;
                    writer.write(String.format("biome:gwm_id=%s,grassColorMult=%X,foliageColorMult=%X,waterColorMult=%X\n", id, grassColor, foliageColor, waterColor));
                }
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

