/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.forge.ForgeMapChunkCache;
import org.dynmap.utils.MapChunkCache;

public class ForgeWorld
extends DynmapWorld {
    private World world = null;
    private final boolean skylight;
    private final boolean isnether;
    private final boolean istheend;
    private final String env;
    private DynmapLocation spawnloc = new DynmapLocation();
    private static boolean doMCPCMapping = false;
    private static boolean doSaveFolderMapping = false;
    private static int maxWorldHeight = 256;

    public static void setMCPCMapping() {
        doMCPCMapping = true;
    }

    public static void setSaveFolderMapping() {
        doSaveFolderMapping = true;
    }

    public static int getMaxWorldHeight() {
        return maxWorldHeight;
    }

    public static void setMaxWorldHeight(int h) {
        maxWorldHeight = h;
    }

    public static String getWorldName(World w) {
        String n;
        if (doMCPCMapping) {
            n = w.func_72912_H().func_76065_j();
        } else if (doSaveFolderMapping) {
            n = w.field_73011_w.field_76574_g == 0 ? w.func_72912_H().func_76065_j() : "DIM" + w.field_73011_w.field_76574_g;
        } else {
            n = w.func_72912_H().func_76065_j();
            WorldProvider wp = w.field_73011_w;
            switch (wp.field_76574_g) {
                case 0: {
                    break;
                }
                case -1: {
                    n = n + "_nether";
                    break;
                }
                case 1: {
                    n = n + "_the_end";
                    break;
                }
                default: {
                    n = n + "_" + wp.field_76574_g;
                }
            }
        }
        return n;
    }

    public ForgeWorld(World w) {
        this(ForgeWorld.getWorldName(w), w.func_72800_K(), 64, w.field_73011_w instanceof WorldProviderHell, w.field_73011_w instanceof WorldProviderEnd, w.field_73011_w.func_80007_l());
        this.setWorldLoaded(w);
    }

    public ForgeWorld(String name, int height, int sealevel, boolean nether, boolean the_end, String deftitle) {
        super(name, height > maxWorldHeight ? maxWorldHeight : height, sealevel);
        this.setTitle(deftitle);
        this.isnether = nether;
        this.istheend = the_end;
        boolean bl = this.skylight = !this.isnether && !this.istheend;
        this.env = this.isnether ? "nether" : (this.istheend ? "the_end" : "normal");
    }

    @Override
    public boolean isNether() {
        return this.isnether;
    }

    public boolean isTheEnd() {
        return this.istheend;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            ChunkCoordinates sloc = this.world.func_72861_E();
            this.spawnloc.x = sloc.field_71574_a;
            this.spawnloc.y = sloc.field_71572_b;
            this.spawnloc.z = sloc.field_71573_c;
            this.spawnloc.world = this.getName();
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.func_72820_D();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.func_72896_J();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.func_72911_I();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    public void setWorldLoaded(World w) {
        this.world = w;
        float[] lt = w.field_73011_w.field_76573_f;
        for (int i = 0; i < 16; ++i) {
            this.setBrightnessTableEntry(i, lt[i]);
        }
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_72957_l(x, y, z);
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.func_72976_f(x, z);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_72972_b(EnumSkyBlock.Sky, x, y, z);
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.world != null) {
            ForgeMapChunkCache c = new ForgeMapChunkCache();
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public World getWorld() {
        return this.world;
    }
}

