/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.dynmap.ConfigurationNode;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;

public class PlayerList {
    private DynmapServerInterface server;
    private HashSet<String> hiddenPlayerNames = new HashSet();
    private File hiddenPlayersFile;
    private ConfigurationNode configuration;
    private DynmapPlayer[] online;
    private HashMap<String, Set<String>> invisibility_asserts = new HashMap();
    private HashMap<String, Set<String>> visibility_asserts = new HashMap();

    public PlayerList(DynmapServerInterface server, File hiddenPlayersFile, ConfigurationNode configuration) {
        this.server = server;
        this.hiddenPlayersFile = hiddenPlayersFile;
        this.configuration = configuration;
        this.updateOnlinePlayers(null);
    }

    public void save() {
        try {
            FileOutputStream stream = new FileOutputStream(this.hiddenPlayersFile);
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            for (String player : this.hiddenPlayerNames) {
                writer.write(player);
                writer.write("\n");
            }
            writer.close();
            ((OutputStream)stream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            Scanner scanner = new Scanner(this.hiddenPlayersFile);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                this.hiddenPlayerNames.add(line);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            return;
        }
    }

    public void hide(String playerName) {
        this.hiddenPlayerNames.add(playerName.toLowerCase());
        this.save();
    }

    public void show(String playerName) {
        this.hiddenPlayerNames.remove(playerName.toLowerCase());
        this.save();
    }

    public void setVisible(String playerName, boolean visible) {
        if (visible ^ this.configuration.getBoolean("display-whitelist", false)) {
            this.show(playerName);
        } else {
            this.hide(playerName);
        }
    }

    public void assertVisiblilty(String playerName, boolean visible, String plugin_id) {
        playerName = playerName.toLowerCase();
        if (visible) {
            Set<String> ids = this.visibility_asserts.get(playerName);
            if (ids == null) {
                ids = new HashSet<String>();
                this.visibility_asserts.put(playerName, ids);
            }
            ids.add(plugin_id);
        } else {
            Set<String> ids = this.visibility_asserts.get(playerName);
            if (ids != null) {
                ids.remove(plugin_id);
                if (ids.isEmpty()) {
                    this.visibility_asserts.remove(playerName);
                }
            }
        }
    }

    public void assertInvisiblilty(String playerName, boolean invisible, String plugin_id) {
        playerName = playerName.toLowerCase();
        if (invisible) {
            Set<String> ids = this.invisibility_asserts.get(playerName);
            if (ids == null) {
                ids = new HashSet<String>();
                this.invisibility_asserts.put(playerName, ids);
            }
            ids.add(plugin_id);
        } else {
            Set<String> ids = this.invisibility_asserts.get(playerName);
            if (ids != null) {
                ids.remove(plugin_id);
                if (ids.isEmpty()) {
                    this.invisibility_asserts.remove(playerName);
                }
            }
        }
    }

    public List<DynmapPlayer> getVisiblePlayers(String worldName) {
        ArrayList<DynmapPlayer> visiblePlayers = new ArrayList<DynmapPlayer>();
        DynmapPlayer[] onlinePlayers = this.online;
        boolean useWhitelist = this.configuration.getBoolean("display-whitelist", false);
        for (int i = 0; i < onlinePlayers.length; ++i) {
            DynmapPlayer p = onlinePlayers[i];
            if (p == null || worldName != null && !p.getWorld().equals(worldName)) continue;
            String pname = p.getName().toLowerCase();
            if (!(useWhitelist ^ this.hiddenPlayerNames.contains(pname))) {
                if (this.invisibility_asserts.containsKey(pname)) continue;
                visiblePlayers.add(p);
                continue;
            }
            if (!this.visibility_asserts.containsKey(pname)) continue;
            visiblePlayers.add(p);
        }
        return visiblePlayers;
    }

    public List<DynmapPlayer> getVisiblePlayers() {
        return this.getVisiblePlayers(null);
    }

    public List<DynmapPlayer> getHiddenPlayers() {
        ArrayList<DynmapPlayer> hidden = new ArrayList<DynmapPlayer>();
        DynmapPlayer[] onlinePlayers = this.online;
        boolean useWhitelist = this.configuration.getBoolean("display-whitelist", false);
        for (int i = 0; i < onlinePlayers.length; ++i) {
            DynmapPlayer p = onlinePlayers[i];
            if (p == null) continue;
            String pname = p.getName().toLowerCase();
            if (!(useWhitelist ^ this.hiddenPlayerNames.contains(pname))) {
                if (!this.invisibility_asserts.containsKey(pname)) continue;
                hidden.add(p);
                continue;
            }
            if (this.visibility_asserts.containsKey(pname)) continue;
            hidden.add(p);
        }
        return hidden;
    }

    public boolean isVisiblePlayer(String p) {
        p = p.toLowerCase();
        boolean useWhitelist = this.configuration.getBoolean("display-whitelist", false);
        return !(useWhitelist ^ this.hiddenPlayerNames.contains(p)) && !this.invisibility_asserts.containsKey(p);
    }

    void updateOnlinePlayers(String skipone) {
        DynmapPlayer[] players = this.server.getOnlinePlayers();
        DynmapPlayer[] pl = new DynmapPlayer[players.length];
        System.arraycopy(players, 0, pl, 0, pl.length);
        if (skipone != null) {
            for (int i = 0; i < pl.length; ++i) {
                if (!pl[i].getName().equals(skipone)) continue;
                pl[i] = null;
            }
        }
        this.online = pl;
    }
}

