/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.craftingtweaks.CommonProxy;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.GuiClickEvent;
import net.blay09.mods.craftingtweaks.addon.HotkeyCheck;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.GuiTweakButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.blay09.mods.craftingtweaks.net.MessageBalance;
import net.blay09.mods.craftingtweaks.net.MessageClear;
import net.blay09.mods.craftingtweaks.net.MessageCompress;
import net.blay09.mods.craftingtweaks.net.MessageRotate;
import net.blay09.mods.craftingtweaks.net.MessageTransferStack;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    private static final int HELLO_TIMEOUT = 200;
    private static final List<String> tooltipList = Lists.newArrayList();
    private int helloTimeout;
    private boolean isServerSide;
    private boolean wasRotated;
    private boolean wasCleared;
    private boolean wasBalanced;
    private boolean wasToggleButtons;
    private boolean wasCompressed;
    private boolean wasDecompressed;
    private final ClientProvider clientProvider = new ClientProvider();
    private final KeyBinding keyRotate = new KeyBinding("key.craftingtweaks.rotate", 19, "key.categories.craftingtweaks");
    private final KeyBinding keyBalance = new KeyBinding("key.craftingtweaks.balance", 48, "key.categories.craftingtweaks");
    private final KeyBinding keyClear = new KeyBinding("key.craftingtweaks.clear", 46, "key.categories.craftingtweaks");
    private final KeyBinding keyToggleButtons = new KeyBinding("key.craftingtweaks.toggleButtons", 0, "key.categories.craftingtweaks");
    private final KeyBinding keyCompress = new KeyBinding("key.craftingtweaks.compress", 37, "key.categories.craftingtweaks");
    private final KeyBinding keyDecompress = new KeyBinding("key.craftingtweaks.decompress", 0, "key.categories.craftingtweaks");
    private KeyBinding keyTransferStack;
    private Slot mouseSlot;
    private HotkeyCheck hotkeyCheck;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyRotate);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBalance);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyClear);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyToggleButtons);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyCompress);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyDecompress);
        this.keyTransferStack = Minecraft.func_71410_x().field_71474_y.field_74351_w;
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.hotkeyCheck = (HotkeyCheck)event.buildSoftDependProxy("NotEnoughItems", "net.blay09.mods.craftingtweaks.addon.NEIHotkeyCheck");
    }

    @SubscribeEvent
    public void connectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.helloTimeout = 200;
        this.isServerSide = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiClick(GuiClickEvent event) {
        Container container;
        EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        if (entityPlayer != null && (container = entityPlayer.field_71070_bA) != null) {
            Slot mouseSlot = event.gui instanceof GuiContainer ? ((GuiContainer)event.gui).func_146975_c(event.mouseX, event.mouseY) : null;
            TweakProvider provider = CraftingTweaks.instance.getProvider(container);
            if (provider != null && this.keyTransferStack.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyTransferStack.func_151463_i()) && mouseSlot != null && mouseSlot.func_75216_d()) {
                ArrayList transferSlots = Lists.newArrayList();
                transferSlots.add(mouseSlot);
                if (Keyboard.isKeyDown((int)42)) {
                    ItemStack mouseSlotStack = mouseSlot.func_75211_c();
                    for (Object obj : container.field_75151_b) {
                        ItemStack slotStack;
                        Slot slot = (Slot)obj;
                        if (!slot.func_75216_d() || mouseSlot == slot || !(slotStack = slot.func_75211_c()).func_77969_a(mouseSlotStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseSlotStack)) continue;
                        transferSlots.add(slot);
                    }
                }
                if (this.isServerSide) {
                    for (Slot slot : transferSlots) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageTransferStack(0, slot.field_75222_d));
                    }
                } else {
                    for (Slot slot : transferSlots) {
                        this.clientProvider.transferIntoGrid(provider, (EntityPlayer)entityPlayer, container, 0, slot);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        if (entityPlayer != null) {
            if (this.helloTimeout > 0) {
                --this.helloTimeout;
                if (this.helloTimeout <= 0) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("This server does not have Crafting Tweaks installed. Functionality may be limited."));
                    this.isServerSide = false;
                }
            }
            if (this.hotkeyCheck != null && !this.hotkeyCheck.allowHotkeys()) {
                return;
            }
            boolean isShiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            Container container = entityPlayer.field_71070_bA;
            if (container != null) {
                GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
                TweakProvider provider = CraftingTweaks.instance.getProvider(container);
                if (provider != null) {
                    CraftingTweaks.ModSupportState config = CraftingTweaks.instance.getModSupportState(provider.getModId());
                    if (config == CraftingTweaks.ModSupportState.ENABLED || config == CraftingTweaks.ModSupportState.HOTKEYS_ONLY) {
                        if (this.keyRotate.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyRotate.func_151463_i())) {
                            if (!this.wasRotated) {
                                if (this.isServerSide) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageRotate(0, isShiftDown));
                                } else {
                                    this.clientProvider.rotateGrid(provider, (EntityPlayer)entityPlayer, container, 0, isShiftDown);
                                }
                                this.wasRotated = true;
                            }
                        } else {
                            this.wasRotated = false;
                        }
                        if (this.keyClear.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyClear.func_151463_i())) {
                            if (!this.wasCleared) {
                                if (this.isServerSide) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageClear(0, isShiftDown));
                                } else {
                                    this.clientProvider.clearGrid(provider, (EntityPlayer)entityPlayer, container, 0, isShiftDown);
                                }
                                this.wasCleared = true;
                            }
                        } else {
                            this.wasCleared = false;
                        }
                        if (this.keyBalance.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyBalance.func_151463_i())) {
                            if (!this.wasBalanced) {
                                if (this.isServerSide) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageBalance(0, isShiftDown));
                                } else if (isShiftDown) {
                                    this.clientProvider.spreadGrid(provider, (EntityPlayer)entityPlayer, container, 0);
                                } else {
                                    this.clientProvider.balanceGrid(provider, (EntityPlayer)entityPlayer, container, 0);
                                }
                                this.wasBalanced = true;
                            } else {
                                this.wasBalanced = false;
                            }
                        }
                    }
                    if (guiScreen instanceof GuiContainer && this.keyToggleButtons.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyToggleButtons.func_151463_i())) {
                        if (!this.wasToggleButtons) {
                            boolean bl = CraftingTweaks.hideButtons = !CraftingTweaks.hideButtons;
                            if (CraftingTweaks.hideButtons) {
                                Iterator it = guiScreen.field_146292_n.iterator();
                                while (it.hasNext()) {
                                    if (!(it.next() instanceof GuiTweakButton)) continue;
                                    it.remove();
                                }
                            } else {
                                this.initGui((GuiContainer)guiScreen);
                            }
                            CraftingTweaks.saveConfig();
                            this.wasToggleButtons = true;
                        } else {
                            this.wasToggleButtons = false;
                        }
                    }
                }
                if (guiScreen instanceof GuiContainer) {
                    if (this.keyCompress.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyCompress.func_151463_i())) {
                        if (!this.wasCompressed) {
                            if (this.mouseSlot != null) {
                                boolean isDecompress;
                                boolean bl = isDecompress = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                                if (this.isServerSide) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageCompress(this.mouseSlot.field_75222_d, isDecompress, !isShiftDown));
                                } else if (isDecompress && provider != null) {
                                    this.clientProvider.decompress(provider, (EntityPlayer)entityPlayer, container, this.mouseSlot, isShiftDown);
                                } else if (provider != null) {
                                    this.clientProvider.compress(provider, (EntityPlayer)entityPlayer, container, this.mouseSlot, !isShiftDown);
                                }
                            }
                            this.wasCompressed = true;
                        }
                    } else {
                        this.wasCompressed = false;
                    }
                    if (this.keyDecompress.func_151463_i() > 0 && Keyboard.isKeyDown((int)this.keyDecompress.func_151463_i())) {
                        if (!this.wasDecompressed) {
                            if (this.mouseSlot != null) {
                                if (this.isServerSide) {
                                    NetworkHandler.instance.sendToServer((IMessage)new MessageCompress(this.mouseSlot.field_75222_d, true, isShiftDown));
                                } else if (provider != null) {
                                    this.clientProvider.decompress(provider, (EntityPlayer)entityPlayer, container, this.mouseSlot, isShiftDown);
                                }
                            }
                            this.wasDecompressed = true;
                        }
                    } else {
                        this.wasDecompressed = false;
                    }
                }
            }
        }
    }

    private void initGui(GuiContainer guiContainer) {
        CraftingTweaks.ModSupportState config;
        TweakProvider provider = CraftingTweaks.instance.getProvider(guiContainer.field_147002_h);
        if (provider != null && ((config = CraftingTweaks.instance.getModSupportState(provider.getModId())) == CraftingTweaks.ModSupportState.ENABLED || config == CraftingTweaks.ModSupportState.BUTTONS_ONLY)) {
            provider.initGui(guiContainer, guiContainer.field_146292_n);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!CraftingTweaks.hideButtons && event.gui instanceof GuiContainer) {
            this.initGui((GuiContainer)event.gui);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui == null) {
            return;
        }
        this.mouseSlot = event.gui instanceof GuiContainer ? ((GuiContainer)event.gui).func_146975_c(event.mouseX, event.mouseY) : null;
        if (!CraftingTweaks.hideButtonTooltips) {
            tooltipList.clear();
            for (Object obj : event.gui.field_146292_n) {
                GuiButton button = (GuiButton)obj;
                if (!(button instanceof ITooltipProvider) || !button.func_146115_a()) continue;
                ((ITooltipProvider)button).addInformation(tooltipList);
                break;
            }
            if (!tooltipList.isEmpty()) {
                event.gui.func_146283_a(tooltipList, event.mouseX, event.mouseY);
            }
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.button instanceof GuiTweakButton) {
            event.button.func_146113_a(Minecraft.func_71410_x().func_147118_V());
            EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            Container container = entityPlayer.field_71070_bA;
            TweakProvider provider = CraftingTweaks.instance.getProvider(container);
            boolean isShiftDown = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            switch (((GuiTweakButton)event.button).getTweakOption()) {
                case Rotate: {
                    if (this.isServerSide) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageRotate(((GuiTweakButton)event.button).getTweakId(), isShiftDown));
                    } else {
                        this.clientProvider.rotateGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.button).getTweakId(), isShiftDown);
                    }
                    event.setCanceled(true);
                    break;
                }
                case Balance: {
                    if (this.isServerSide) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageBalance(((GuiTweakButton)event.button).getTweakId(), isShiftDown));
                    } else if (isShiftDown) {
                        this.clientProvider.spreadGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.button).getTweakId());
                    } else {
                        this.clientProvider.balanceGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.button).getTweakId());
                    }
                    event.setCanceled(true);
                    break;
                }
                case Clear: {
                    if (this.isServerSide) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageClear(((GuiTweakButton)event.button).getTweakId(), isShiftDown));
                    } else {
                        this.clientProvider.clearGrid(provider, (EntityPlayer)entityPlayer, container, ((GuiTweakButton)event.button).getTweakId(), isShiftDown);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public void receivedHello(EntityPlayer entityPlayer) {
        this.helloTimeout = 0;
        this.isServerSide = true;
    }
}

