/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.vanilla;

import com.falsepattern.chunk.internal.BlockPosUtil;
import com.falsepattern.chunk.internal.DataRegistryImpl;
import com.falsepattern.chunk.internal.impl.CustomPacketBlockChange;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={S23PacketBlockChange.class})
public abstract class S23PacketBlockChangeMixin
implements CustomPacketBlockChange {
    @Shadow(aliases={"field_148887_a"}, remap=false)
    private int xCoord;
    @Shadow(aliases={"field_148885_b"}, remap=false)
    private int yCoord;
    @Shadow(aliases={"field_148886_c"}, remap=false)
    private int zCoord;
    @Shadow
    public Block field_148883_d;
    @Shadow
    public int field_148884_e;

    @Override
    public void chunkapi$init(int x, int y, int z, Chunk chunk) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.field_148883_d = chunk.func_150810_a(x, y, z);
        this.field_148884_e = chunk.func_76628_c(x, y, z);
        DataRegistryImpl.writeBlockToPacket(chunk, x, y, z, (S23PacketBlockChange)this);
    }

    @Inject(method={"<init>(IIILnet/minecraft/world/World;)V"}, at={@At(value="RETURN")}, require=1)
    private void writeBlockToPacket(int x, int y, int z, World world, CallbackInfo ci) {
        Chunk chunk = world.func_72938_d(x, z);
        DataRegistryImpl.writeBlockToPacket(chunk, x & 0xF, y, z & 0xF, (S23PacketBlockChange)this);
    }

    @Overwrite
    public void func_148837_a(PacketBuffer data) throws IOException {
        long packed = data.readLong();
        this.xCoord = BlockPosUtil.getX(packed);
        this.yCoord = BlockPosUtil.getY(packed);
        this.zCoord = BlockPosUtil.getZ(packed);
        DataRegistryImpl.readBlockPacketFromBuffer((S23PacketBlockChange)this, data);
    }

    @Overwrite
    public void func_148840_b(PacketBuffer data) throws IOException {
        long packed = BlockPosUtil.packToLong(this.xCoord, this.yCoord, this.zCoord);
        data.writeLong(packed);
        DataRegistryImpl.writeBlockPacketToBuffer((S23PacketBlockChange)this, data);
    }

    @Override
    public void chunkapi$x(int value) {
        this.xCoord = value;
    }

    @Override
    public void chunkapi$y(int value) {
        this.yCoord = value;
    }

    @Override
    public void chunkapi$z(int value) {
        this.zCoord = value;
    }

    @Override
    public int chunkapi$x() {
        return this.xCoord;
    }

    @Override
    public int chunkapi$y() {
        return this.yCoord;
    }

    @Override
    public int chunkapi$z() {
        return this.zCoord;
    }
}

