/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.api;

import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.api.OrderedManager;
import com.falsepattern.chunk.internal.DataRegistryImpl;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.NonExtendable
public class DataRegistry {
    public static void registerDataManager(DataManager manager, int ordering) throws IllegalStateException, IllegalArgumentException {
        DataRegistryImpl.registerDataManager(manager, ordering);
    }

    @Deprecated
    public static void registerDataManager(DataManager manager) throws IllegalStateException, IllegalArgumentException {
        DataRegistryImpl.registerDataManager(manager, 0);
    }

    public static void disableDataManager(String domain, String id) throws IllegalStateException {
        DataRegistryImpl.disableDataManager(domain, id);
    }

    @Deprecated
    @Contract(pure=true)
    public static @Unmodifiable Set<String> getRegisteredManagers() {
        return DataRegistryImpl.getRegisteredManagers();
    }

    @Contract(pure=true)
    public static @Unmodifiable SortedSet<OrderedManager> getRegisteredManagersOrdered() {
        return DataRegistryImpl.getRegisteredManagersOrdered();
    }

    @Contract(mutates="param2")
    public static void cloneChunk(Chunk from, Chunk to) {
        DataRegistryImpl.cloneChunk(from, to);
    }

    @Contract(mutates="param3")
    public static void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage from, ExtendedBlockStorage to) {
        DataRegistryImpl.cloneSubChunk(fromChunk, from, to);
    }
}

