/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.item.AbstractInventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class StandardInventoryIterator
extends AbstractInventoryIterator {
    private final IInventory inv;
    private final ForgeDirection side;
    private boolean markedDirty = false;

    public StandardInventoryIterator(IInventory inv, ForgeDirection side, int[] allowedSlots) {
        super(StandardInventoryIterator.getInventorySlotIndices(inv, side), allowedSlots);
        this.inv = inv;
        this.side = side;
    }

    public StandardInventoryIterator(IInventory inv, ForgeDirection side, int[] inventorySlots, int[] allowedSlots) {
        super(inventorySlots, allowedSlots);
        this.inv = inv;
        this.side = side;
    }

    public static int[] getInventorySlotIndices(IInventory inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            return sided.func_94128_d(side.ordinal());
        }
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    @Override
    protected ItemStack getStackInSlot(int slot) {
        return this.inv.func_70301_a(slot);
    }

    protected void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    @Override
    protected boolean canAccess(ItemStack stack, int slot) {
        return this.canExtract(stack, slot) || this.canInsert(stack, slot);
    }

    protected boolean canExtract(ItemStack stack, int slot) {
        IInventory iInventory = this.inv;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)iInventory;
            if (this.side == ForgeDirection.UNKNOWN) {
                return true;
            }
            return sided.func_102008_b(slot, stack, this.side.ordinal());
        }
        return this.inv.func_94041_b(slot, stack);
    }

    protected boolean canInsert(ItemStack stack, int slot) {
        IInventory iInventory = this.inv;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)iInventory;
            if (this.side == ForgeDirection.UNKNOWN) {
                return true;
            }
            return sided.func_102007_a(slot, stack, this.side.ordinal());
        }
        return this.inv.func_94041_b(slot, stack);
    }

    @Override
    public ItemStack extract(int amount, boolean forced) {
        int slotIndex = this.getCurrentSlot();
        ItemStack inSlot = this.getStackInSlot(slotIndex);
        if (ItemUtil.isStackEmpty(inSlot)) {
            return null;
        }
        if (!forced && !this.canExtract(inSlot, slotIndex)) {
            return null;
        }
        int toExtract = Math.min(inSlot.field_77994_a, amount);
        ItemStack extracted = inSlot.func_77979_a(toExtract);
        this.setInventorySlotContents(slotIndex, inSlot.field_77994_a == 0 ? null : inSlot);
        this.markDirty();
        return extracted;
    }

    @Override
    public int insert(ImmutableItemStack stack, boolean forced) {
        if (stack.isEmpty()) {
            return 0;
        }
        int slotIndex = this.getCurrentSlot();
        ItemStack inSlot = this.getStackInSlot(slotIndex);
        if (!ItemUtil.isStackEmpty(inSlot) && !stack.matches(inSlot)) {
            return stack.getStackSize();
        }
        ItemStack partialCopy = stack.toStackFast();
        if (!forced && !this.canInsert(partialCopy, slotIndex)) {
            return stack.getStackSize();
        }
        int maxStack = this.getSlotStackLimit(slotIndex, partialCopy);
        if (!ItemUtil.isStackEmpty(inSlot)) {
            int toInsert = forced ? stack.getStackSize() : Math.min(maxStack - inSlot.field_77994_a, stack.getStackSize());
            inSlot.field_77994_a += toInsert;
            this.setInventorySlotContents(slotIndex, inSlot);
            this.markDirty();
            return stack.getStackSize() - toInsert;
        }
        int toInsert = forced ? stack.getStackSize() : Math.min(maxStack, stack.getStackSize());
        this.setInventorySlotContents(slotIndex, stack.toStack(toInsert));
        this.markDirty();
        return stack.getStackSize() - toInsert;
    }

    protected int getSlotStackLimit(int slot, ItemStack stack) {
        int existingMaxStack;
        int invStackLimit = this.inv.func_70297_j_();
        int n = existingMaxStack = stack == null ? 64 : stack.func_77976_d();
        if (invStackLimit > 64) {
            return invStackLimit / 64 * existingMaxStack;
        }
        return Math.min(invStackLimit, existingMaxStack);
    }

    protected void markDirty() {
        if (this.markedDirty) {
            return;
        }
        this.inv.func_70296_d();
        this.markedDirty = true;
    }
}

