/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.concurrent;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;

public class ThreadsafeCache<K, V> {
    private final int size;
    private final Object2ReferenceLinkedOpenHashMap<K, V> cache = new Object2ReferenceLinkedOpenHashMap();
    private final StampedLock lock = new StampedLock();
    private final Function<K, V> modelRetriever;
    private final boolean allowNulls;

    public ThreadsafeCache(int size, Function<K, V> modelRetriever, boolean allowNulls) {
        this.size = size;
        this.modelRetriever = modelRetriever;
        this.allowNulls = allowNulls;
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needToPopulate(K state) {
        long stamp = this.lock.readLock();
        try {
            boolean bl = !this.cache.containsKey(state);
            return bl;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getModelFromCache(K state) {
        long stamp = this.lock.readLock();
        try {
            V v = this.cache.get(state);
            return v;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V cacheModel(K state) {
        V model = this.modelRetriever.apply(state);
        long stamp = this.lock.writeLock();
        try {
            this.cache.putAndMoveToFirst(state, model);
            if (this.cache.size() >= this.size) {
                this.cache.removeLast();
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
        return model;
    }

    public V get(K key) {
        V model = this.getModelFromCache(key);
        if (model == null && (!this.allowNulls || this.needToPopulate(key))) {
            model = this.cacheModel(key);
        }
        return model;
    }
}

