/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing;

import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.PostProcessingHelper;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class CustomFramebuffer {
    public int framebufferWidth;
    public int framebufferHeight;
    public int framebufferObject;
    public int framebufferTexture;
    public int depthAttachment;
    private final int settings;
    private final int bufferBits;
    public static final int DEPTH_ENABLED = 1;
    public static final int DEPTH_TEXTURE = 3;
    public static final int STENCIL_BUFFER = 5;
    public static final int TEXTURE_LINEAR = 8;
    public static final int NO_ALPHA_CHANNEL = 16;
    public static final int HDR_COLORS = 32;
    private static ShaderProgram tonemapShader;
    private static int uMultiplier;
    private static float tonemapMultiplier;

    public CustomFramebuffer(int settings) {
        this.settings = settings;
        this.bufferBits = this.createBufferBits();
    }

    public CustomFramebuffer(int width, int height, int settings) {
        this(settings);
        this.createFramebuffer(width, height);
        this.unbindFramebuffer();
    }

    protected int createBufferBits() {
        int bits = 16384;
        if (this.isEnabled(1)) {
            bits |= 0x100;
        }
        if (this.isEnabled(5)) {
            bits |= 0x400;
        }
        return bits;
    }

    private int getTextureFormat() {
        if (this.isEnabled(32)) {
            if (this.isEnabled(16)) {
                return 34843;
            }
            return 34842;
        }
        if (this.isEnabled(16)) {
            return 32849;
        }
        return 32856;
    }

    private int getTextureFilter() {
        return this.isEnabled(8) ? 9729 : 9728;
    }

    protected boolean isEnabled(int bit) {
        return (this.settings & bit) != 0;
    }

    public void createBindFramebuffer(int width, int height) {
        this.createFramebuffer(width, height);
        this.bindFramebuffer();
    }

    public void createBindFramebuffer(int width, int height, boolean viewport) {
        this.createFramebuffer(width, height);
        this.bindFramebuffer(viewport);
    }

    protected void createFramebuffer(int width, int height) {
        this.checkDeleteFramebuffer();
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.framebufferObject = OpenGlHelper.func_153165_e();
        OpenGlHelper.func_153171_g((int)36160, (int)this.framebufferObject);
        this.framebufferTexture = this.createFramebufferAttachment();
        this.createDepthAttachment(width, height);
        this.clearCurrentFramebuffer();
        this.unbindFramebuffer();
    }

    protected void createDepthAttachment(int width, int height) {
        if (!this.isEnabled(1)) {
            return;
        }
        boolean stencil = this.isEnabled(5);
        if (this.isEnabled(3)) {
            int filter = this.getTextureFilter();
            this.depthAttachment = GL11.glGenTextures();
            GL11.glBindTexture((int)3553, (int)this.depthAttachment);
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)34892, (int)0);
            if (stencil) {
                GL11.glTexImage2D((int)3553, (int)0, (int)35056, (int)width, (int)height, (int)0, (int)34041, (int)34042, (IntBuffer)null);
            } else {
                GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)width, (int)height, (int)0, (int)6402, (int)5126, (IntBuffer)null);
            }
            OpenGlHelper.func_153188_a((int)36160, (int)36096, (int)3553, (int)this.depthAttachment, (int)0);
            if (stencil) {
                OpenGlHelper.func_153188_a((int)36160, (int)36128, (int)3553, (int)this.depthAttachment, (int)0);
            }
        } else {
            this.depthAttachment = OpenGlHelper.func_153185_f();
            OpenGlHelper.func_153176_h((int)36161, (int)this.depthAttachment);
            if (stencil) {
                OpenGlHelper.func_153186_a((int)36161, (int)35056, (int)this.framebufferWidth, (int)this.framebufferHeight);
                OpenGlHelper.func_153190_b((int)36160, (int)36096, (int)36161, (int)this.depthAttachment);
                OpenGlHelper.func_153190_b((int)36160, (int)36128, (int)36161, (int)this.depthAttachment);
            } else {
                OpenGlHelper.func_153186_a((int)36160, (int)33190, (int)this.framebufferWidth, (int)this.framebufferHeight);
                OpenGlHelper.func_153190_b((int)36160, (int)36096, (int)36161, (int)this.depthAttachment);
            }
        }
    }

    public int createFramebufferAttachment() {
        return this.createFramebufferAttachment(0);
    }

    public int createFramebufferAttachment(int slot) {
        int texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)this.getTextureFormat(), (int)this.framebufferWidth, (int)this.framebufferHeight, (int)0, (int)(this.isEnabled(16) ? 6407 : 6408), (int)5121, (ByteBuffer)null);
        int filter = this.getTextureFilter();
        GL11.glTexParameterf((int)3553, (int)10241, (float)filter);
        GL11.glTexParameterf((int)3553, (int)10240, (float)filter);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        OpenGlHelper.func_153188_a((int)36160, (int)(0x8CE0 | slot), (int)3553, (int)texture, (int)0);
        return texture;
    }

    public final void checkDeleteFramebuffer() {
        if (this.framebufferObject > 0) {
            this.deleteFramebuffer();
        }
    }

    protected void deleteFramebuffer() {
        this.unbindFramebufferTexture();
        this.unbindFramebuffer();
        if (this.depthAttachment > 0) {
            if (this.isEnabled(3)) {
                GL11.glDeleteTextures((int)this.depthAttachment);
            } else {
                OpenGlHelper.func_153184_g((int)this.depthAttachment);
            }
            this.depthAttachment = -1;
        }
        if (this.framebufferTexture > 0) {
            GL11.glDeleteTextures((int)this.framebufferTexture);
            this.framebufferTexture = -1;
        }
        OpenGlHelper.func_153174_h((int)this.framebufferObject);
        this.framebufferObject = -1;
    }

    public void framebufferClear() {
        this.bindFramebuffer();
        this.clearCurrentFramebuffer();
        this.unbindFramebuffer();
    }

    public void clearCurrentFramebuffer() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glClear((int)this.bufferBits);
    }

    public void copyDepthFromFramebuffer(Framebuffer other) {
        OpenGlHelper.func_153171_g((int)36008, (int)other.field_147616_f);
        OpenGlHelper.func_153171_g((int)36009, (int)this.framebufferObject);
        this.blitFramebuffer(other.field_147621_c, other.field_147618_d, this.framebufferWidth, this.framebufferHeight, 256);
    }

    public void copyDepthToFramebuffer(Framebuffer other) {
        OpenGlHelper.func_153171_g((int)36008, (int)this.framebufferObject);
        OpenGlHelper.func_153171_g((int)36009, (int)other.field_147616_f);
        this.blitFramebuffer(this.framebufferWidth, this.framebufferHeight, other.field_147621_c, other.field_147618_d, 256);
    }

    public void copyStencilFromFramebuffer(Framebuffer other) {
        OpenGlHelper.func_153171_g((int)36008, (int)other.field_147616_f);
        OpenGlHelper.func_153171_g((int)36009, (int)this.framebufferObject);
        this.blitFramebuffer(other.field_147621_c, other.field_147618_d, this.framebufferWidth, this.framebufferHeight, 1024);
    }

    public void copyStencilToFramebuffer(Framebuffer other) {
        OpenGlHelper.func_153171_g((int)36008, (int)this.framebufferObject);
        OpenGlHelper.func_153171_g((int)36009, (int)other.field_147616_f);
        this.blitFramebuffer(this.framebufferWidth, this.framebufferHeight, other.field_147621_c, other.field_147618_d, 1024);
    }

    public void blitFramebuffer(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int bit) {
        GL30.glBlitFramebuffer((int)0, (int)0, (int)srcWidth, (int)srcHeight, (int)0, (int)0, (int)dstWidth, (int)dstHeight, (int)bit, (int)9728);
    }

    public void bindFramebuffer(boolean viewport) {
        this.bindFramebuffer();
        if (viewport) {
            this.setupViewport();
        }
    }

    public void bindFramebuffer() {
        OpenGlHelper.func_153171_g((int)36160, (int)this.framebufferObject);
    }

    public void bindReadFramebuffer() {
        OpenGlHelper.func_153171_g((int)36008, (int)this.framebufferObject);
    }

    public void bindDrawFramebuffer() {
        OpenGlHelper.func_153171_g((int)36009, (int)this.framebufferObject);
    }

    public void clearBindFramebuffer() {
        this.bindFramebuffer();
        this.clearCurrentFramebuffer();
    }

    public void clearBindFramebuffer(boolean viewport) {
        this.bindFramebuffer(viewport);
        this.clearCurrentFramebuffer();
    }

    public void setupViewport() {
        GL11.glViewport((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight);
    }

    public void setupOrtho() {
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.framebufferWidth, (double)this.framebufferHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void restoreOrtho() {
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    public void bindFramebufferTexture() {
        GL11.glBindTexture((int)3553, (int)this.framebufferTexture);
    }

    public void unbindFramebufferTexture() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    public void unbindFramebuffer() {
        this.unbindFramebuffer(false);
    }

    public void unbindFramebuffer(boolean restoreViewport) {
        Minecraft.func_71410_x().func_147110_a().func_147610_a(restoreViewport);
    }

    public void readTexturePixels(IntBuffer pixelBuffer, int[] pixels) {
        this.bindReadFramebuffer();
        pixelBuffer.clear();
        GL11.glReadPixels((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        pixelBuffer.get(pixels);
    }

    public void readPixels(IntBuffer pixelBuffer, int[] pixels, int component) {
        pixelBuffer.clear();
        GL11.glReadPixels((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight, (int)component, (int)5126, (IntBuffer)pixelBuffer);
        pixelBuffer.get(pixels);
    }

    public void applyTonemapping(float multiplier) {
        if (tonemapShader == null) {
            tonemapShader = new ShaderProgram("gtnhlib", "shaders/hdr/tonemap.vert.glsl", "shaders/hdr/tonemap.frag.glsl");
            tonemapShader.use();
            uMultiplier = tonemapShader.getUniformLocation("multiplier");
            tonemapShader.bindTextureSlot("uScene", 0);
            tonemapShader.bindTextureSlot("uOverlay", 1);
            ShaderProgram.clear();
        }
        tonemapShader.use();
        if (tonemapMultiplier != multiplier) {
            GL20.glUniform1f((int)uMultiplier, (float)multiplier);
            tonemapMultiplier = multiplier;
        }
        Minecraft.func_71410_x().func_147110_a().func_147612_c();
        GL13.glActiveTexture((int)33985);
        this.bindFramebufferTexture();
        GL11.glDisable((int)3042);
        PostProcessingHelper.drawFullscreenQuad();
        GL13.glActiveTexture((int)33984);
    }

    public void checkFramebufferComplete() {
        int i = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
        if (i != OpenGlHelper.field_153202_i) {
            if (i == OpenGlHelper.field_153203_j) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153204_k) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT");
            }
            if (i == OpenGlHelper.field_153205_l) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
            }
            if (i == OpenGlHelper.field_153206_m) {
                throw new RuntimeException("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
            }
            throw new RuntimeException("glCheckFramebufferStatus returned unknown status:" + i);
        }
    }

    public void copyTextureToFile(String category, String filename) {
        File dir = new File(new File(Minecraft.func_71410_x().field_71412_D, "debug"), category);
        dir.mkdirs();
        this.copyTextureToFile(new File(dir, filename));
    }

    public void copyTextureToFile(String category, String filename, int texture) {
        File dir = new File(new File(Minecraft.func_71410_x().field_71412_D, "debug"), category);
        dir.mkdirs();
        this.copyTextureToFile(new File(dir, filename), texture);
    }

    public void copyTextureToFile(String category, String filename, int[] pixels) {
        File dir = new File(new File(Minecraft.func_71410_x().field_71412_D, "debug"), category);
        dir.mkdirs();
        this.copyTextureToFile(new File(dir, filename), pixels);
    }

    public void copyDepthToFile(String category, String filename) {
        File dir = new File(new File(Minecraft.func_71410_x().field_71412_D, "debug"), category);
        dir.mkdirs();
        this.copyDepthToFile(new File(dir, filename));
    }

    public void copyStencilToFile(String category, String filename) {
        File dir = new File(new File(Minecraft.func_71410_x().field_71412_D, "debug"), category);
        dir.mkdirs();
        this.copyStencilToFile(new File(dir, filename));
    }

    public void copyTextureToFile(File file) {
        this.copyTextureToFile(file, this.framebufferTexture);
    }

    public void copyTextureToFile(File file, int texture) {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        BufferedImage bufferedimage = new BufferedImage(width, height, 1);
        int[] pixelValues = ((DataBufferInt)bufferedimage.getRaster().getDataBuffer()).getData();
        IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)pixelValues.length);
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
        pixelBuffer.get(pixelValues);
        int halfHeight = height / 2;
        int[] rowBuffer = new int[width];
        for (int y = 0; y < halfHeight; ++y) {
            int top = y * width;
            int bottom = (height - 1 - y) * width;
            System.arraycopy(pixelValues, top, rowBuffer, 0, width);
            System.arraycopy(pixelValues, bottom, pixelValues, top, width);
            System.arraycopy(rowBuffer, 0, pixelValues, bottom, width);
        }
        CustomFramebuffer.copyBufferedImageToFile(bufferedimage, file);
        bufferedimage.flush();
    }

    public void copyTextureToFile(File file, int[] pixelValues) {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        BufferedImage bufferedimage = new BufferedImage(width, height, 1);
        int halfHeight = height / 2;
        int[] rowBuffer = new int[width];
        for (int y = 0; y < halfHeight; ++y) {
            int top = y * width;
            int bottom = (height - 1 - y) * width;
            System.arraycopy(pixelValues, top, rowBuffer, 0, width);
            System.arraycopy(pixelValues, bottom, pixelValues, top, width);
            System.arraycopy(rowBuffer, 0, pixelValues, bottom, width);
        }
        bufferedimage.setRGB(0, 0, width, height, pixelValues, 0, width);
        CustomFramebuffer.copyBufferedImageToFile(bufferedimage, file);
        bufferedimage.flush();
    }

    public void copyDepthToFile(File file) {
        this.copyComponentToFile(6402, file);
    }

    public void copyStencilToFile(File file) {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        int[] pixelValues = new int[width * height];
        IntBuffer stencilBuffer = BufferUtils.createIntBuffer((int)pixelValues.length);
        this.bindReadFramebuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6401, (int)5126, (IntBuffer)stencilBuffer);
        BufferedImage image = new BufferedImage(width, height, 10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int gray = stencilBuffer.get(y * width + x);
                gray = Math.max(0, Math.min(255, gray));
                int rgb = gray << 16 | gray << 8 | gray;
                image.setRGB(x, height - 1 - y, rgb);
            }
        }
        CustomFramebuffer.copyBufferedImageToFile(image, file);
        image.flush();
    }

    public void copyComponentToFile(int component, File file) {
        int width = this.framebufferWidth;
        int height = this.framebufferHeight;
        int[] pixelValues = new int[width * height];
        FloatBuffer depthBuffer = BufferUtils.createFloatBuffer((int)pixelValues.length);
        this.bindReadFramebuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)component, (int)5126, (FloatBuffer)depthBuffer);
        BufferedImage image = new BufferedImage(width, height, 10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float depth = CustomFramebuffer.linearizeDepth(depthBuffer.get(y * width + x));
                int gray = (int)((1.0f - depth) * 255.0f);
                gray = Math.max(0, Math.min(255, gray));
                int rgb = gray << 16 | gray << 8 | gray;
                image.setRGB(x, height - 1 - y, rgb);
            }
        }
        CustomFramebuffer.copyBufferedImageToFile(image, file);
        image.flush();
    }

    private static void copyBufferedImageToFile(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static float linearizeDepth(float d, float zNear, float zFar) {
        float z_n = 2.0f * d - 1.0f;
        return 2.0f * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
    }

    private static float linearizeDepth(float d) {
        return CustomFramebuffer.linearizeDepth(d, 0.05f, Minecraft.func_71410_x().field_71474_y.field_151451_c * 16);
    }
}

