/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.ITessellatorInstance;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.util.ModelQuadUtil;
import com.gtnewhorizon.gtnhlib.client.renderer.stacks.Vector3dStack;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;

public class CapturingTessellator
extends Tessellator
implements ITessellatorInstance {
    private static final MethodHandle sRawBufferSize;
    private static final MethodHandle gRawBufferSize;
    private final Flags FLAGS = new Flags(true, true, true, true);
    private final ObjectPooler<ModelQuad> quadBuf = new ObjectPooler<ModelQuad>(ModelQuad::new);
    private final List<ModelQuadViewMutable> collectedQuads = new ObjectArrayList<ModelQuadViewMutable>();
    private int shaderBlockId = -1;
    private final BlockPos offset = new BlockPos();
    private final Vector3dStack storedTranslation = new Vector3dStack();

    public void setOffset(BlockPos pos) {
        this.offset.set(pos);
    }

    public void resetOffset() {
        this.offset.zero();
    }

    public void setRawBufferSize(int size) {
        try {
            sRawBufferSize.invokeExact(this, size);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public int getRawBufferSize() {
        try {
            return gRawBufferSize.invokeExact(this);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private int dataX(int offset, int vi) {
        return this.field_78405_h[offset + ModelQuadUtil.vertexOffset(vi)];
    }

    private int dataY(int offset, int vi) {
        return this.field_78405_h[offset + ModelQuadUtil.vertexOffset(vi) + 1];
    }

    private int dataZ(int offset, int vi) {
        return this.field_78405_h[offset + ModelQuadUtil.vertexOffset(vi) + 2];
    }

    public int func_78381_a() {
        this.FLAGS.hasBrightness = this.field_78414_p;
        this.FLAGS.hasColor = this.field_78399_n;
        this.FLAGS.hasNormals = this.field_78413_q;
        int verticesPerPrimitive = this.field_78409_u == 7 ? 4 : 3;
        for (int quadI = 0; quadI < this.field_78406_i / verticesPerPrimitive; ++quadI) {
            int srcOffset = quadI * (verticesPerPrimitive * 8);
            if (this.empty(srcOffset)) continue;
            ModelQuad quad = this.quadBuf.getInstance();
            quad.setState(this.field_78405_h, srcOffset, this.FLAGS, this.field_78409_u, -this.offset.x, -this.offset.y, -this.offset.z);
            quad.setShaderBlockId(this.shaderBlockId);
            this.collectedQuads.add(quad);
        }
        int i = this.field_147569_p * 4;
        this.discard();
        return i;
    }

    private boolean empty(int srcOffset) {
        return this.dataX(srcOffset, 0) == this.dataX(srcOffset, 1) && this.dataX(srcOffset, 1) == this.dataX(srcOffset, 2) && this.dataX(srcOffset, 2) == this.dataX(srcOffset, 3) && this.dataY(srcOffset, 0) == this.dataY(srcOffset, 1) && this.dataY(srcOffset, 1) == this.dataY(srcOffset, 2) && this.dataY(srcOffset, 2) == this.dataY(srcOffset, 3);
    }

    @Override
    public void discard() {
        this.field_78415_z = false;
        this.func_78379_d();
    }

    public List<ModelQuadViewMutable> getQuads() {
        return this.collectedQuads;
    }

    public void clearQuads() {
        for (int i = 0; i < this.collectedQuads.size(); ++i) {
            ModelQuadViewMutable quad = this.collectedQuads.get(i);
            if (!(quad instanceof ModelQuad)) continue;
            ModelQuad mq = (ModelQuad)quad;
            this.quadBuf.releaseInstance(mq);
        }
        this.collectedQuads.clear();
    }

    public static ByteBuffer quadsToBuffer(List<ModelQuadViewMutable> quads, VertexFormat format) {
        if (!format.canWriteQuads()) {
            throw new IllegalStateException("Vertex format has no quad writer: " + format);
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * quads.size() * 4));
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            format.writeQuad(quads.get(i), byteBuffer);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void storeTranslation() {
        this.storedTranslation.push();
        this.storedTranslation.set(this.field_78408_v, this.field_78407_w, this.field_78417_x);
    }

    public void restoreTranslation() {
        this.field_78408_v = this.storedTranslation.x;
        this.field_78407_w = this.storedTranslation.y;
        this.field_78417_x = this.storedTranslation.z;
        this.storedTranslation.pop();
    }

    public static int createBrightness(int sky, int block) {
        return sky << 20 | block << 4;
    }

    public CapturingTessellator pos(double x, double y, double z) {
        this.ensureBuffer();
        this.field_78405_h[this.field_147569_p + 0 + 0] = Float.floatToRawIntBits((float)(x + this.field_78408_v));
        this.field_78405_h[this.field_147569_p + 0 + 1] = Float.floatToRawIntBits((float)(y + this.field_78407_w));
        this.field_78405_h[this.field_147569_p + 0 + 2] = Float.floatToRawIntBits((float)(z + this.field_78417_x));
        return this;
    }

    public CapturingTessellator tex(double u, double v) {
        this.field_78405_h[this.field_147569_p + 3] = Float.floatToRawIntBits((float)u);
        this.field_78405_h[this.field_147569_p + 3 + 1] = Float.floatToRawIntBits((float)v);
        this.field_78400_o = true;
        return this;
    }

    public CapturingTessellator color(float red, float green, float blue, float alpha) {
        return this.color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public CapturingTessellator color(int red, int green, int blue, int alpha) {
        if (this.field_78410_t) {
            return this;
        }
        red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        alpha = MathHelper.func_76125_a((int)alpha, (int)0, (int)255);
        int color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? alpha << 24 | blue << 16 | green << 8 | red : red << 24 | green << 16 | blue << 8 | alpha;
        this.field_78405_h[this.field_147569_p + 5] = color;
        this.field_78399_n = true;
        return this;
    }

    public CapturingTessellator normal(float x, float y, float z) {
        byte b0 = (byte)(x * 127.0f);
        byte b1 = (byte)(y * 127.0f);
        byte b2 = (byte)(z * 127.0f);
        this.field_78405_h[this.field_147569_p + 6] = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
        this.field_78413_q = true;
        return this;
    }

    public CapturingTessellator setNormalTransformed(Vector3f normal, Vector3f dest, Matrix3f normalMatrix) {
        normalMatrix.transform(normal, dest).normalize();
        this.func_78375_b(dest.x, dest.y, dest.z);
        return this;
    }

    public CapturingTessellator setNormalTransformed(Vector3f normal, Matrix3f normalMatrix) {
        return this.setNormalTransformed(normal, normal, normalMatrix);
    }

    public CapturingTessellator lightmap(int skyLight, int blockLight) {
        return this.brightness(CapturingTessellator.createBrightness(skyLight, blockLight));
    }

    public CapturingTessellator brightness(int brightness) {
        this.field_78405_h[this.field_147569_p + 7] = brightness;
        this.field_78414_p = true;
        return this;
    }

    public CapturingTessellator endVertex() {
        this.field_147569_p += 8;
        ++this.field_78406_i;
        return this;
    }

    public void ensureBuffer() {
        int rawBufferSize = this.getRawBufferSize();
        if (this.field_147569_p >= rawBufferSize - 32) {
            if (rawBufferSize == 0) {
                rawBufferSize = 65536;
                this.setRawBufferSize(rawBufferSize);
                this.field_78405_h = new int[rawBufferSize];
            } else {
                this.setRawBufferSize(rawBufferSize *= 2);
                this.field_78405_h = Arrays.copyOf(this.field_78405_h, rawBufferSize);
            }
        }
    }

    public void setShaderBlockId(int blockId) {
        if (this.field_78415_z) {
            this.func_78381_a();
            this.field_78415_z = true;
        }
        this.shaderBlockId = blockId;
    }

    static {
        Field rbs = ReflectionHelper.findField(Tessellator.class, (String[])new String[]{"rawBufferSize", "field_78388_E"});
        rbs.setAccessible(true);
        try {
            sRawBufferSize = MethodHandles.lookup().unreflectSetter(rbs);
            gRawBufferSize = MethodHandles.lookup().unreflectGetter(rbs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Flags {
        boolean hasTexture;
        public boolean hasBrightness;
        public boolean hasColor;
        public boolean hasNormals;

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }
    }
}

