/*
 * Decompiled with CFR 0.152.
 */
package org.taumc.celeritas.api.options.control;

import org.embeddedt.embeddium.impl.gui.framework.DrawContext;
import org.embeddedt.embeddium.impl.gui.framework.InteractionContext;
import org.embeddedt.embeddium.impl.gui.framework.TextComponent;
import org.embeddedt.embeddium.impl.util.Dim2i;
import org.joml.Math;
import org.taumc.celeritas.api.options.control.Control;
import org.taumc.celeritas.api.options.control.ControlElement;
import org.taumc.celeritas.api.options.control.ControlValueFormatter;
import org.taumc.celeritas.api.options.structure.Option;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    private static void assertTrue(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        SliderControl.assertTrue(max > min, "The maximum value must be greater than the minimum value");
        SliderControl.assertTrue(interval > 0, "The slider interval must be greater than zero");
        SliderControl.assertTrue((max - min) % interval == 0, "The maximum value must be divisable by the interval");
        SliderControl.assertTrue(mode != null, "The slider mode must not be null");
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }

    private static class Button
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final Dim2i sliderBounds;
        private final ControlValueFormatter formatter;
        private final int min;
        private final int max;
        private final int range;
        private final int interval;
        private double thumbPosition;
        private boolean sliderHeld;

        public Button(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
            super(option, dim);
            this.min = min;
            this.max = max;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(option.getValue());
            this.formatter = formatter;
            this.sliderBounds = new Dim2i(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
            this.sliderHeld = false;
        }

        @Override
        public void render(DrawContext drawContext, int mouseX, int mouseY, float delta) {
            super.render(drawContext, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.isMouseOver(mouseX, mouseY)) {
                this.renderSlider(drawContext);
            } else {
                this.renderStandaloneValue(drawContext);
            }
        }

        private void renderStandaloneValue(DrawContext drawContext) {
            int sliderX = this.sliderBounds.x();
            int sliderY = this.sliderBounds.y();
            int sliderWidth = this.sliderBounds.width();
            int sliderHeight = this.sliderBounds.height();
            TextComponent label = this.formatter.format((Integer)this.option.getValue());
            int labelWidth = drawContext.getStringWidth(label);
            drawContext.drawString(label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(DrawContext drawContext) {
            int sliderX = this.sliderBounds.x();
            int sliderY = this.sliderBounds.y();
            int sliderWidth = this.sliderBounds.width();
            int sliderHeight = this.sliderBounds.height();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = Math.clamp((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            int thumbX = (int)((double)sliderX + thumbOffset - 2.0);
            int trackY = (int)((double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5);
            drawContext.fill(thumbX, sliderY, thumbX + 4, sliderY + sliderHeight, -1);
            drawContext.fill(sliderX, trackY, sliderX + sliderWidth, trackY + 1, -1);
            TextComponent label = this.formatter.format(this.getIntValue());
            int labelWidth = drawContext.getStringWidth(label);
            drawContext.drawString(label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)java.lang.Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        @Override
        public boolean mouseClicked(InteractionContext context, double mouseX, double mouseY, int button) {
            this.sliderHeld = false;
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                if (this.sliderBounds.containsCursor((int)mouseX, (int)mouseY)) {
                    this.setValueFromMouse(mouseX);
                    this.sliderHeld = true;
                }
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.x()) / (double)this.sliderBounds.width());
        }

        public void setValue(double d) {
            this.thumbPosition = Math.clamp((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if (!((Integer)this.option.getValue()).equals(value)) {
                this.option.setValue(value);
            }
        }

        @Override
        public boolean mouseDragged(InteractionContext context, double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.containsCursor(mouseX, mouseY)) {
                if (this.sliderHeld) {
                    this.setValueFromMouse(mouseX);
                }
                return true;
            }
            return false;
        }
    }
}

