/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.embeddedt.embeddium.impl.gl.shader.GlShader;
import org.embeddedt.embeddium.impl.gl.shader.ShaderConstants;
import org.embeddedt.embeddium.impl.gl.shader.ShaderParser;
import org.embeddedt.embeddium.impl.gl.shader.ShaderType;

public class ShaderLoader {
    public static GlShader loadShader(ShaderType type, String name, ShaderConstants constants) {
        return new GlShader(type, name, ShaderParser.parseShader(ShaderLoader.getShaderSource(name), ShaderLoader::getShaderSource, constants));
    }

    public static String getShaderSource(String name) {
        String string;
        block9: {
            String[] splitStr = name.contains(":") ? name.split(":", 2) : new String[]{"minecraft", name};
            String path = String.format("/assets/%s/shaders/%s", splitStr[0], splitStr[1]);
            InputStream in = ShaderLoader.class.getResourceAsStream(path);
            try {
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                }
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read shader source for " + path, e);
                }
            }
            in.close();
        }
        return string;
    }
}

