/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.occlusion;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.BitSet;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.VisibilityEncoding;

public class SectionVisibilityBuilder {
    private static final int SECTION_AXIS_SIZE = 16;
    private static final int SECTION_AXIS_MASK = 15;
    private static final int TOTAL_BLOCKS = 4096;
    private static final int BLOCKS_ON_ONE_FACE = 256;
    private static final int BITS_PER_AXIS = 4;
    private static final int X_SHIFT = 0;
    private static final int Z_SHIFT = 4;
    private static final int Y_SHIFT = 8;
    private static final int[] INDICES_TO_INITIATE_FLOODFILL = SectionVisibilityBuilder.buildFloodfillIndices();
    private final BitSet blocks = new BitSet(4096);

    private static int[] buildFloodfillIndices() {
        IntArrayList indicesList = new IntArrayList(1352);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    indicesList.add(SectionVisibilityBuilder.getIndex(x, y, z));
                }
            }
        }
        return indicesList.toIntArray();
    }

    public long computeVisibilityEncoding() {
        int opaqueCount = this.blocks.cardinality();
        if (opaqueCount == 4096) {
            return 0L;
        }
        if (opaqueCount < 256) {
            return VisibilityEncoding.EVERYTHING;
        }
        return this.computeWithFloodFill();
    }

    public void markOpaque(int x, int y, int z) {
        this.blocks.set(SectionVisibilityBuilder.getIndex(x & 0xF, y & 0xF, z & 0xF));
    }

    private long computeWithFloodFill() {
        long resultEncoding = 0L;
        BitSet blocks = this.blocks;
        BitSet escapedFaces = new BitSet(6);
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        for (int i : INDICES_TO_INITIATE_FLOODFILL) {
            if (blocks.get(i)) continue;
            escapedFaces.clear();
            queue.clear();
            this.exploreFrom(escapedFaces, queue, i);
            int dir = escapedFaces.nextSetBit(0);
            while (dir >= 0) {
                int dir2 = escapedFaces.nextSetBit(0);
                while (dir2 >= 0) {
                    resultEncoding |= 1L << VisibilityEncoding.bit(dir, dir2);
                    dir2 = escapedFaces.nextSetBit(dir2 + 1);
                }
                dir = escapedFaces.nextSetBit(dir + 1);
            }
        }
        return resultEncoding;
    }

    private void exploreFrom(BitSet escapedFaces, IntArrayFIFOQueue queue, int startIndex) {
        queue.enqueue(startIndex);
        BitSet blocks = this.blocks;
        blocks.set(startIndex, true);
        while (!queue.isEmpty()) {
            int idx = queue.dequeueInt();
            for (int dir = 0; dir < 6; ++dir) {
                int neighborIdx = SectionVisibilityBuilder.getNeighborIndex(idx, dir);
                if (neighborIdx >= 0) {
                    if (blocks.get(neighborIdx)) continue;
                    blocks.set(neighborIdx, true);
                    queue.enqueue(neighborIdx);
                    continue;
                }
                escapedFaces.set(dir);
            }
        }
    }

    private static int getNeighborIndex(int idx, int dir) {
        switch (dir) {
            case 1: {
                if ((idx >> 8 & 0xF) == 15) {
                    return -1;
                }
                return idx + 256;
            }
            case 0: {
                if ((idx >> 8 & 0xF) == 0) {
                    return -1;
                }
                return idx - 256;
            }
            case 5: {
                if ((idx >> 0 & 0xF) == 15) {
                    return -1;
                }
                return idx + 1;
            }
            case 4: {
                if ((idx >> 0 & 0xF) == 0) {
                    return -1;
                }
                return idx - 1;
            }
            case 3: {
                if ((idx >> 4 & 0xF) == 15) {
                    return -1;
                }
                return idx + 16;
            }
            case 2: {
                if ((idx >> 4 & 0xF) == 0) {
                    return -1;
                }
                return idx - 16;
            }
        }
        throw new IllegalArgumentException();
    }

    private static int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x << 0;
    }
}

