/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.embeddedt.embeddium.impl.render.chunk.AbstractSection;
import org.embeddedt.embeddium.impl.render.chunk.ChunkUpdateType;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.occlusion.VisibilityEncoding;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSection
extends AbstractSection {
    private final RenderRegion region;
    public static final BuiltRenderSectionData EMPTY_DATA = new BuiltRenderSectionData();
    private BuiltRenderSectionData contextData;
    private boolean hasAnythingToRender;
    private int visualsServiceFlags;
    @NotNull
    private Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> translucencySortStates = Collections.emptyMap();
    private TranslucentQuadAnalyzer.Level highestSortingLevel = TranslucentQuadAnalyzer.Level.NONE;
    private boolean needsDynamicTranslucencySorting;
    @Nullable
    private CancellationToken buildCancellationToken = null;
    @Nullable
    private ChunkUpdateType pendingUpdateType;
    private int lastBuiltFrame = -1;
    private int lastSubmittedFrame = -1;
    private boolean disposed;
    private long lastBuildDurationNanos;
    public double lastCameraX;
    public double lastCameraY;
    public double lastCameraZ;

    public RenderSection(RenderRegion region, int chunkX, int chunkY, int chunkZ) {
        super(chunkX, chunkY, chunkZ);
        this.region = region;
        this.contextData = null;
        this.updateCachedContextDataFlags();
    }

    public void delete() {
        if (this.buildCancellationToken != null) {
            this.buildCancellationToken.setCancelled();
            this.buildCancellationToken = null;
        }
        this.setInfo(null);
        this.disposed = true;
    }

    public boolean setInfo(@Nullable BuiltRenderSectionData info) {
        boolean changed;
        boolean bl = changed = !Objects.equals(info, this.contextData);
        if (changed) {
            if (this.contextData == null) {
                this.getRegion().updateSectionLoadTime(this);
            }
            this.contextData = info;
            this.updateCachedContextDataFlags();
        }
        return changed;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isBuilt() {
        return this.contextData != null;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    @Nullable
    public BuiltRenderSectionData getBuiltContext() {
        return this.contextData;
    }

    public void updateCachedContextDataFlags() {
        this.visualsServiceFlags = this.contextData != null ? this.contextData.getVisualBitmaskForSection() : 0;
        this.hasAnythingToRender = this.visualsServiceFlags != 0;
    }

    public boolean hasAnythingToRender() {
        return this.hasAnythingToRender;
    }

    public void setTranslucencySortStates(@NotNull Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> sortStates) {
        this.translucencySortStates = Map.copyOf(sortStates);
        TranslucentQuadAnalyzer.Level level = TranslucentQuadAnalyzer.Level.NONE;
        boolean needsDynamicSorting = false;
        if (!sortStates.isEmpty()) {
            for (TranslucentQuadAnalyzer.SortState state : sortStates.values()) {
                level = state.level().ordinal() > level.ordinal() ? state.level() : level;
                needsDynamicSorting |= state.requiresDynamicSorting();
            }
        }
        this.highestSortingLevel = level;
        this.needsDynamicTranslucencySorting = needsDynamicSorting;
    }

    @Nullable
    public CancellationToken getBuildCancellationToken() {
        return this.buildCancellationToken;
    }

    public void setBuildCancellationToken(@Nullable CancellationToken token) {
        this.buildCancellationToken = token;
    }

    @Nullable
    public ChunkUpdateType getPendingUpdate() {
        return this.pendingUpdateType;
    }

    public void setPendingUpdate(@Nullable ChunkUpdateType type) {
        this.pendingUpdateType = type;
    }

    public boolean requestUpdate(ChunkUpdateType type) {
        if ((type = ChunkUpdateType.getPromotionUpdateType(this.pendingUpdateType, type)) != null) {
            this.pendingUpdateType = type;
            return true;
        }
        return false;
    }

    public int getLastBuiltFrame() {
        return this.lastBuiltFrame;
    }

    public void setLastBuiltFrame(int lastBuiltFrame) {
        this.lastBuiltFrame = lastBuiltFrame;
    }

    public int getLastSubmittedFrame() {
        return this.lastSubmittedFrame;
    }

    public void setLastSubmittedFrame(int lastSubmittedFrame) {
        this.lastSubmittedFrame = lastSubmittedFrame;
    }

    public int getVisualsServiceFlags() {
        return this.visualsServiceFlags;
    }

    @NotNull
    public Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> getTranslucencySortStates() {
        return this.translucencySortStates;
    }

    public TranslucentQuadAnalyzer.Level getHighestSortingLevel() {
        return this.highestSortingLevel;
    }

    public boolean isNeedsDynamicTranslucencySorting() {
        return this.needsDynamicTranslucencySorting;
    }

    public void setNeedsDynamicTranslucencySorting(boolean needsDynamicTranslucencySorting) {
        this.needsDynamicTranslucencySorting = needsDynamicTranslucencySorting;
    }

    public long getLastBuildDurationNanos() {
        return this.lastBuildDurationNanos;
    }

    public void setLastBuildDurationNanos(long lastBuildDurationNanos) {
        this.lastBuildDurationNanos = lastBuildDurationNanos;
    }

    static {
        RenderSection.EMPTY_DATA.hasBlockGeometry = false;
        RenderSection.EMPTY_DATA.visibilityData = VisibilityEncoding.EVERYTHING;
    }
}

