/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk;

import org.embeddedt.embeddium.impl.render.chunk.LocalSectionIndex;
import org.embeddedt.embeddium.impl.util.PositionUtil;

public abstract class AbstractSection {
    private final int chunkX;
    private final int chunkY;
    private final int chunkZ;
    private final int sectionIndex;

    public AbstractSection(int chunkX, int chunkY, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkY = chunkY;
        this.chunkZ = chunkZ;
        int rX = this.getChunkX() & 7;
        int rY = this.getChunkY() & 3;
        int rZ = this.getChunkZ() & 7;
        this.sectionIndex = LocalSectionIndex.pack(rX, rY, rZ);
    }

    public final int getOriginX() {
        return this.chunkX << 4;
    }

    public final int getOriginY() {
        return this.chunkY << 4;
    }

    public final int getOriginZ() {
        return this.chunkZ << 4;
    }

    public final int getCenterX() {
        return this.getOriginX() + 8;
    }

    public final int getCenterY() {
        return this.getOriginY() + 8;
    }

    public final int getCenterZ() {
        return this.getOriginZ() + 8;
    }

    public final int getChunkX() {
        return this.chunkX;
    }

    public final int getChunkY() {
        return this.chunkY;
    }

    public final int getChunkZ() {
        return this.chunkZ;
    }

    public final float getSquaredDistance(float x, float y, float z) {
        float xDist = x - (float)this.getCenterX();
        float yDist = y - (float)this.getCenterY();
        float zDist = z - (float)this.getCenterZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public final boolean isAlignedWithSectionOnGrid(int otherX, int otherY, int otherZ) {
        return this.chunkX == otherX || this.chunkY == otherY || this.chunkZ == otherZ;
    }

    public final int getSectionIndex() {
        return this.sectionIndex;
    }

    public final float getSquaredDistanceFromBlockCenter(int x, int y, int z) {
        return this.getSquaredDistance((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
    }

    public final long positionAsLong() {
        return PositionUtil.packSection(this.chunkX, this.chunkY, this.chunkZ);
    }

    public String toString() {
        return String.format("%s at chunk (%d, %d, %d) from (%d, %d, %d) to (%d, %d, %d)", this.getClass().getSimpleName(), this.chunkX, this.chunkY, this.chunkZ, this.getOriginX(), this.getOriginY(), this.getOriginZ(), this.getOriginX() + 15, this.getOriginY() + 15, this.getOriginZ() + 15);
    }
}

