/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import com.falsepattern.lib.compat.ChunkPos;
import com.ventooth.beddium.modules.TerrainRendering.ArchaicRenderSectionManager;
import com.ventooth.beddium.modules.TerrainRendering.CeleritasWorldRenderer;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class MinimapRenderer {
    private static final MinimapRenderer INSTANCE = new MinimapRenderer();
    private static volatile boolean enabled = false;

    public static synchronized void toggle() {
        if (enabled) {
            MinimapRenderer.disable();
        } else {
            MinimapRenderer.enable();
        }
    }

    public static synchronized void enable() {
        if (enabled) {
            return;
        }
        enabled = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static synchronized void disable() {
        if (!enabled) {
            return;
        }
        enabled = false;
        MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onDraw(RenderGameOverlayEvent.Text event) {
        CeleritasWorldRenderer renderer = CeleritasWorldRenderer.instanceNullable();
        if (renderer == null) {
            return;
        }
        ArchaicRenderSectionManager manager = renderer.getRenderSectionManager();
        Minecraft MINECRAFT = Minecraft.func_71410_x();
        float partialTicks = event.partialTicks;
        double pX = MINECRAFT.field_71439_g.field_70169_q + (MINECRAFT.field_71439_g.field_70165_t - MINECRAFT.field_71439_g.field_70169_q) * (double)partialTicks;
        double pY = MINECRAFT.field_71439_g.field_70167_r + (MINECRAFT.field_71439_g.field_70163_u - MINECRAFT.field_71439_g.field_70167_r) * (double)partialTicks;
        double pZ = MINECRAFT.field_71439_g.field_70166_s + (MINECRAFT.field_71439_g.field_70161_v - MINECRAFT.field_71439_g.field_70166_s) * (double)partialTicks;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glScaled((double)2.0, (double)2.0, (double)1.0);
        GL11.glTranslated((double)32.0, (double)32.0, (double)0.0);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBegin((int)7);
        int playerChunkX = (int)Math.floor(pX) >> 4;
        int playerChunkZ = (int)Math.floor(pZ) >> 4;
        int range = 32;
        for (int x = playerChunkX - range; x < playerChunkX + range; ++x) {
            for (int z = playerChunkZ - range; z < playerChunkZ + range; ++z) {
                this.drawChunk(new ChunkPos(x, z), playerChunkX, playerChunkZ, manager);
            }
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawChunk(ChunkPos chunk, int pX, int pZ, ArchaicRenderSectionManager manager) {
        IChunkProvider chunkProviderIntegratedServer;
        Chunk theChunk;
        int cX = chunk.x;
        int cZ = chunk.z;
        boolean initialized = false;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int i = 0; i < 16; ++i) {
            if (!manager.isSectionBuilt(cX, i, cZ) || manager.isSectionVisuallyEmpty(cX, i, cZ)) continue;
            initialized = true;
            g = 1.0;
            if (!manager.isSectionVisible(cX, i, cZ)) continue;
            b = 1.0;
            break;
        }
        if (!initialized) {
            ChunkProviderClient chunkProviderClient = (ChunkProviderClient)Minecraft.func_71410_x().field_71441_e.func_72863_F();
            theChunk = chunkProviderClient.func_73154_d(chunk.x, chunk.z);
            if (theChunk instanceof EmptyChunk) {
                r = 1.0;
            } else {
                b = 1.0;
                initialized = true;
            }
        }
        if (!initialized && Minecraft.func_71410_x().func_71387_A() && (chunkProviderIntegratedServer = Minecraft.func_71410_x().func_71401_C().func_71218_a(Minecraft.func_71410_x().field_71439_g.field_71093_bK).func_72863_F()).func_73149_a(chunk.x, chunk.z)) {
            theChunk = chunkProviderIntegratedServer.func_73154_d(chunk.x, chunk.z);
            if (!theChunk.field_150814_l) {
                b = 1.0;
            } else {
                g = 0.5;
            }
        }
        GL11.glColor4d((double)r, (double)g, (double)b, (double)0.8);
        int xStart = chunk.x - pX;
        int zStart = chunk.z - pZ;
        int xEnd = xStart + 1;
        int zEnd = zStart + 1;
        GL11.glVertex3d((double)xStart, (double)zStart, (double)0.0);
        GL11.glVertex3d((double)xStart, (double)zEnd, (double)0.0);
        GL11.glVertex3d((double)xEnd, (double)zEnd, (double)0.0);
        GL11.glVertex3d((double)xEnd, (double)zStart, (double)0.0);
    }
}

