/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.beddium.modules.TerrainRendering;

import com.ventooth.beddium.config.TerrainRenderingConfig;
import com.ventooth.beddium.modules.MEGAChunks.MEGAChunkTracker;
import com.ventooth.beddium.modules.MEGAChunks.MegaChunkMetadata;
import com.ventooth.beddium.modules.TerrainRendering.ArchaicRenderSectionManager;
import com.ventooth.beddium.modules.TerrainRendering.CameraHelper;
import com.ventooth.beddium.modules.TerrainRendering.SafeChunkTracker;
import com.ventooth.beddium.modules.TerrainRendering.ext.RenderGlobalExt;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogGL;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogHandler;
import com.ventooth.beddium.modules.TerrainRendering.fog.FogState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import org.embeddedt.embeddium.impl.common.util.NativeBuffer;
import org.embeddedt.embeddium.impl.gl.device.CommandList;
import org.embeddedt.embeddium.impl.gl.device.RenderDevice;
import org.embeddedt.embeddium.impl.render.chunk.ChunkRenderMatrices;
import org.embeddedt.embeddium.impl.render.chunk.RenderPassConfiguration;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.data.MinecraftBuiltRenderSectionData;
import org.embeddedt.embeddium.impl.render.chunk.lists.ChunkRenderList;
import org.embeddedt.embeddium.impl.render.chunk.lists.SortedRenderLists;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker;
import org.embeddedt.embeddium.impl.render.chunk.map.ChunkTrackerHolder;
import org.embeddedt.embeddium.impl.render.chunk.region.RenderRegion;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderFogComponent;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.viewport.CameraTransform;
import org.embeddedt.embeddium.impl.render.viewport.Viewport;
import org.embeddedt.embeddium.impl.util.PositionUtil;
import org.embeddedt.embeddium.impl.util.iterator.ByteIterator;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL11;

public class CeleritasWorldRenderer {
    private final Minecraft client;
    private WorldClient world;
    private int renderDistance;
    private double lastCameraX;
    private double lastCameraY;
    private double lastCameraZ;
    private double lastCameraPitch;
    private double lastCameraYaw;
    private float lastFogDistance;
    private boolean useEntityCulling;
    private Viewport currentViewport;
    private ArchaicRenderSectionManager renderSectionManager;
    private boolean blockEntityRequestedOutline;
    private static final double MAX_ENTITY_CHECK_VOLUME = MegaChunkMetadata.BLOCKS_PER_WR_VOLUME * 15;

    public static CeleritasWorldRenderer instance() {
        CeleritasWorldRenderer instance = CeleritasWorldRenderer.instanceNullable();
        if (instance == null) {
            throw new IllegalStateException("No renderer attached to active world");
        }
        return instance;
    }

    public static ChunkTracker createChunkTracker() {
        return switch (TerrainRenderingConfig.ChunkDrawMode) {
            default -> throw new MatchException(null, null);
            case TerrainRenderingConfig.DrawModeEnum.Vanilla -> {
                if (TerrainRenderingConfig.MEGAChunks == 0) {
                    yield new SafeChunkTracker();
                }
                yield new MEGAChunkTracker.Vanilla();
            }
            case TerrainRenderingConfig.DrawModeEnum.Fast -> TerrainRenderingConfig.MEGAChunks == 0 ? new ChunkTracker() : new MEGAChunkTracker.Fast();
        };
    }

    public static CeleritasWorldRenderer instanceNullable() {
        RenderGlobal world = Minecraft.func_71410_x().field_71438_f;
        if (world instanceof RenderGlobalExt) {
            RenderGlobalExt extension = (RenderGlobalExt)world;
            return extension.celeritas$worldRenderer();
        }
        return null;
    }

    public CeleritasWorldRenderer(Minecraft client) {
        this.client = client;
    }

    public void setWorld(WorldClient world) {
        if (this.world == world) {
            return;
        }
        if (this.world != null) {
            this.unloadWorld();
        }
        if (world != null) {
            this.loadWorld(world);
        }
    }

    private void loadWorld(WorldClient world) {
        this.world = world;
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void unloadWorld() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.world = null;
    }

    public int getVisibleChunkCount() {
        return this.renderSectionManager.getVisibleChunkCount();
    }

    public void scheduleTerrainUpdate() {
        if (this.renderSectionManager != null) {
            this.renderSectionManager.markGraphDirty();
        }
    }

    public boolean isTerrainRenderComplete() {
        return this.renderSectionManager.getBuilder().isBuildQueueEmpty();
    }

    public static int getEffectiveRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    public void setupTerrain(Viewport viewport, float ticks, @Deprecated(forRemoval=true) int frame, boolean spectator, boolean updateChunksImmediately) {
        boolean dirty;
        NativeBuffer.reclaim(false);
        boolean isShadowPass = this.renderSectionManager.isInShadowPass();
        if (this.renderSectionManager != null) {
            this.renderSectionManager.finishAllGraphUpdates();
        }
        this.processChunkEvents();
        this.useEntityCulling = true;
        if (CeleritasWorldRenderer.getEffectiveRenderDistance() != this.renderDistance) {
            this.reload();
        }
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("camera_setup");
        Entity viewEntity = (Entity)Objects.requireNonNull(this.client.field_71451_h, "Client must have view entity");
        Vector3d camPosition = CameraHelper.getCurrentCameraPosition(ticks);
        double x = camPosition.x;
        double y = camPosition.y + (double)viewEntity.func_70047_e();
        double z = camPosition.z;
        float pitch = viewEntity.field_70125_A;
        float yaw = viewEntity.field_70177_z;
        float fogDistance = ChunkShaderFogComponent.FOG_SERVICE.getFogCutoff();
        boolean bl = dirty = x != this.lastCameraX || y != this.lastCameraY || z != this.lastCameraZ || (double)pitch != this.lastCameraPitch || (double)yaw != this.lastCameraYaw || fogDistance != this.lastFogDistance;
        if (dirty) {
            this.renderSectionManager.markGraphDirty();
        }
        this.currentViewport = viewport;
        this.lastCameraX = x;
        this.lastCameraY = y;
        this.lastCameraZ = z;
        this.lastCameraPitch = pitch;
        this.lastCameraYaw = yaw;
        this.lastFogDistance = fogDistance;
        this.renderSectionManager.runAsyncTasks();
        profiler.func_76318_c("chunk_update");
        this.renderSectionManager.updateChunks(updateChunksImmediately);
        profiler.func_76318_c("chunk_upload");
        this.renderSectionManager.uploadChunks();
        if (this.renderSectionManager.needsUpdate() || isShadowPass) {
            profiler.func_76318_c("chunk_render_lists");
            this.renderSectionManager.update(viewport, frame, spectator);
        }
        if (updateChunksImmediately) {
            profiler.func_76318_c("chunk_upload_immediately");
            this.renderSectionManager.uploadChunks();
        }
        profiler.func_76318_c("chunk_render_tick");
        this.renderSectionManager.tickVisibleRenders();
        profiler.func_76319_b();
        double entityDistanceScale = 1.0;
    }

    private void processChunkEvents() {
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        tracker.forEachEvent(this.renderSectionManager::onChunkAdded, this.renderSectionManager::onChunkRemoved);
    }

    public void drawChunkLayer(int vanillaPass, double x, double y, double z) {
        if (!TerrainRenderingConfig.FastFog) {
            FogGL.read();
        }
        if (FogHandler.DEBUG) {
            FogGL.debug(vanillaPass);
        }
        ChunkRenderMatrices matrices = new ChunkRenderMatrices((Matrix4fc)new Matrix4f(ActiveRenderInfo.field_74595_k), (Matrix4fc)new Matrix4f(ActiveRenderInfo.field_74594_j));
        Collection<TerrainRenderPass> passes = this.renderSectionManager.getRenderPassConfiguration().vanillaRenderStages().get(vanillaPass);
        if (passes != null && !passes.isEmpty()) {
            CameraTransform occlusionCamera = this.currentViewport.getTransform();
            CameraTransform realCamera = new CameraTransform(x, y, z);
            for (TerrainRenderPass pass : passes) {
                this.renderSectionManager.renderLayer(matrices, pass, occlusionCamera, realCamera);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void reload() {
        if (this.world == null) {
            return;
        }
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.initRenderer(commandList);
        }
    }

    private void initRenderer(CommandList commandList) {
        if (TerrainRenderingConfig.FastFog) {
            FogState.setDefault(CeleritasWorldRenderer.getEffectiveRenderDistance());
        } else {
            FogGL.read();
        }
        if (this.renderSectionManager != null) {
            this.renderSectionManager.destroy();
            this.renderSectionManager = null;
        }
        this.renderDistance = CeleritasWorldRenderer.getEffectiveRenderDistance();
        this.renderSectionManager = ArchaicRenderSectionManager.create(this.world, this.renderDistance, commandList);
        ChunkTracker tracker = ChunkTrackerHolder.get(this.world);
        ChunkTracker.forEachChunk(tracker.getReadyChunks(), this.renderSectionManager::onChunkAdded);
    }

    public boolean didBlockEntityRequestOutline() {
        return this.blockEntityRequestedOutline;
    }

    public Iterator<TileEntity> blockEntityIterator() {
        return MinecraftBuiltRenderSectionData.generateBlockEntityIterator(this.renderSectionManager.getRenderLists(), this.renderSectionManager.getSectionsWithGlobalEntities());
    }

    public void forEachVisibleBlockEntity(Consumer<TileEntity> consumer) {
        MinecraftBuiltRenderSectionData.forEachBlockEntity(consumer, this.renderSectionManager.getRenderLists(), this.renderSectionManager.getSectionsWithGlobalEntities());
    }

    public boolean shouldRenderBlockEntity(TileEntity tileEntity, int pass) {
        if (!tileEntity.shouldRenderInPass(pass)) {
            return false;
        }
        AxisAlignedBB aabb = tileEntity.getRenderBoundingBox();
        return aabb == TileEntity.INFINITE_EXTENT_AABB || this.currentViewport.isBoxVisible(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    private void getCulledBlockEntities(List<TileEntity> output) {
        SortedRenderLists renderLists = this.renderSectionManager.getRenderLists();
        Iterator<ChunkRenderList> renderListIterator = renderLists.iterator();
        while (renderListIterator.hasNext()) {
            ChunkRenderList renderList = renderListIterator.next();
            RenderRegion renderRegion = renderList.getRegion();
            ByteIterator renderSectionIterator = renderList.sectionsWithEntitiesIterator();
            if (renderSectionIterator == null) continue;
            while (renderSectionIterator.hasNext()) {
                BuiltRenderSectionData context;
                int renderSectionId = renderSectionIterator.nextByteAsInt();
                RenderSection renderSection = renderRegion.getSection(renderSectionId);
                if (renderSection == null || !((context = renderSection.getBuiltContext()) instanceof MinecraftBuiltRenderSectionData)) continue;
                MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
                List blockEntities = mcData.culledBlockEntities;
                if (blockEntities.isEmpty()) continue;
                output.addAll(blockEntities);
            }
        }
    }

    private void getGlobalBlockEntities(List<TileEntity> output) {
        for (RenderSection renderSection : this.renderSectionManager.getSectionsWithGlobalEntities()) {
            BuiltRenderSectionData context = renderSection.getBuiltContext();
            if (!(context instanceof MinecraftBuiltRenderSectionData)) continue;
            MinecraftBuiltRenderSectionData mcData = (MinecraftBuiltRenderSectionData)context;
            List blockEntities = mcData.globalBlockEntities;
            if (blockEntities.isEmpty()) continue;
            output.addAll(blockEntities);
        }
    }

    public void getRenderableBlockEntities(List<TileEntity> output) {
        this.getCulledBlockEntities(output);
        this.getGlobalBlockEntities(output);
    }

    private static boolean isInfiniteExtentsBox(AxisAlignedBB box) {
        return Double.isInfinite(box.field_72340_a) || Double.isInfinite(box.field_72338_b) || Double.isInfinite(box.field_72339_c) || Double.isInfinite(box.field_72336_d) || Double.isInfinite(box.field_72337_e) || Double.isInfinite(box.field_72334_f);
    }

    public boolean isEntityVisible(Entity entity) {
        if (!this.useEntityCulling) {
            return true;
        }
        AxisAlignedBB box = entity.func_70046_E();
        if (CeleritasWorldRenderer.isInfiniteExtentsBox(box)) {
            return true;
        }
        double entityVolume = (box.field_72336_d - box.field_72340_a) * (box.field_72337_e - box.field_72338_b) * (box.field_72334_f - box.field_72339_c);
        if (entityVolume > MAX_ENTITY_CHECK_VOLUME) {
            return true;
        }
        return this.isBoxVisible(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public boolean isBoxVisible(double x1, double y1, double z1, double x2, double y2, double z2) {
        if (y2 < 0.5 || y1 > 254.5) {
            return true;
        }
        int minX = PositionUtil.posToSectionCoord(x1 - 0.5);
        int minY = PositionUtil.posToSectionCoord(y1 - 0.5);
        int minZ = PositionUtil.posToSectionCoord(z1 - 0.5);
        int maxX = PositionUtil.posToSectionCoord(x2 + 0.5);
        int maxY = PositionUtil.posToSectionCoord(y2 + 0.5);
        int maxZ = PositionUtil.posToSectionCoord(z2 + 0.5);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!this.renderSectionManager.isSectionVisible(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getChunksDebugString() {
        return String.format("C: %d/%d D: %d", this.renderSectionManager.getVisibleChunkCount(), this.renderSectionManager.getTotalSections(), this.renderDistance);
    }

    public RenderPassConfiguration<?> getRenderPassConfiguration() {
        return this.renderSectionManager.getRenderPassConfiguration();
    }

    public void scheduleRebuildForBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        int THESHIFT = MegaChunkMetadata.BLOCKS_PER_WR_EDGE_BITS;
        this.scheduleRebuildForChunks(minX >> THESHIFT, minY >> THESHIFT, minZ >> THESHIFT, maxX >> THESHIFT, maxY >> THESHIFT, maxZ >> THESHIFT, important);
    }

    public void scheduleRebuildForChunks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean important) {
        for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
            for (int chunkY = minY; chunkY <= maxY; ++chunkY) {
                for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                    this.scheduleRebuildForChunk(chunkX, chunkY, chunkZ, important);
                }
            }
        }
    }

    public void scheduleRebuildForChunk(int x, int y, int z, boolean important) {
        this.renderSectionManager.scheduleRebuild(x, y, z, important);
    }

    public Collection<String> getDebugStrings() {
        return this.renderSectionManager.getDebugStrings();
    }

    public boolean isSectionReady(int x, int y, int z) {
        return this.renderSectionManager.isSectionBuilt(x, y, z);
    }

    @Generated
    public ArchaicRenderSectionManager getRenderSectionManager() {
        return this.renderSectionManager;
    }
}

