/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import powercrystals.minefactoryreloaded.core.ITankContainerBucketable;
import powercrystals.minefactoryreloaded.core.RemoteInventoryCrafting;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiLiquiCrafter;
import powercrystals.minefactoryreloaded.gui.container.ContainerLiquiCrafter;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityLiquiCrafter
extends TileEntityFactoryInventory
implements ITankContainerBucketable {
    private boolean _lastRedstoneState;
    private boolean _resourcesChangedSinceLastFailedCraft = true;
    protected RemoteInventoryCrafting craft = new RemoteInventoryCrafting();
    protected IRecipe recipe;
    protected ArrayList<ItemStack> outputs = new ArrayList();
    protected List<ItemResourceTracker> requiredItems = new LinkedList<ItemResourceTracker>();

    public TileEntityLiquiCrafter() {
        super(Machine.LiquiCrafter);
        this.setManageSolids(true);
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n > 9;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiLiquiCrafter(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerLiquiCrafter getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerLiquiCrafter(this, inventoryPlayer);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int n = this.outputs.size();
        if (n > 0) {
            if (this._inventory[10] == null) {
                this._inventory[10] = this.outputs.get(--n);
                this.outputs.remove(n);
            }
            return;
        }
        int n2 = n = this._rednetState != 0 || CoreUtils.isRedstonePowered((TileEntity)this) ? 1 : 0;
        if (n != 0 && !this._lastRedstoneState && this._resourcesChangedSinceLastFailedCraft && this.recipe != null && this._inventory[9] != null && (this._inventory[10] == null || this._inventory[10].field_77994_a + this._inventory[9].field_77994_a <= this._inventory[9].func_77976_d() && ItemHelper.itemsEqualWithMetadata((ItemStack)this._inventory[9], (ItemStack)this._inventory[10], (boolean)true))) {
            this.checkResources();
        }
        this._lastRedstoneState = n;
    }

    @Override
    public boolean hasDrops() {
        return this.outputs.size() != 0;
    }

    private void checkResources() {
        block32: {
            int n;
            int n2;
            int n3;
            List<ItemResourceTracker> list = this.requiredItems;
            list.clear();
            for (n3 = 0; n3 < 9; ++n3) {
                FluidStack object2;
                if (this._inventory[n3] == null) continue;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)this._inventory[n3]) && (object2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this._inventory[n3])) != null) {
                    ItemResourceTracker itemResourceTracker = new ItemResourceTracker(n3, object2, object2.amount);
                    itemResourceTracker.item = this._inventory[n3];
                    list.add(itemResourceTracker);
                    continue;
                }
                list.add(new ItemResourceTracker(n3, this._inventory[n3], 1));
            }
            block3: for (n3 = 11; n3 < 29; ++n3) {
                ItemStack itemStack = this._inventory[n3];
                if (itemStack == null) continue;
                int n4 = itemStack.field_77994_a;
                for (ItemResourceTracker itemResourceTracker : list) {
                    if (itemResourceTracker.fluid != null && itemResourceTracker.fluid.isFluidEqual(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack))) {
                        n2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack).amount;
                        int n5 = Math.min(n2 * n4, itemResourceTracker.required - itemResourceTracker.found);
                        itemResourceTracker.found += n5;
                        n4 -= (int)Math.ceil((float)n5 / (float)n2);
                    } else if (ItemHelper.itemsEqualForCrafting((ItemStack)itemResourceTracker.item, (ItemStack)itemStack)) {
                        n2 = Math.min(n4, itemResourceTracker.required - itemResourceTracker.found);
                        itemResourceTracker.found += n2;
                        n4 -= n2;
                    }
                    if (n4 > 0) continue;
                    continue block3;
                }
            }
            block5: for (n3 = 0; n3 < this._tanks.length; ++n3) {
                FluidStack fluidStack = this._tanks[n3].getFluid();
                if (fluidStack == null || fluidStack.amount == 0) continue;
                int n6 = fluidStack.amount;
                for (ItemResourceTracker itemResourceTracker : list) {
                    if (!fluidStack.isFluidEqual(itemResourceTracker.fluid)) continue;
                    itemResourceTracker.found += Math.min(n6, itemResourceTracker.required - itemResourceTracker.found);
                    if ((n6 -= itemResourceTracker.found) > 0) continue;
                    continue block5;
                }
            }
            for (ItemResourceTracker itemResourceTracker : list) {
                if (itemResourceTracker.found >= itemResourceTracker.required) continue;
                this._resourcesChangedSinceLastFailedCraft = false;
                return;
            }
            block8: for (n = 11; n < 29; ++n) {
                ItemStack itemStack = this._inventory[n];
                if (itemStack == null) continue;
                for (ItemResourceTracker itemResourceTracker : list) {
                    boolean bl;
                    boolean bl2 = bl = itemResourceTracker.fluid != null && itemResourceTracker.fluid.isFluidEqual(FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack));
                    if (!bl && !ItemHelper.itemsEqualForCrafting((ItemStack)itemResourceTracker.item, (ItemStack)itemStack)) continue;
                    n2 = 0;
                    if (bl) {
                        n2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack).amount;
                    }
                    if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                        if (!bl) {
                            n2 = 1;
                        }
                        ItemStack itemStack2 = itemStack.func_77973_b().getContainerItem(this._inventory[n]);
                        boolean bl3 = true;
                        if (!(itemStack2 == null || itemStack2.func_77984_f() && itemStack2.func_77960_j() > itemStack2.func_77958_k())) {
                            if (itemStack.func_77973_b().func_77630_h(itemStack)) {
                                this.outputs.add(itemStack2);
                            } else {
                                this._inventory[n] = itemStack2;
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            this._inventory[n] = null;
                        }
                    } else if (bl) {
                        int n7 = Math.min((int)Math.ceil((float)itemResourceTracker.required / (float)n2), itemStack.field_77994_a);
                        itemStack.field_77994_a -= n7;
                        n2 = Math.min(n2 * n7, itemResourceTracker.required);
                    } else {
                        n2 = Math.min(itemResourceTracker.required, itemStack.field_77994_a);
                        itemStack.field_77994_a -= n2;
                    }
                    itemResourceTracker.required -= n2;
                    if (itemStack.field_77994_a <= 0) {
                        this._inventory[n] = null;
                    }
                    if (itemResourceTracker.required != 0) continue;
                    this.craft.func_70299_a(itemResourceTracker.slot, ItemHelper.cloneStack((ItemStack)itemStack, (int)n2));
                    list.remove(itemResourceTracker);
                    --n;
                    continue block8;
                }
            }
            block10: for (n = 0; n < this._tanks.length; ++n) {
                FluidStack fluidStack = this._tanks[n].getFluid();
                if (fluidStack == null || fluidStack.amount == 0) continue;
                for (ItemResourceTracker itemResourceTracker : list) {
                    if (itemResourceTracker.required == 0 || !fluidStack.isFluidEqual(itemResourceTracker.fluid)) continue;
                    int n8 = Math.min(itemResourceTracker.required, fluidStack.amount);
                    this._tanks[n].drain(n8, true);
                    itemResourceTracker.required -= n8;
                    if (itemResourceTracker.required != 0) continue;
                    this.craft.func_70299_a(itemResourceTracker.slot, ItemHelper.cloneStack((ItemStack)this._inventory[itemResourceTracker.slot]));
                    list.remove(itemResourceTracker);
                    --n;
                    continue block10;
                }
            }
            try {
                this._inventory[9] = this.recipe.func_77572_b((InventoryCrafting)this.craft);
            }
            catch (Throwable throwable) {
                if (!this.recipe.func_77569_a((InventoryCrafting)this.craft, this.field_145850_b)) break block32;
                this._inventory[9] = this.recipe.func_77572_b((InventoryCrafting)this.craft);
            }
        }
        if (this._inventory[9] == null) {
            return;
        }
        if (this._inventory[10] == null) {
            this._inventory[10] = ItemHelper.cloneStack((ItemStack)this._inventory[9]);
        } else if (ItemHelper.itemsEqualWithMetadata((ItemStack)this._inventory[10], (ItemStack)this._inventory[9], (boolean)true)) {
            this._inventory[10].field_77994_a += this._inventory[9].field_77994_a;
        } else {
            this.outputs.add(ItemHelper.cloneStack((ItemStack)this._inventory[9]));
        }
    }

    private void calculateOutput() {
        this._inventory[9] = this.findMatchingRecipe();
    }

    public int func_70302_i_() {
        return 29;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this._inventory[n] = itemStack;
        if (n < 9) {
            this.calculateOutput();
        }
        this.onFactoryInventoryChanged();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        ItemStack itemStack = super.func_70298_a(n, n2);
        if (n < 9) {
            this.calculateOutput();
        }
        this.onFactoryInventoryChanged();
        return itemStack;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 10;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 19;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n > 10;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 10;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._resourcesChangedSinceLastFailedCraft = true;
        super.onFactoryInventoryChanged();
    }

    @Override
    public boolean allowBucketFill(ItemStack itemStack) {
        return true;
    }

    @Override
    protected FluidTankAdv[] createTanks() {
        FluidTankAdv[] fluidTankAdvArray = new FluidTankAdv[9];
        for (int i = 0; i < 9; ++i) {
            fluidTankAdvArray[i] = new FluidTankAdv(10000);
        }
        return fluidTankAdvArray;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = this.findFirstMatchingTank(fluidStack);
        if (n >= 0) {
            int n2 = this._tanks[n].fill(fluidStack, bl);
            if (n2 > 0) {
                this._resourcesChangedSinceLastFailedCraft = true;
            }
            return n2;
        }
        n = this.findFirstEmptyTank();
        if (n >= 0) {
            int n3 = this._tanks[n].fill(fluidStack, bl);
            if (n3 > 0) {
                this._resourcesChangedSinceLastFailedCraft = true;
            }
            return n3;
        }
        return 0;
    }

    @Override
    public boolean allowBucketDrain(ItemStack itemStack) {
        return true;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        int n2 = this.findFirstNonEmptyTank();
        if (n2 >= 0) {
            return this._tanks[n2].drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        int n = this.findFirstMatchingTank(fluidStack);
        if (n >= 0) {
            return this._tanks[n].drain(fluidStack.amount, bl);
        }
        return null;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[this._tanks.length];
        int n = this._tanks.length;
        while (n-- > 0) {
            fluidTankInfoArray[n] = this._tanks[n].getInfo();
        }
        return fluidTankInfoArray;
    }

    private int findFirstEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getFluid() != null && this._tanks[i].getFluid().amount != 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstNonEmptyTank() {
        for (int i = 0; i < 9; ++i) {
            if (this._tanks[i].getFluid() == null || this._tanks[i].getFluid().amount <= 0) continue;
            return i;
        }
        return -1;
    }

    private int findFirstMatchingTank(FluidStack fluidStack) {
        if (fluidStack == null) {
            return -1;
        }
        for (int i = 0; i < 9; ++i) {
            if (!fluidStack.isFluidEqual(this._tanks[i].getFluid())) continue;
            return i;
        }
        return -1;
    }

    private ItemStack findMatchingRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.craft.func_70299_a(i, this._inventory[i] == null ? null : this._inventory[i].func_77946_l());
        }
        List list = CraftingManager.func_77594_a().func_77592_b();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IRecipe iRecipe = (IRecipe)list.get(i);
            if (!iRecipe.func_77569_a((InventoryCrafting)this.craft, this.field_145850_b)) continue;
            this.recipe = iRecipe;
            return iRecipe.func_77572_b((InventoryCrafting)this.craft);
        }
        this.recipe = null;
        return null;
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this.outputs.size() != 0) {
            NBTTagList nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this.outputs) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                itemStack.func_77955_b(nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            if (nBTTagList.func_74745_c() > 0) {
                nBTTagCompound.func_74782_a("OutItems", (NBTBase)nBTTagList);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.calculateOutput();
        if (nBTTagCompound.func_74764_b("OutItems")) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("OutItems", 10);
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(n);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                arrayList.add(itemStack);
            }
            this.outputs = arrayList;
        }
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    private static class ItemResourceTracker {
        public FluidStack fluid;
        public ItemStack item;
        public int required;
        public int found;
        public int slot;

        public ItemResourceTracker(int n, ItemStack itemStack, int n2) {
            this.slot = n;
            this.item = itemStack;
            this.required = n2;
        }

        public ItemResourceTracker(int n, FluidStack fluidStack, int n2) {
            this.slot = n;
            this.fluid = fluidStack;
            this.required = n2;
        }

        public String toString() {
            return "Slot: " + this.slot + "; Fluid: " + this.fluid + "; Item: " + this.item + "; Required: " + this.required + "; Found: " + this.found;
        }
    }
}

