/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IMobEggHandler;
import powercrystals.minefactoryreloaded.api.IRandomMobProvider;
import powercrystals.minefactoryreloaded.api.ISafariNetHandler;
import powercrystals.minefactoryreloaded.api.RandomMob;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.item.base.ItemFactory;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.village.VillageTradeHandler;

public class ItemSafariNet
extends ItemFactory {
    private IIcon _iconEmpty;
    private IIcon _iconBack;
    private IIcon _iconMid;
    private IIcon _iconFront;
    private final boolean multiuse;
    private final int type;
    private Random colorRand = new Random();

    public ItemSafariNet(int n) {
        this(n, false);
    }

    public ItemSafariNet(int n, boolean bl) {
        this.multiuse = bl;
        this.type = n;
        this.func_77625_d(bl ? 12 : 1);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        if (!ItemSafariNet.isSingleUse(itemStack) || !ItemSafariNet.isEmpty(itemStack)) {
            return 1;
        }
        return this.field_77777_bU;
    }

    @Override
    public void addInfo(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean bl) {
        super.addInfo(itemStack, entityPlayer, list, bl);
        int n = ((ItemSafariNet)itemStack.func_77973_b()).type;
        if (1 == (n & 1)) {
            list.add(StatCollector.func_74838_a((String)"tip.info.mfr.safarinet.persistent"));
        }
        if (2 == (n & 2)) {
            list.add(StatCollector.func_74838_a((String)"tip.info.mfr.safarinet.nametag"));
        }
        if (itemStack.func_77978_p() == null) {
            return;
        }
        if (itemStack.func_77978_p().func_74767_n("hide")) {
            list.add(StatCollector.func_74838_a((String)"tip.info.mfr.safarinet.mystery"));
        } else {
            list.add(MFRUtil.localize("entity.", itemStack.func_77978_p().func_74779_i("id")));
            Class clazz = (Class)EntityList.field_75625_b.get(itemStack.func_77978_p().func_74779_i("id"));
            if (clazz == null) {
                return;
            }
            for (ISafariNetHandler iSafariNetHandler : MFRRegistry.getSafariNetHandlers()) {
                if (!iSafariNetHandler.validFor().isAssignableFrom(clazz)) continue;
                iSafariNetHandler.addInformation(itemStack, entityPlayer, list, bl);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int n) {
        if (ItemSafariNet.isEmpty(itemStack)) {
            return this._iconEmpty;
        }
        if (n == 0) {
            return this._iconBack;
        }
        if (n == 1) {
            return this._iconMid;
        }
        if (n == 2) {
            return this._iconFront;
        }
        return null;
    }

    @Override
    public void func_94581_a(IIconRegister iIconRegister) {
        this._iconEmpty = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".empty");
        this._iconBack = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".back");
        this._iconMid = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".mid");
        this._iconFront = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_77658_a() + ".front");
        this.field_77791_bV = this._iconEmpty;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int n) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int n) {
        if (itemStack.func_77960_j() == 0 && itemStack.func_77978_p() == null) {
            return 0xFFFFFF;
        }
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("hide")) {
            WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
            this.colorRand.setSeed(worldClient.func_72905_C() ^ worldClient.func_82737_E() / 140L * (long)n);
            if (n == 2) {
                return this.colorRand.nextInt();
            }
            if (n == 1) {
                return this.colorRand.nextInt();
            }
            return 0xFFFFFF;
        }
        EntityList.EntityEggInfo entityEggInfo = this.getEgg(itemStack);
        if (entityEggInfo == null) {
            return 0xFFFFFF;
        }
        if (n == 2) {
            return entityEggInfo.field_75611_b;
        }
        if (n == 1) {
            return entityEggInfo.field_75612_c;
        }
        return 0xFFFFFF;
    }

    private EntityList.EntityEggInfo getEgg(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return null;
        }
        for (IMobEggHandler iMobEggHandler : MFRRegistry.getModMobEggHandlers()) {
            EntityList.EntityEggInfo entityEggInfo = iMobEggHandler.getEgg(itemStack);
            if (entityEggInfo == null) continue;
            return entityEggInfo;
        }
        return null;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int n, int n2, int n3, int n4, float f, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        if (ItemSafariNet.isEmpty(itemStack)) {
            return true;
        }
        if (entityPlayer != null && entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack = itemStack.func_77946_l();
        }
        return ItemSafariNet.releaseEntity(itemStack, world, n, n2, n3, n4) != null;
    }

    public static Entity releaseEntity(ItemStack itemStack, World world, int n, int n2, int n3, int n4) {
        Entity entity;
        if (world.field_72995_K) {
            return null;
        }
        Block block = world.func_147439_a(n, n2, n3);
        n += Facing.field_71586_b[n4];
        n2 += Facing.field_71587_c[n4];
        n3 += Facing.field_71585_d[n4];
        double d = 0.0;
        if (n4 == 1 && block.func_149645_b() == 11) {
            d = 0.5;
        }
        if ((entity = itemStack.func_77960_j() != 0 ? ItemSafariNet.spawnCreature(world, itemStack.func_77960_j(), (double)n + 0.5, (double)n2 + d, (double)n3 + 0.5) : ItemSafariNet.spawnCreature(world, itemStack.func_77978_p(), (double)n + 0.5, (double)n2 + d, (double)n3 + 0.5, n4)) != null) {
            if (entity instanceof EntityLiving) {
                int n5 = ((ItemSafariNet)itemStack.func_77973_b()).type;
                if (1 == (n5 & 1)) {
                    ((EntityLiving)entity).func_110163_bv();
                }
                if (itemStack.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(itemStack.func_82833_r());
                    if (2 == (n5 & 2)) {
                        ((EntityLiving)entity).func_94061_f(true);
                    }
                }
            }
            if (ItemSafariNet.isSingleUse(itemStack)) {
                --itemStack.field_77994_a;
            } else if (itemStack.func_77960_j() != 0) {
                itemStack.func_77964_b(0);
            }
            itemStack.func_77982_d(null);
        }
        return entity;
    }

    private static Entity spawnCreature(World world, NBTTagCompound nBTTagCompound, double d, double d2, double d3, int n) {
        Entity entity;
        NBTTagList nBTTagList;
        if (nBTTagCompound.func_74767_n("hide")) {
            nBTTagList = new ArrayList();
            for (IRandomMobProvider iRandomMobProvider : MFRRegistry.getRandomMobProviders()) {
                nBTTagList.addAll(iRandomMobProvider.getRandomMobs(world));
            }
            Object object = (RandomMob)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)nBTTagList);
            entity = ((RandomMob)((Object)object)).getMob();
            if (entity instanceof EntityLiving && ((RandomMob)((Object)object)).shouldInit) {
                ((EntityLiving)entity).func_110161_a(null);
            }
        } else {
            nBTTagList = nBTTagCompound.func_150295_c("Pos", 6);
            nBTTagList.func_150304_a(0, (NBTBase)new NBTTagDouble(d));
            nBTTagList.func_150304_a(1, (NBTBase)new NBTTagDouble(d2));
            nBTTagList.func_150304_a(2, (NBTBase)new NBTTagDouble(d3));
            entity = EntityList.func_75615_a((NBTTagCompound)nBTTagCompound, (World)world);
            if (entity != null) {
                entity.func_70020_e(nBTTagCompound);
            }
        }
        if (entity != null) {
            int n2 = Facing.field_71586_b[n];
            int n3 = n == 0 ? -1 : 0;
            int n4 = Facing.field_71585_d[n];
            AxisAlignedBB axisAlignedBB = entity.field_70121_D;
            entity.func_70012_b(d + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) * 0.5 * (double)n2, d2 + (axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b) * 0.5 * (double)n3, d3 + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) * 0.5 * (double)n4, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70642_aH();
            }
            Entity entity2 = entity.field_70153_n;
            while (entity2 != null) {
                entity2.func_70012_b(d, d2, d3, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d(entity2);
                if (entity2 instanceof EntityLiving) {
                    ((EntityLiving)entity2).func_70642_aH();
                }
                entity2 = entity2.field_70153_n;
            }
        }
        return entity;
    }

    private static Entity spawnCreature(World world, int n, double d, double d2, double d3) {
        if (!EntityList.field_75627_a.containsKey(n)) {
            return null;
        }
        Entity entity = EntityList.func_75616_a((int)n, (World)world);
        if (entity != null) {
            entity.func_70012_b(d, d2, d3, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_110161_a(null);
            }
            world.func_72838_d(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70642_aH();
            }
        }
        return entity;
    }

    public boolean func_111207_a(ItemStack itemStack, EntityPlayer entityPlayer, EntityLivingBase entityLivingBase) {
        return ItemSafariNet.captureEntity(itemStack, entityLivingBase, entityPlayer);
    }

    public static boolean captureEntity(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return ItemSafariNet.captureEntity(itemStack, entityLivingBase, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean captureEntity(ItemStack itemStack, EntityLivingBase entityLivingBase, EntityPlayer entityPlayer) {
        if (entityLivingBase.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ItemSafariNet.isEmpty(itemStack)) {
            return false;
        }
        if (MFRRegistry.getSafariNetBlacklist().contains(entityLivingBase.getClass())) {
            return false;
        }
        if (!(entityLivingBase instanceof EntityPlayer)) {
            boolean bl = entityPlayer != null && entityPlayer.field_71075_bZ.field_75098_d;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            EntityLivingBase entityLivingBase2 = entityLivingBase;
            synchronized (entityLivingBase2) {
                entityLivingBase.func_70109_d(nBTTagCompound);
                nBTTagCompound.func_74778_a("id", EntityList.func_75621_b((Entity)entityLivingBase));
                if (entityLivingBase.field_70128_L) {
                    return false;
                }
                if (!bl) {
                    entityLivingBase.func_70106_y();
                }
                if (bl | entityLivingBase.field_70128_L) {
                    bl = false;
                    if (--itemStack.field_77994_a > 0) {
                        bl = true;
                        itemStack = itemStack.func_77946_l();
                    }
                    itemStack.field_77994_a = 1;
                    itemStack.func_77982_d(nBTTagCompound);
                    if (bl && (entityPlayer == null || !entityPlayer.field_71071_by.func_70441_a(itemStack))) {
                        UtilInventory.dropStackInAir(entityLivingBase.field_70170_p, (Entity)entityLivingBase, itemStack);
                    } else if (bl) {
                        entityPlayer.field_71070_bA.func_75142_b();
                        ((EntityPlayerMP)entityPlayer).func_71110_a(entityPlayer.field_71070_bA, entityPlayer.field_71070_bA.func_75138_a());
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return !ItemSafariNet.isSafariNet(itemStack) || itemStack.func_77960_j() == 0 && (itemStack.func_77978_p() == null || !itemStack.func_77978_p().func_74764_b("id") && !itemStack.func_77978_p().func_74767_n("hide"));
    }

    public static boolean isSingleUse(ItemStack itemStack) {
        return ItemSafariNet.isSafariNet(itemStack) && !((ItemSafariNet)itemStack.func_77973_b()).multiuse;
    }

    public static boolean isSafariNet(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof ItemSafariNet;
    }

    public static ItemStack makeMysteryNet(ItemStack itemStack) {
        if (ItemSafariNet.isSafariNet(itemStack)) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74757_a("hide", true);
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public static Class<?> getEntityClass(ItemStack itemStack) {
        if (!ItemSafariNet.isSafariNet(itemStack) || ItemSafariNet.isEmpty(itemStack)) {
            return null;
        }
        if (itemStack.func_77960_j() != 0) {
            int n = itemStack.func_77960_j();
            if (!EntityList.field_75627_a.containsKey(n)) {
                return null;
            }
            return (Class)EntityList.field_75623_d.get(n);
        }
        String string = itemStack.func_77978_p().func_74779_i("id");
        if (!EntityList.field_75625_b.containsKey(string)) {
            return null;
        }
        return (Class)EntityList.field_75625_b.get(string);
    }

    @Override
    public void getSubItems(Item item, List<ItemStack> list) {
        super.getSubItems(item, list);
        if (item.equals(MFRThings.safariNetSingleItem)) {
            list.add(VillageTradeHandler.getHiddenNetStack());
        }
    }
}

