/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.circuits.timing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.circuits.base.StatelessCircuit;

public class Delay8ch
extends StatelessCircuit {
    private int delayTime;
    private Map<Integer, List<Integer>> history = new HashMap<Integer, List<Integer>>();

    public Delay8ch() {
        for (int i = 0; i < 8; ++i) {
            this.history.put(i, new ArrayList());
        }
    }

    @Override
    public byte getInputCount() {
        return 9;
    }

    @Override
    public byte getOutputCount() {
        return 8;
    }

    @Override
    public int[] recalculateOutputValues(long l, int[] nArray) {
        int[] nArray2 = new int[8];
        this.delayTime = nArray[8];
        if (this.delayTime < 0) {
            this.delayTime = 0;
        }
        for (int i = 0; i < 8; ++i) {
            this.history.get(i).add(0, nArray[i]);
            if (this.history.get(i).size() <= this.delayTime) continue;
            nArray2[i] = this.history.get(i).get(this.delayTime);
            for (int j = this.delayTime; j < this.history.size(); ++j) {
                this.history.get(i).remove(j);
            }
        }
        return nArray2;
    }

    @Override
    public String getUnlocalizedName() {
        return "circuit.mfr.delay8ch";
    }

    @Override
    public String getInputPinLabel(int n) {
        return n == 8 ? "D" : "I" + n;
    }

    @Override
    public String getOutputPinLabel(int n) {
        return "O" + n;
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        this.delayTime = nBTTagCompound.func_74762_e("delayTime");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.delayTime; ++j) {
                this.history.get(i).add(nBTTagCompound.func_74762_e("input" + i + "H" + j));
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("delayTime", this.delayTime);
        for (int i = 0; i < 8; ++i) {
            for (Integer n : this.history.get(i)) {
                int n2 = 0;
                nBTTagCompound.func_74768_a("input" + i + "H" + n2, n.intValue());
                ++n2;
            }
        }
    }
}

