/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.config;

import java.io.File;
import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;

public abstract class Config {
    public static final File configDir = new File(Launch.minecraftHome, "config");
    public final File file;

    public Config(File file) {
        this.file = file;
    }

    public Config(String name) {
        this.file = new File(configDir, name);
    }

    public abstract void read();

    public abstract void save();

    public String readFile() {
        if (this.file.exists()) {
            try {
                return FileUtils.readFileToString((File)this.file);
            }
            catch (IOException iOException) {
            }
        } else {
            this.resetFile();
        }
        return "";
    }

    public void saveFile(String config) {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            FileUtils.writeStringToFile((File)this.file, (String)config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetFile() {
        try {
            this.file.delete();
            this.file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configDir.mkdir();
    }
}

