/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.asm.minecraft;

import cn.tesseract.mycelium.asm.ClassMetadataReader;
import cn.tesseract.mycelium.asm.minecraft.HookLibPlugin;
import cn.tesseract.mycelium.asm.minecraft.HookLoader;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.lang.reflect.Method;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassVisitor;

public class DeobfuscationMetadataReader
extends ClassMetadataReader {
    private static Method runTransformers;

    @Override
    public byte[] getClassData(String className) throws IOException {
        byte[] bytes = super.getClassData(DeobfuscationMetadataReader.unmap(className.replace('.', '/')));
        return DeobfuscationMetadataReader.deobfuscateClass(className, bytes);
    }

    @Override
    protected boolean checkSameMethod(String sourceName, String sourceDesc, String targetName, String targetDesc) {
        return HookLibPlugin.getMethodMcpName(sourceName).equals(targetName) && sourceDesc.equals(targetDesc);
    }

    @Override
    protected ClassMetadataReader.MethodReference getMethodReferenceASM(String type, String methodName, String desc) throws IOException {
        ClassMetadataReader.FindMethodClassVisitor cv = new ClassMetadataReader.FindMethodClassVisitor(methodName, desc);
        byte[] bytes = DeobfuscationMetadataReader.getTransformedBytes(type);
        this.acceptVisitor(bytes, (ClassVisitor)cv);
        return cv.found ? new ClassMetadataReader.MethodReference(type, cv.targetName, cv.targetDesc) : null;
    }

    static byte[] deobfuscateClass(String className, byte[] bytes) {
        if (HookLoader.getDeobfuscationTransformer() != null) {
            bytes = HookLoader.getDeobfuscationTransformer().transform(className, className, bytes);
        }
        return bytes;
    }

    private static byte[] getTransformedBytes(String type) throws IOException {
        String obfName = DeobfuscationMetadataReader.unmap(type);
        byte[] bytes = Launch.classLoader.getClassBytes(obfName);
        if (bytes == null) {
            throw new RuntimeException("Bytes for " + obfName + " not found");
        }
        try {
            bytes = (byte[])runTransformers.invoke((Object)Launch.classLoader, obfName, type, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private static String unmap(String type) {
        if (HookLibPlugin.getObfuscated()) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(type);
        }
        return type;
    }

    static {
        try {
            runTransformers = LaunchClassLoader.class.getDeclaredMethod("runTransformers", String.class, String.class, byte[].class);
            runTransformers.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

