/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.asm;

import cn.tesseract.mycelium.asm.ClassMetadataReader;
import cn.tesseract.mycelium.asm.minecraft.HookLibPlugin;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MiscHelper {
    private static ClassMetadataReader classMetadataReader = new ClassMetadataReader();

    public static List<String> listLocalVariables(byte[] classData, final String methodName, Type ... argTypes) {
        final ArrayList<String> localVariables = new ArrayList<String>();
        String methodDesc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])argTypes);
        final String methodDescWithoutReturnType = methodDesc.substring(0, methodDesc.length() - 1);
        ClassVisitor cv = new ClassVisitor(327680){

            public MethodVisitor visitMethod(final int acc, String name, String desc, String signature, String[] exceptions) {
                if (methodName.equals(name) && desc.startsWith(methodDescWithoutReturnType)) {
                    return new MethodVisitor(327680){

                        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                            String typeName = Type.getType((String)desc).getClassName();
                            int fixedIndex = index + ((acc & 8) != 0 ? 1 : 0);
                            localVariables.add(fixedIndex + ": " + typeName + " " + name);
                        }
                    };
                }
                return null;
            }
        };
        classMetadataReader.acceptVisitor(classData, cv);
        return localVariables;
    }

    public static List<String> listLocalVariables(String className, String methodName, Type ... argTypes) throws IOException {
        return MiscHelper.listLocalVariables(classMetadataReader.getClassData(className), methodName, argTypes);
    }

    public static void printLocalVariables(byte[] classData, String methodName, Type ... argTypes) {
        List<String> locals = MiscHelper.listLocalVariables(classData, methodName, argTypes);
        for (String str : locals) {
            System.out.println(str);
        }
    }

    public static void printLocalVariables(String className, String methodName, Type ... argTypes) throws IOException {
        MiscHelper.printLocalVariables(classMetadataReader.getClassData(className), methodName, argTypes);
    }

    public static String getMethodDescriptor(Method m) {
        return "L" + m.getDeclaringClass().getName().replace('.', '/') + ";" + HookLibPlugin.getMethodMcpName(m.getName()) + Type.getMethodDescriptor((Method)m);
    }

    public static List<String> getMethodDescriptors(Class<?> c) {
        ArrayList<String> descs = new ArrayList<String>();
        for (Method m : c.getDeclaredMethods()) {
            descs.add(MiscHelper.getMethodDescriptor(m));
        }
        return descs;
    }

    public static void printMethodDescriptors(Class<?> c) {
        List<String> descs = MiscHelper.getMethodDescriptors(c);
        for (String str : descs) {
            System.out.println(str);
        }
    }
}

