/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.asm;

import cn.tesseract.mycelium.asm.NodeTransformer;
import cn.tesseract.mycelium.asm.minecraft.HookLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Accessor
implements NodeTransformer {
    private final String accessor;
    private final Map<String, String> getterMap = new HashMap<String, String>();
    private final Map<String, String> setterMap = new HashMap<String, String>();

    public Accessor(String accessor) {
        this.accessor = accessor;
    }

    @Override
    public void transform(ClassNode node) {
        byte[] bytecode;
        try {
            bytecode = HookLoader.getTransformer().classMetadataReader.getClassData(this.accessor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassReader cr = new ClassReader(bytecode);
        ClassVisitor cv = new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (name.startsWith("get_")) {
                    Accessor.this.getterMap.put(name.substring(4), Type.getReturnType((String)desc).getDescriptor());
                } else if (name.startsWith("set_")) {
                    Accessor.this.setterMap.put(name.substring(4), Type.getArgumentTypes((String)desc)[0].getDescriptor());
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept(cv, 8);
        node.interfaces.add(this.accessor.replace('.', '/'));
        this.getterMap.forEach((name, desc) -> {
            boolean f = true;
            for (FieldNode field : node.fields) {
                if (!field.name.equals(name)) continue;
                f = false;
                break;
            }
            if (f) {
                FieldNode fieldNode = new FieldNode(1, name, desc, null, null);
                node.fields.add(fieldNode);
            }
            MethodNode getter = new MethodNode(1, "get_" + name, "()" + desc, null, null);
            getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, name, desc));
            getter.instructions.add((AbstractInsnNode)new InsnNode(Accessor.getReturn(Type.getType((String)desc))));
            node.methods.add(getter);
        });
        this.setterMap.forEach((name, desc) -> {
            boolean f = true;
            for (FieldNode field : node.fields) {
                if (!field.name.equals(name)) continue;
                f = false;
                break;
            }
            if (f) {
                FieldNode fieldNode = new FieldNode(1, name, desc, null, null);
                node.fields.add(fieldNode);
            }
            MethodNode setter = new MethodNode(1, "set_" + name, "(" + desc + ")V", null, null);
            setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            setter.instructions.add((AbstractInsnNode)new VarInsnNode(Accessor.getLoad(Type.getType((String)desc)), 1));
            setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, node.name, name, desc));
            setter.instructions.add((AbstractInsnNode)new InsnNode(177));
            node.methods.add(setter);
        });
    }

    public static int getLoad(Type type) {
        if (type == Type.INT_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE || type == Type.BOOLEAN_TYPE || type == Type.SHORT_TYPE) {
            return 21;
        }
        if (type == Type.LONG_TYPE) {
            return 22;
        }
        if (type == Type.FLOAT_TYPE) {
            return 23;
        }
        if (type == Type.DOUBLE_TYPE) {
            return 24;
        }
        return 25;
    }

    public static int getReturn(Type type) {
        if (type == Type.INT_TYPE || type == Type.SHORT_TYPE || type == Type.BOOLEAN_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE) {
            return 172;
        }
        if (type == Type.LONG_TYPE) {
            return 173;
        }
        if (type == Type.FLOAT_TYPE) {
            return 174;
        }
        if (type == Type.DOUBLE_TYPE) {
            return 175;
        }
        if (type == Type.VOID_TYPE) {
            return 177;
        }
        return 176;
    }
}

