/*
 * Decompiled with CFR 0.152.
 */
package weather2.volcano;

import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import weather2.Weather;
import weather2.util.WeatherUtil;
import weather2.weathersystem.WeatherManagerBase;

public class VolcanoObject {
    public static long lastUsedID = 0L;
    public long ID;
    public WeatherManagerBase manager;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesSmoke = new ArrayList<EntityRotFX>();
    @SideOnly(value=Side.CLIENT)
    public ParticleBehaviors particleBehaviors;
    public int sizeMaxParticles = 300;
    public static int staticYPos = 200;
    public Vec3 pos = Vec3.func_72443_a((double)0.0, (double)staticYPos, (double)0.0);
    public int processRateDelay = 20;
    public Block topBlockID = Blocks.field_150350_a;
    public int startYPos = -1;
    public int curRadius = 5;
    public int curHeight = 3;
    public int state = 0;
    public int size = 0;
    public int maxSize = 20;
    public int step = 0;
    public int stepsBuildupMax = 20;
    public int ticksToErupt = 600;
    public int ticksPerformedErupt = 0;
    public int ticksToCooldown = 600;
    public int ticksPerformedCooldown = 0;
    public int growthStage = 0;

    public VolcanoObject(WeatherManagerBase parManager) {
        this.manager = parManager;
    }

    public void initFirstTime() {
        this.ID = lastUsedID++;
    }

    public void initPost() {
    }

    public void resetEruption() {
        this.step = 0;
        this.ticksPerformedErupt = 0;
        this.ticksPerformedCooldown = 0;
        this.state = 2;
        this.ticksPerformedErupt = 0;
        this.ticksPerformedCooldown = 0;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.ID = data.func_74763_f("ID");
        this.pos = Vec3.func_72443_a((double)data.func_74762_e("posX"), (double)data.func_74762_e("posY"), (double)data.func_74762_e("posZ"));
        this.size = data.func_74762_e("size");
        this.maxSize = data.func_74762_e("maxSize");
        this.state = data.func_74762_e("state");
        this.curRadius = data.func_74762_e("curRadius");
        this.curHeight = data.func_74762_e("curHeight");
        this.topBlockID = (Block)Block.field_149771_c.func_82594_a(data.func_74779_i("topBlockID"));
        this.startYPos = data.func_74762_e("startYPos");
        this.step = data.func_74762_e("step");
        this.ticksPerformedErupt = data.func_74762_e("ticksPerformedErupt");
        this.ticksPerformedCooldown = data.func_74762_e("ticksPerformedCooldown");
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74772_a("ID", this.ID);
        data.func_74768_a("posX", (int)this.pos.field_72450_a);
        data.func_74768_a("posY", (int)this.pos.field_72448_b);
        data.func_74768_a("posZ", (int)this.pos.field_72449_c);
        data.func_74768_a("size", this.size);
        data.func_74768_a("maxSize", this.maxSize);
        data.func_74768_a("state", this.state);
        data.func_74768_a("curRadius", this.curRadius);
        data.func_74768_a("curHeight", this.curHeight);
        data.func_74778_a("topBlockID", Block.field_149771_c.func_148750_c((Object)this.topBlockID));
        data.func_74768_a("startYPos", this.startYPos);
        data.func_74768_a("step", this.step);
        data.func_74768_a("ticksPerformedErupt", this.ticksPerformedErupt);
        data.func_74768_a("ticksPerformedCooldown", this.ticksPerformedCooldown);
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.ID = parNBT.func_74763_f("ID");
        Weather.dbg("VolcanoObject " + this.ID + " receiving sync");
        this.pos = Vec3.func_72443_a((double)parNBT.func_74762_e("posX"), (double)parNBT.func_74762_e("posY"), (double)parNBT.func_74762_e("posZ"));
        this.size = parNBT.func_74762_e("size");
        this.maxSize = parNBT.func_74762_e("maxSize");
        this.state = parNBT.func_74762_e("state");
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("posX", (int)this.pos.field_72450_a);
        data.func_74768_a("posY", (int)this.pos.field_72448_b);
        data.func_74768_a("posZ", (int)this.pos.field_72449_c);
        data.func_74772_a("ID", this.ID);
        data.func_74768_a("size", this.size);
        data.func_74768_a("maxSize", this.maxSize);
        data.func_74768_a("state", this.state);
        return data;
    }

    public void tick() {
        this.processRateDelay = 10;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                this.tickClient();
            }
        } else {
            World world = this.manager.getWorld();
            float res = 5.0f;
            if (this.state == 0) {
                this.pos.field_72450_a = Math.floor(this.pos.field_72450_a);
                this.pos.field_72449_c = Math.floor(this.pos.field_72449_c);
                this.pos.field_72448_b = world.func_72976_f((int)this.pos.field_72450_a, (int)this.pos.field_72449_c);
                this.startYPos = (int)this.pos.field_72448_b;
                this.topBlockID = world.func_147439_a(MathHelper.func_76128_c((double)this.pos.field_72450_a), MathHelper.func_76128_c((double)(this.pos.field_72448_b - 1.0)), MathHelper.func_76128_c((double)this.pos.field_72449_c));
                if (CoroUtilBlock.isAir((Block)this.topBlockID) || !this.topBlockID.func_149747_d((IBlockAccess)world, (int)this.pos.field_72450_a, (int)this.pos.field_72448_b - 1, (int)this.pos.field_72449_c, 0)) {
                    this.topBlockID = world.func_147439_a((int)this.pos.field_72450_a, (int)this.pos.field_72448_b - 1, (int)this.pos.field_72449_c);
                }
                for (int yy = this.startYPos + this.curHeight; yy > 2; --yy) {
                    for (int dist = 0; dist <= this.curRadius; ++dist) {
                        double vecX = dist;
                        double vecZ = 0.0;
                        if (yy > this.startYPos) {
                            vecX = dist + (this.startYPos - yy);
                        }
                        for (double angle = 0.0; angle <= 360.0; angle += (double)res) {
                            Block idScan;
                            Vec3 vec = Vec3.func_72443_a((double)vecX, (double)0.0, (double)vecZ);
                            vec.func_72442_b((float)angle);
                            int posX = (int)Math.floor(this.pos.field_72450_a + vec.field_72450_a + 0.5);
                            int posZ = (int)Math.floor(this.pos.field_72449_c + vec.field_72449_c + 0.5);
                            Block blockID = Blocks.field_150343_Z;
                            if (yy >= this.startYPos) {
                                blockID = this.topBlockID;
                            } else if (dist < this.curRadius) {
                                blockID = Blocks.field_150353_l;
                            }
                            if (yy == this.startYPos + this.curHeight || !CoroUtilBlock.isAir((Block)(idScan = world.func_147439_a(posX, yy, posZ))) && idScan.func_149688_o() != Material.field_151586_h) continue;
                            world.func_147449_b(posX, yy, posZ, blockID);
                        }
                    }
                }
                ++this.state;
                System.out.println("initial volcano created");
            } else if (this.state == 1) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    ++this.size;
                    ++this.curHeight;
                    ++this.curRadius;
                    if (this.size >= this.maxSize) {
                        ++this.state;
                    }
                    res = 1.0f;
                    for (int yy = 0; yy <= this.curHeight; ++yy) {
                        int radiusForLayer = Math.max(0, this.curRadius - yy - 2);
                        double vecX = radiusForLayer;
                        double vecZ = 0.0;
                        for (double angle = 0.0; angle <= 360.0; angle += (double)res) {
                            Vec3 vec = Vec3.func_72443_a((double)vecX, (double)0.0, (double)vecZ);
                            vec.func_72442_b((float)angle);
                            int posX = (int)Math.floor(this.pos.field_72450_a + vec.field_72450_a + 0.5);
                            int posZ = (int)Math.floor(this.pos.field_72449_c + vec.field_72449_c + 0.5);
                            Block blockID = this.topBlockID;
                            Random rand = new Random();
                            if (rand.nextInt(4) != 0) continue;
                            if (yy != this.curHeight && CoroUtilBlock.isAir((Block)world.func_147439_a(posX, this.startYPos + yy, posZ))) {
                                world.func_147449_b(posX, this.startYPos + yy, posZ, blockID);
                            }
                            int underY = this.startYPos + yy - 1;
                            Block underBlockID = world.func_147439_a(posX, underY, posZ);
                            while ((CoroUtilBlock.isAir((Block)underBlockID) || underBlockID.func_149688_o() == Material.field_151586_h) && underY > 1) {
                                world.func_147449_b(posX, underY, posZ, Blocks.field_150346_d);
                                underBlockID = world.func_147439_a(posX, --underY, posZ);
                            }
                        }
                    }
                    System.out.println("cur size: " + this.size + " - " + this.curHeight + " - " + this.curRadius);
                }
            } else if (this.state == 2) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    if (this.step <= this.maxSize) {
                        int posX = (int)Math.floor(this.pos.field_72450_a);
                        int posY = (int)Math.floor(this.startYPos) + this.step;
                        int posZ = (int)Math.floor(this.pos.field_72449_c);
                        world.func_147449_b(posX, posY, posZ, Blocks.field_150353_l);
                        world.func_147449_b(posX + 1, posY, posZ, Blocks.field_150353_l);
                        world.func_147449_b(posX - 1, posY, posZ, Blocks.field_150353_l);
                        world.func_147449_b(posX, posY, posZ + 1, Blocks.field_150353_l);
                        world.func_147449_b(posX, posY, posZ - 1, Blocks.field_150353_l);
                    } else {
                        this.step = 0;
                        ++this.state;
                    }
                    ++this.step;
                }
            } else if (this.state == 3) {
                if (this.manager.getWorld().func_82737_E() % (long)this.processRateDelay == 0L) {
                    ++this.step;
                    if (this.step > this.stepsBuildupMax) {
                        this.step = 0;
                        ++this.state;
                    }
                }
            } else if (this.state == 4) {
                if (this.ticksPerformedErupt == 0) {
                    Weather.dbg("volcano " + this.ID + " is erupting");
                    for (int i = 0; i < 3; ++i) {
                        int posX = (int)Math.floor(this.pos.field_72450_a);
                        int posY = (int)Math.floor(this.startYPos) + this.maxSize + i;
                        int posZ = (int)Math.floor(this.pos.field_72449_c);
                        Block blockID = Blocks.field_150353_l;
                        world.func_147449_b(posX, posY, posZ, blockID);
                        world.func_147449_b(posX + 1, posY, posZ, blockID);
                        world.func_147449_b(posX - 1, posY, posZ, blockID);
                        world.func_147449_b(posX, posY, posZ + 1, blockID);
                        world.func_147449_b(posX, posY, posZ - 1, blockID);
                        world.func_147449_b(posX + 1, posY, posZ + 1, blockID);
                        world.func_147449_b(posX - 1, posY, posZ - 1, blockID);
                        world.func_147449_b(posX - 1, posY, posZ + 1, blockID);
                        world.func_147449_b(posX + 1, posY, posZ - 1, blockID);
                    }
                }
                ++this.ticksPerformedErupt;
                if (this.ticksPerformedErupt > this.ticksToErupt) {
                    ++this.state;
                }
            } else if (this.state == 5) {
                if (this.ticksPerformedCooldown == 0) {
                    Weather.dbg("volcano " + this.ID + " is cooling");
                }
                if (this.ticksPerformedCooldown % this.processRateDelay == 0) {
                    int posX = (int)Math.floor(this.pos.field_72450_a);
                    int posY = (int)Math.floor(this.startYPos) + this.maxSize - this.step + 2;
                    int posZ = (int)Math.floor(this.pos.field_72449_c);
                    Block blockID = Blocks.field_150348_b;
                    world.func_147449_b(posX, posY, posZ, blockID);
                    world.func_147449_b(posX + 1, posY, posZ, blockID);
                    world.func_147449_b(posX - 1, posY, posZ, blockID);
                    world.func_147449_b(posX, posY, posZ + 1, blockID);
                    world.func_147449_b(posX, posY, posZ - 1, blockID);
                    world.func_147449_b(posX + 1, posY, posZ + 1, blockID);
                    world.func_147449_b(posX - 1, posY, posZ - 1, blockID);
                    world.func_147449_b(posX - 1, posY, posZ + 1, blockID);
                    world.func_147449_b(posX + 1, posY, posZ - 1, blockID);
                    ++this.step;
                }
                ++this.ticksPerformedCooldown;
                if (this.ticksPerformedCooldown > this.ticksToCooldown) {
                    ++this.state;
                }
            } else if (this.state == 6) {
                Weather.dbg("volcano " + this.ID + " has reset!");
                this.resetEruption();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        int i;
        if (this.particleBehaviors == null) {
            this.particleBehaviors = new ParticleBehaviors(Vec3.func_72443_a((double)this.pos.field_72450_a, (double)this.pos.field_72448_b, (double)this.pos.field_72449_c));
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviors.tickUpdateList();
        }
        int delay = 1;
        int loopSize = 1;
        Random rand = new Random();
        if (this.manager.getWorld().func_82737_E() % (long)delay == 0L) {
            for (i = 0; i < loopSize; ++i) {
                if (this.listParticlesSmoke.size() >= 500) continue;
                double spawnRad = this.size / 48;
                EntityRotFX particle = this.spawnSmokeParticle(this.pos.field_72450_a + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.pos.field_72448_b + (double)this.size + 2.0, this.pos.field_72449_c + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad);
                this.listParticlesSmoke.add(particle);
            }
        }
        delay = 1;
        loopSize = 2;
        for (i = 0; i < this.listParticlesSmoke.size(); ++i) {
            EntityRotFX ent = this.listParticlesSmoke.get(i);
            if (ent.field_70128_L) {
                this.listParticlesSmoke.remove(ent);
                continue;
            }
            double speed = 0.4 + rand.nextDouble() * 1.0 * 0.01;
            double distt = 300.0;
            double curDist = ent.func_70011_f(this.pos.field_72450_a, (double)staticYPos, this.pos.field_72449_c);
            double vecX = ent.field_70165_t - this.pos.field_72450_a;
            double vecZ = ent.field_70161_v - this.pos.field_72449_c;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 50.0f;
            angle = (float)((double)angle - (double)(ent.func_145782_y() % 10) * 3.0);
            angle += (float)(rand.nextInt(10) - rand.nextInt(10));
            if (curDist > distt) {
                angle += 20.0f;
            }
            double d = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnSmokeParticle(double x, double y, double z) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviors.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.cloud256, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed);
        this.particleBehaviors.initParticle(entityfx);
        ParticleBehaviors.setParticleRandoms((EntityRotFX)entityfx, (boolean)true, (boolean)true);
        ParticleBehaviors.setParticleFire((EntityRotFX)entityfx);
        entityfx.field_70145_X = true;
        entityfx.callUpdatePB = false;
        entityfx.setMaxAge(400 + rand.nextInt(200));
        entityfx.setScale(50.0f);
        float randFloat = rand.nextFloat() * 0.6f;
        float baseBright = 0.1f;
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.func_70538_b(finalBright, finalBright, finalBright);
        ExtendedRenderer.rotEffRenderer.addEffect((EntityFX)entityfx);
        this.particleBehaviors.particles.add(entityfx);
        return entityfx;
    }

    public void reset() {
        this.setDead();
    }

    public void setDead() {
        Weather.dbg("volcano... killed? NO ONE KILLS A VOLCANO!");
    }
}

