/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.animal.MoCEntityBigCat;
import drzhark.mocreatures.entity.animal.MoCEntityElephant;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.animal.MoCEntityKitty;
import drzhark.mocreatures.entity.animal.MoCEntityOstrich;
import drzhark.mocreatures.entity.animal.MoCEntityWyvern;
import drzhark.mocreatures.item.MoCItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class MoCItemWhip
extends MoCItem {
    int bigCatWhipCounter;

    public MoCItemWhip(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77656_e(64);
    }

    public boolean func_77662_d() {
        return true;
    }

    public ItemStack onItemRightClick2(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int l, float f1, float f2, float f3) {
        Block block = world.func_147439_a(x, y, z);
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        if (l != 0 && block != null && blockAbove == Blocks.field_150350_a && block != Blocks.field_150350_a && block != Blocks.field_150472_an) {
            MoCItemWhip.whipFX(world, x, y, z);
            world.func_72956_a((Entity)entityPlayer, "mocreatures:whip", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            itemStack.func_77972_a(1, (EntityLivingBase)entityPlayer);
            MoCEntityAnimal closestWhippableEntityToPlayer = this.findClosestWhippableEntityNearPlayer(entityPlayer);
            if (closestWhippableEntityToPlayer != null) {
                if (closestWhippableEntityToPlayer.getOwnerName() != null && closestWhippableEntityToPlayer.getOwnerName().length() > 0 && !entityPlayer.func_70005_c_().equals(closestWhippableEntityToPlayer.getOwnerName())) {
                    if (closestWhippableEntityToPlayer.isPredator() && closestWhippableEntityToPlayer.field_70153_n == null) {
                        closestWhippableEntityToPlayer.func_70784_b((Entity)entityPlayer);
                    }
                } else {
                    this.performWhipActionOnWhippableEntity(entityPlayer, closestWhippableEntityToPlayer, world);
                }
            }
        }
        return true;
    }

    private MoCEntityAnimal findClosestWhippableEntityNearPlayer(EntityPlayer entityPlayer) {
        double currentMinimumDistance = -1.0;
        double distance = 8.0;
        MoCEntityAnimal entityAnimal = null;
        List entitiesNearbyList = entityPlayer.field_70170_p.func_72839_b((Entity)entityPlayer, entityPlayer.field_70121_D.func_72314_b(distance, distance, distance));
        int iterationLength = entitiesNearbyList.size();
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityAnimal) || !(entityNearby instanceof MoCEntityBigCat) && !(entityNearby instanceof MoCEntityHorse) && !(entityNearby instanceof MoCEntityKitty) && !(entityNearby instanceof MoCEntityWyvern) && !(entityNearby instanceof MoCEntityOstrich) && !(entityNearby instanceof MoCEntityElephant)) continue;
                double overallDistanceSquared = entityNearby.func_70092_e(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
                if (!(distance < 0.0) && !(overallDistanceSquared < distance * distance) || currentMinimumDistance != -1.0 && !(overallDistanceSquared < currentMinimumDistance) || !((EntityLivingBase)entityNearby).func_70685_l((Entity)entityPlayer)) continue;
                currentMinimumDistance = overallDistanceSquared;
                entityAnimal = (MoCEntityAnimal)entityNearby;
            }
        }
        return entityAnimal;
    }

    private void performWhipActionOnWhippableEntity(EntityPlayer entityPlayer, MoCEntityAnimal entityAnimal, World world) {
        if (entityAnimal != null) {
            MoCEntityWyvern entityWyvern;
            MoCEntityKitty entityKitty;
            MoCEntityHorse entityHorse;
            if (entityAnimal instanceof MoCEntityBigCat) {
                MoCEntityBigCat entityBigcat = (MoCEntityBigCat)entityAnimal;
                if (entityBigcat.getIsTamed()) {
                    entityBigcat.setSitting(!entityBigcat.getIsSitting());
                    ++this.bigCatWhipCounter;
                } else if (world.field_73013_u.func_151525_a() > 0 && entityBigcat.getIsAdult()) {
                    entityBigcat.func_70784_b((Entity)entityPlayer);
                }
            }
            if (this.bigCatWhipCounter > 6) {
                entityPlayer.func_71064_a((StatBase)MoCAchievements.indiana, 1);
                this.bigCatWhipCounter = 0;
            }
            if (entityAnimal instanceof MoCEntityHorse && (entityHorse = (MoCEntityHorse)entityAnimal).getIsTamed()) {
                if (entityHorse.field_70153_n == null) {
                    entityHorse.func_70019_c(!entityHorse.getEating());
                } else if (entityHorse.isNightmare()) {
                    entityHorse.setNightmareFireTrailCounter(250);
                } else if (entityHorse.sprintCounter == 0) {
                    entityHorse.sprintCounter = 1;
                    if (entityHorse.isUndead()) {
                        world.func_72956_a((Entity)entityAnimal, "mocreatures:horsemadundead", 1.0f, 1.2f);
                    } else if (entityHorse.isGhostHorse()) {
                        world.func_72956_a((Entity)entityAnimal, "mocreatures:horsemadghost", 1.0f, 1.2f);
                    } else {
                        world.func_72956_a((Entity)entityAnimal, "mocreatures:horsemad", 1.0f, 1.2f);
                    }
                }
            }
            if (entityAnimal instanceof MoCEntityKitty && (entityKitty = (MoCEntityKitty)entityAnimal).getKittyState() > 2 && entityKitty.isWhipeable()) {
                entityKitty.setSitting(!entityKitty.getIsSitting());
            }
            if (entityAnimal instanceof MoCEntityWyvern && (entityWyvern = (MoCEntityWyvern)entityAnimal).getIsTamed() && !entityWyvern.isOnAir()) {
                entityWyvern.setSitting(!entityWyvern.getIsSitting());
            }
            if (entityAnimal instanceof MoCEntityOstrich) {
                MoCEntityOstrich entityOstrich = (MoCEntityOstrich)entityAnimal;
                if (entityOstrich.field_70153_n != null && entityOstrich.sprintCounter == 0) {
                    entityOstrich.sprintCounter = 1;
                    world.func_72956_a((Entity)entityAnimal, "mocreatures:ostrichhurt", 1.0f, 1.2f);
                }
                if (entityOstrich.getIsTamed() && entityOstrich.field_70153_n == null) {
                    entityOstrich.setHiding(!entityOstrich.getHiding());
                }
            }
            if (entityAnimal instanceof MoCEntityElephant) {
                MoCEntityElephant entityElephant = (MoCEntityElephant)entityAnimal;
                if (entityElephant.field_70153_n != null && entityElephant.sprintCounter == 0) {
                    entityElephant.sprintCounter = 1;
                    world.func_72956_a((Entity)entityAnimal, "mocreatures:elephantgrunt", 1.0f, 1.2f);
                }
            }
        }
    }

    public static void whipFX(World world, int x, int y, int z) {
        double particleBasePositionX = (float)x + 0.5f;
        double particleBasePositionY = (float)y + 1.0f;
        double particleBasePositionZ = (float)z + 0.5f;
        double yOffset = 0.22f;
        double xzOffset = 0.27f;
        world.func_72869_a("smoke", particleBasePositionX - xzOffset, particleBasePositionY + yOffset, particleBasePositionZ, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", particleBasePositionX - xzOffset, particleBasePositionY + yOffset, particleBasePositionZ, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", particleBasePositionX + xzOffset, particleBasePositionY + yOffset, particleBasePositionZ, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", particleBasePositionX + xzOffset, particleBasePositionY + yOffset, particleBasePositionZ, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", particleBasePositionX, particleBasePositionY + yOffset, particleBasePositionZ - xzOffset, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", particleBasePositionX, particleBasePositionY + yOffset, particleBasePositionZ - xzOffset, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", particleBasePositionX, particleBasePositionY + yOffset, particleBasePositionZ + xzOffset, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", particleBasePositionX, particleBasePositionY + yOffset, particleBasePositionZ + xzOffset, 0.0, 0.0, 0.0);
        world.func_72869_a("smoke", particleBasePositionX, particleBasePositionY, particleBasePositionZ, 0.0, 0.0, 0.0);
        world.func_72869_a("flame", particleBasePositionX, particleBasePositionY, particleBasePositionZ, 0.0, 0.0, 0.0);
    }
}

