/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.animal.MoCEntityKitty;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import drzhark.mocreatures.utils.MoCLog;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MoCItemPetAmulet
extends MoCItem {
    private IIcon[] icons;
    private String name;
    private float maxHealth;
    private float health;
    private int age;
    private int creatureType;
    private String spawnClass;
    private String ownerName;
    private int amuletType;
    private boolean isAdult;
    private int petId;

    public MoCItemPetAmulet(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    public MoCItemPetAmulet(String name, int type) {
        this(name);
        this.amuletType = type;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World worldObj, EntityPlayer entityPlayer) {
        block14: {
            int amuletDurability = itemStack.func_77960_j();
            if (amuletDurability == 0) {
                return itemStack;
            }
            if (amuletDurability != 0) {
                double dist = 1.0;
                double newPosY = entityPlayer.field_70163_u;
                double newPosX = entityPlayer.field_70165_t - dist * Math.cos(MoCTools.realAngle(entityPlayer.field_70177_z - 90.0f) / 57.29578f);
                double newPosZ = entityPlayer.field_70161_v - dist * Math.sin(MoCTools.realAngle(entityPlayer.field_70177_z - 90.0f) / 57.29578f);
                ItemStack emptyAmulet = new ItemStack(MoCreatures.fishNet, 1, 0);
                if (this.amuletType == 1) {
                    emptyAmulet = new ItemStack(MoCreatures.petAmulet, 1, 0);
                }
                if (MoCreatures.isServer()) {
                    this.initAndReadNBT(itemStack);
                    if (this.spawnClass.isEmpty()) {
                        return itemStack;
                    }
                    try {
                        EntityLiving tempLiving;
                        if (this.spawnClass.equalsIgnoreCase("MoCHorse")) {
                            this.spawnClass = "Horse";
                        }
                        if ((tempLiving = MoCTools.spawnListByNameClass(this.spawnClass, worldObj)) != null && tempLiving instanceof IMoCEntity) {
                            IMoCTameable storedCreature = (IMoCTameable)tempLiving;
                            if (this.ownerName.length() > 0 && !this.ownerName.equals(entityPlayer.func_70005_c_()) && MoCreatures.instance.mapData != null) {
                                return itemStack;
                            }
                            ((EntityLiving)storedCreature).func_70107_b(newPosX, newPosY, newPosZ);
                            storedCreature.setType(this.creatureType);
                            storedCreature.setTamed(true);
                            storedCreature.setName(this.name);
                            storedCreature.setOwnerPetId(this.petId);
                            storedCreature.setOwner(entityPlayer.func_70005_c_());
                            ((EntityLiving)storedCreature).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHealth);
                            ((EntityLiving)storedCreature).func_70606_j(this.health);
                            storedCreature.setMoCAge(this.age);
                            storedCreature.setAdult(this.isAdult);
                            if (this.spawnClass.equalsIgnoreCase("Kitty")) {
                                ((MoCEntityKitty)storedCreature).setKittyState(2);
                            }
                            if (entityPlayer.field_70170_p.func_72838_d((Entity)((EntityLiving)storedCreature))) {
                                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(((EntityLiving)storedCreature).func_145782_y()), new NetworkRegistry.TargetPoint(entityPlayer.field_70170_p.field_73011_w.field_76574_g, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 64.0));
                                if (MoCreatures.proxy.enableStrictOwnership && this.ownerName.isEmpty() || this.name.isEmpty()) {
                                    MoCTools.tameWithName(entityPlayer, storedCreature);
                                }
                                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, emptyAmulet);
                                MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.getOwnerName());
                                if (petData != null) {
                                    petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!MoCreatures.proxy.debug) break block14;
                        MoCLog.logger.warn("Error spawning creature from fishnet/amulet " + ex);
                    }
                }
            }
        }
        return itemStack;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.petId = nbt.func_74762_e("PetId");
        this.creatureType = nbt.func_74762_e("CreatureType");
        this.maxHealth = nbt.func_74760_g("MaxHealth");
        this.health = nbt.func_74760_g("Health");
        this.age = nbt.func_74762_e("Age");
        this.name = nbt.func_74779_i("Name");
        this.spawnClass = nbt.func_74779_i("SpawnClass");
        this.isAdult = nbt.func_74767_n("Adult");
        this.ownerName = nbt.func_74779_i("OwnerName");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("PetID", this.petId);
        nbt.func_74768_a("CreatureType", this.creatureType);
        nbt.func_74776_a("MaxHealth", this.maxHealth);
        nbt.func_74776_a("Health", this.health);
        nbt.func_74768_a("Age", this.age);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74778_a("SpawnClass", this.spawnClass);
        nbt.func_74757_a("Adult", this.isAdult);
        nbt.func_74778_a("OwnerName", this.ownerName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[4];
        this.icons[0] = iconRegister.func_94245_a("mocreatures" + this.func_77658_a().replaceFirst("item.", ":"));
        this.icons[1] = iconRegister.func_94245_a("mocreatures" + this.func_77658_a().replaceFirst("item.", ":") + "full");
        this.icons[2] = iconRegister.func_94245_a("mocreatures" + this.func_77658_a().replaceFirst("item.", ":"));
        this.icons[3] = iconRegister.func_94245_a("mocreatures" + this.func_77658_a().replaceFirst("item.", ":") + "full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int itemDamage) {
        if (this.amuletType == 1) {
            if (itemDamage < 1) {
                return this.icons[2];
            }
            return this.icons[3];
        }
        if (itemDamage < 1) {
            return this.icons[0];
        }
        return this.icons[1];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        this.initAndReadNBT(itemStack);
        if (this.spawnClass.length() > 0) {
            par3List.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)("entity.MoCreatures." + this.spawnClass + ".name")));
        }
        if (this.name.length() > 0) {
            par3List.add(EnumChatFormatting.BLUE + this.name);
        }
        if (this.ownerName.length() > 0) {
            par3List.add(EnumChatFormatting.DARK_BLUE + new ChatComponentTranslation("amulet_and_fishnet_desc.MoCreatures.ownedBy", new Object[]{this.ownerName}).func_150261_e());
        }
    }

    private void initAndReadNBT(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = itemStack.field_77990_d;
        this.readFromNBT(nbtcompound);
    }
}

