/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.witchery_integration;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.monster.MoCEntityWerewolf;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfMinecraftComesAliveVillagerWitchery;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfVillagerWitchery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityWerewolfWitchery
extends MoCEntityMob {
    private boolean isTransforming;
    private int transformCounter;
    private int villagerProfession = 0;
    private int skinID;
    private int attackDamage;

    public MoCEntityWerewolfWitchery(World world) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a() + 3;
        this.func_70105_a(0.9f, 1.6f);
        this.isTransforming = false;
        this.transformCounter = 0;
    }

    public MoCEntityWerewolfWitchery(World world, int villagerProfession, int werewolfType) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a() + 3;
        this.func_70105_a(0.9f, 1.6f);
        this.isTransforming = false;
        this.transformCounter = 0;
        this.villagerProfession = villagerProfession;
        this.setType(werewolfType);
    }

    public MoCEntityWerewolfWitchery(World world, int werewolfType, int villagerProfession, int skinID) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a() + 3;
        this.func_70105_a(0.9f, 1.6f);
        this.isTransforming = false;
        this.transformCounter = 0;
        this.villagerProfession = villagerProfession;
        this.skinID = skinID;
        this.setType(werewolfType);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int chance = this.field_70146_Z.nextInt(100);
            if (chance <= 28) {
                this.setType(1);
            } else if (chance <= 56) {
                this.setType(2);
            } else {
                this.setType(3);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wolfblack.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wolftimber.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wolfbrown.png");
            }
        }
        return MoCreatures.proxy.getTexture("wolfbrown.png");
    }

    public boolean getIsHumanForm() {
        return false;
    }

    public void setHumanForm(boolean flag) {
    }

    public boolean getIsHunched() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setHunched(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean getIsSitting() {
        return this.field_70180_af.func_75683_a(24) == 1;
    }

    public void setSitting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(24, (Object)input);
    }

    private void setNameOfPlayerThatRecruitedThisCreature(String playerName) {
        this.field_70180_af.func_75692_b(23, (Object)playerName);
    }

    private String getNameOfPlayerThatRecruitedThisCreature() {
        return this.field_70180_af.func_75681_e(23);
    }

    protected boolean func_70780_i() {
        return this.getIsSitting();
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack itemStack;
        if (MoCreatures.isWitcheryLoaded && this.field_70789_a == null && (itemStack = entityPlayer.func_70694_bm()) == null) {
            if (MoCTools.isPlayerInWerewolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 60.0f && this.getNameOfPlayerThatRecruitedThisCreature().length() == 0) {
                this.setNameOfPlayerThatRecruitedThisCreature(entityPlayer.func_70005_c_());
                this.playRecruitmentParticleEffect(true);
                MoCTools.playCustomSound((Entity)this, "werewolfhowl", this.field_70170_p);
            }
            if (this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70093_af() && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) {
                this.setSitting(!this.getIsSitting());
            }
        }
        return false;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(15) == 0) {
            if (MoCreatures.isWitcheryLoaded && entity instanceof EntityPlayer && (MoCTools.isPlayerInWolfForm((EntityPlayer)entity) || MoCTools.isPlayerInWerewolfForm((EntityPlayer)entity))) {
                this.field_70789_a = null;
                return;
            }
            if (this.field_70122_E) {
                this.setHunched(true);
                double xDistance = entity.field_70165_t - this.field_70165_t;
                double zDistance = entity.field_70161_v - this.field_70161_v;
                float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
                this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * (double)0.8f + this.field_70159_w * 0.2000000029802322;
                this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * (double)0.8f + this.field_70179_y * 0.2000000029802322;
                this.field_70181_x = 0.4f;
            }
        } else if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attackDamage);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (damageTaken > 0.0f) {
            damageTaken = 1.0f;
            if (entityThatAttackedThisCreature != null) {
                if (entityThatAttackedThisCreature instanceof EntityPlayer) {
                    if (MoCTools.isPlayerInWerewolfForm((EntityPlayer)entityThatAttackedThisCreature) || MoCTools.isPlayerInWolfForm((EntityPlayer)entityThatAttackedThisCreature)) {
                        damageTaken = 5.0f;
                        damageSource = DamageSource.field_76377_j;
                    } else {
                        EntityPlayer entityPlayer = (EntityPlayer)entityThatAttackedThisCreature;
                        ItemStack itemStack = entityPlayer.func_71045_bC();
                        damageTaken = MoCEntityWerewolf.calculateWerewolfDamageTakenFromPlayerAttack(damageSource, damageTaken, itemStack);
                    }
                } else if (MoCreatures.isWitcheryLoaded && EntityList.func_75621_b((Entity)entityThatAttackedThisCreature).equals("witchery.witchhunter")) {
                    damageTaken = 5.0f;
                } else if (entityThatAttackedThisCreature instanceof MoCEntitySilverSkeleton) {
                    damageTaken = 9.0f;
                }
            }
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    @Override
    protected Entity func_70782_k() {
        EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 16.0);
        if (entityPlayer != null && this.func_70685_l((Entity)entityPlayer)) {
            if (MoCTools.isPlayerInWolfForm(entityPlayer) || MoCTools.isPlayerInWerewolfForm(entityPlayer) || this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) {
                EntityLivingBase entityThatAttackedMaxLevelWerewolfPlayer;
                if ((MoCTools.isPlayerInWerewolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 60.0f || MoCTools.isPlayerInWolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 32.0f || this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) && (entityThatAttackedMaxLevelWerewolfPlayer = entityPlayer.func_70643_av()) != null) {
                    return entityThatAttackedMaxLevelWerewolfPlayer;
                }
                return null;
            }
            return entityPlayer;
        }
        if (entityLiving != null && !(entityLiving instanceof EntityPlayer) && this.func_70685_l((Entity)entityLiving)) {
            return entityLiving;
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityVillager) || entity instanceof MoCEntityWerewolfVillagerWitchery || entity instanceof MoCEntityWerewolfMinecraftComesAliveVillagerWitchery;
    }

    private void followPlayer() {
        EntityPlayerMP playerToFollow = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getNameOfPlayerThatRecruitedThisCreature());
        if (playerToFollow == null) {
            return;
        }
        double distanceFromPlayerToFollow = MoCTools.getSqDistanceTo((Entity)this, playerToFollow.field_70165_t, playerToFollow.field_70163_u, playerToFollow.field_70161_v);
        if (distanceFromPlayerToFollow > 5.0) {
            this.setHunched(true);
            PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)playerToFollow, 16.0f, true, false, false, true);
            this.func_70778_a(pathEntity);
        }
    }

    public void playRecruitmentParticleEffect(boolean par1) {
        String particleName = "happyVillager";
        for (int index = 0; index < 7; ++index) {
            double xVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            double yVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            double zVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(particleName, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, xVelocity, yVelocity, zVelocity);
        }
    }

    protected String func_70673_aS() {
        return "mocreatures:werewolfdying";
    }

    protected Item func_146068_u() {
        int randomNumber = this.field_70146_Z.nextInt(12);
        switch (randomNumber) {
            case 0: {
                return Items.field_151019_K;
            }
            case 1: {
                return Items.field_151037_a;
            }
            case 2: {
                return Items.field_151036_c;
            }
            case 3: {
                return Items.field_151035_b;
            }
            case 4: {
                return Items.field_151040_l;
            }
            case 5: {
                return Items.field_151018_J;
            }
            case 6: {
                return Items.field_151051_r;
            }
            case 7: {
                return Items.field_151049_t;
            }
            case 8: {
                return Items.field_151050_s;
            }
            case 9: {
                return Items.field_151052_q;
            }
        }
        return Items.field_151153_ao;
    }

    protected String func_70621_aR() {
        return "mocreatures:werewolfhurt";
    }

    public boolean getIsUndead() {
        return true;
    }

    protected String func_70639_aQ() {
        return "mocreatures:werewolfgrunt";
    }

    public boolean IsNight() {
        return !this.field_70170_p.func_72935_r();
    }

    @Override
    public void func_70612_e(float f, float f1) {
        if (this.field_70122_E) {
            this.field_70159_w *= 1.2;
            this.field_70179_y *= 1.2;
        }
        super.func_70612_e(f, f1);
    }

    public void func_70645_a(DamageSource damageSource) {
        EntityPlayer player;
        Entity entity = damageSource.func_76346_g();
        if (this.field_70744_aE > 0 && entity != null) {
            entity.func_70084_c((Entity)this, this.field_70744_aE);
        }
        if (entity != null) {
            entity.func_70074_a((EntityLivingBase)this);
        }
        if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)damageSource.func_76346_g()) != null) {
            player.func_71064_a((StatBase)MoCAchievements.kill_werewolf, 1);
        }
        if (!this.field_70170_p.field_72995_K && this.getNameOfPlayerThatRecruitedThisCreature().length() == 0) {
            for (int index = 0; index < 2; ++index) {
                Item item = this.func_146068_u();
                if (item == null) continue;
                this.func_145779_a(item, 1);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.IsNight() && this.field_70146_Z.nextInt(250) == 0 && !this.isTransforming) {
                this.isTransforming = true;
            }
            if (this.field_70789_a != null && this.field_70789_a.field_70165_t - this.field_70165_t > 3.0 && this.field_70789_a.field_70161_v - this.field_70161_v > 3.0) {
                this.setHunched(true);
            }
            if (this.getIsHunched() && this.field_70146_Z.nextInt(50) == 0) {
                this.setHunched(false);
            }
            if (this.isTransforming && this.field_70146_Z.nextInt(3) == 0) {
                ++this.transformCounter;
                if (this.transformCounter % 2 == 0) {
                    this.field_70165_t += 0.3;
                    this.field_70163_u += (double)(this.transformCounter / 30);
                    this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.0f);
                }
                if (this.transformCounter % 2 != 0) {
                    this.field_70165_t -= 0.3;
                }
                if (this.transformCounter > 30) {
                    this.Transform();
                    this.transformCounter = 0;
                    this.isTransforming = false;
                }
            }
            if (this.field_70146_Z.nextInt(300) == 0) {
                this.field_70708_bq -= 100 * this.field_70170_p.field_73013_u.func_151525_a();
                if (this.field_70708_bq < 0) {
                    this.field_70708_bq = 0;
                }
            }
            if (!this.func_70780_i() && this.field_70789_a == null) {
                this.followPlayer();
            }
        }
    }

    private void Transform() {
        if (this.field_70725_aQ > 0) {
            return;
        }
        float healthForHumanForm = Math.round((double)(this.func_110143_aJ() / this.func_110138_aP()) * 20.0);
        this.isTransforming = false;
        if (MoCreatures.isMinecraftComesAliveLoaded && MoCreatures.proxy.useHumanModelAndMCAVillagerTexturesForWitcheryHumanWerewolfEntities) {
            MoCEntityWerewolfMinecraftComesAliveVillagerWitchery werewolfMinecraftComesAliveVillager = new MoCEntityWerewolfMinecraftComesAliveVillagerWitchery(this.field_70170_p, this.getType() - 1, this.villagerProfession, this.skinID);
            werewolfMinecraftComesAliveVillager.func_82149_j((Entity)this);
            this.func_70106_y();
            werewolfMinecraftComesAliveVillager.func_70606_j(healthForHumanForm);
            werewolfMinecraftComesAliveVillager.field_70170_p.func_72838_d((Entity)werewolfMinecraftComesAliveVillager);
        } else {
            MoCEntityWerewolfVillagerWitchery werewolfVillager = new MoCEntityWerewolfVillagerWitchery(this.field_70170_p, this.getType());
            werewolfVillager.func_82149_j((Entity)this);
            werewolfVillager.func_70938_b(this.villagerProfession);
            this.func_70106_y();
            werewolfVillager.func_70606_j(healthForHumanForm);
            werewolfVillager.field_70170_p.func_72838_d((Entity)werewolfVillager);
        }
    }

    @Override
    protected void func_70626_be() {
        if (!this.isTransforming) {
            super.func_70626_be();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setHumanForm(nbtTagCompound.func_74767_n("HumanForm"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("HumanForm", this.getIsHumanForm());
    }

    @Override
    public float getMoveSpeed() {
        if (this.getIsHunched()) {
            return 0.9f;
        }
        return 0.7f;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

