/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfMinecraftComesAliveVillagerWitchery;
import drzhark.mocreatures.entity.witchery_integration.MoCEntityWerewolfVillagerWitchery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityWerewolf
extends MoCEntityMob {
    private boolean isTransforming;
    private int transformCounter;
    private int textureCounter;
    private int attackDamage;

    public MoCEntityWerewolf(World world) {
        super(world);
        this.attackDamage = this.field_70170_p.field_73013_u.func_151525_a() + 3;
        this.func_70105_a(0.9f, 1.6f);
        this.isTransforming = false;
        this.transformCounter = 0;
        this.setHumanForm(true);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            int chance = this.field_70146_Z.nextInt(100);
            if (chance <= 28) {
                this.setType(1);
            } else if (chance <= 56) {
                this.setType(2);
            } else if (chance <= 85) {
                this.setType(3);
            } else {
                this.setType(4);
                this.field_70178_ae = true;
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.getIsHumanForm()) {
            return MoCreatures.proxy.getTexture("wereblank.png");
        }
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wolfblack.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wolfbrown.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wolftimber.png");
            }
            case 4: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getTexture("wolffire1.png");
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textureCounter;
                }
                if (this.textureCounter < 10) {
                    this.textureCounter = 10;
                }
                if (this.textureCounter > 39) {
                    this.textureCounter = 10;
                }
                String NTA = "wolffire";
                String NTB = "" + this.textureCounter;
                NTB = NTB.substring(0, 1);
                String NTC = ".png";
                return MoCreatures.proxy.getTexture(NTA + NTB + NTC);
            }
        }
        return MoCreatures.proxy.getTexture("wolfbrown.png");
    }

    protected boolean func_70780_i() {
        return this.getIsSitting();
    }

    public boolean func_70085_c(EntityPlayer entityPlayer) {
        ItemStack itemStack;
        if (MoCreatures.isWitcheryLoaded && this.field_70789_a == null && (itemStack = entityPlayer.func_70694_bm()) == null) {
            if (!this.getIsHumanForm() && MoCTools.isPlayerInWerewolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 60.0f && this.getNameOfPlayerThatRecruitedThisCreature().length() == 0) {
                this.setNameOfPlayerThatRecruitedThisCreature(entityPlayer.func_70005_c_());
                this.playRecruitmentParticleEffect(true);
                if (!this.getIsHumanForm()) {
                    MoCTools.playCustomSound((Entity)this, "werewolfhowl", this.field_70170_p);
                }
            }
            if (this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70093_af() && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) {
                this.setSitting(!this.getIsSitting());
            }
        }
        return false;
    }

    public boolean getIsHumanForm() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setHumanForm(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean getIsHunched() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setHunched(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    public boolean getIsSitting() {
        return this.field_70180_af.func_75683_a(25) == 1;
    }

    public void setSitting(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(25, (Object)input);
    }

    private void setNameOfPlayerThatRecruitedThisCreature(String playerName) {
        this.field_70180_af.func_75692_b(24, (Object)playerName);
    }

    private String getNameOfPlayerThatRecruitedThisCreature() {
        return this.field_70180_af.func_75681_e(24);
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.getIsHumanForm()) {
            this.field_70789_a = null;
            return;
        }
        if (MoCreatures.isWitcheryLoaded && entity instanceof EntityPlayer && (MoCTools.isPlayerInWolfForm((EntityPlayer)entity) || MoCTools.isPlayerInWerewolfForm((EntityPlayer)entity))) {
            this.field_70789_a = null;
            return;
        }
        if (distanceToEntity > 2.0f && distanceToEntity < 6.0f && this.field_70146_Z.nextInt(15) == 0) {
            if (this.field_70122_E) {
                this.setHunched(true);
                double xDistance = entity.field_70165_t - this.field_70165_t;
                double zDistance = entity.field_70161_v - this.field_70161_v;
                float overallHorizontalDistanceSquared = MathHelper.func_76133_a((double)(xDistance * xDistance + zDistance * zDistance));
                this.field_70159_w = xDistance / (double)overallHorizontalDistanceSquared * 0.5 * (double)0.8f + this.field_70159_w * 0.2000000029802322;
                this.field_70179_y = zDistance / (double)overallHorizontalDistanceSquared * 0.5 * (double)0.8f + this.field_70179_y * 0.2000000029802322;
                this.field_70181_x = 0.4f;
            }
        } else if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.attackDamage);
            if (this.getType() == 4) {
                ((EntityLivingBase)entity).func_70015_d(10);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
        if (!this.getIsHumanForm() && damageTaken > 0.0f) {
            damageTaken = 1.0f;
            if (entityThatAttackedThisCreature != null) {
                if (entityThatAttackedThisCreature instanceof EntityPlayer) {
                    if (MoCTools.isPlayerInWerewolfForm((EntityPlayer)entityThatAttackedThisCreature) || MoCTools.isPlayerInWolfForm((EntityPlayer)entityThatAttackedThisCreature)) {
                        damageTaken = 5.0f;
                        damageSource = DamageSource.field_76377_j;
                    } else {
                        EntityPlayer entityPlayer = (EntityPlayer)entityThatAttackedThisCreature;
                        ItemStack itemStack = entityPlayer.func_71045_bC();
                        damageTaken = MoCEntityWerewolf.calculateWerewolfDamageTakenFromPlayerAttack(damageSource, damageTaken, itemStack);
                    }
                } else if (entityThatAttackedThisCreature instanceof MoCEntitySilverSkeleton) {
                    damageTaken = 9.0f;
                }
            }
        }
        if (entityThatAttackedThisCreature != null && !(entityThatAttackedThisCreature instanceof EntityPlayer) && MoCreatures.isWitcheryLoaded && EntityList.func_75621_b((Entity)entityThatAttackedThisCreature).equals("witchery.witchhunter")) {
            damageTaken = 5.0f;
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public static float calculateWerewolfDamageTakenFromPlayerAttack(DamageSource damageSource, float damageTaken, ItemStack itemStack) {
        if (itemStack != null) {
            damageTaken = 1.0f;
            Item itemHeldByPlayer = itemStack.func_77973_b();
            if (damageSource.func_76352_a()) {
                if (MoCreatures.isWitcheryLoaded && damageSource.func_76346_g() instanceof EntityPlayer && !(itemHeldByPlayer instanceof ItemFishingRod) && EntityList.func_75621_b((Entity)damageSource.func_76364_f()).equals("witchery.bolt")) {
                    EntityPlayer playerThatShotThisWerewolf = (EntityPlayer)damageSource.func_76346_g();
                    damageTaken = MoCEntityWerewolf.doesPlayerHaveSilverBoltsAndNoOtherTypesOfBoltsInTheirInventory(playerThatShotThisWerewolf) ? 5.0f : 1.0f;
                }
                damageTaken = MoCreatures.isBalkansWeaponsModLoaded && Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:flail.gold") ? 8.0f : (damageSource.func_76364_f() instanceof EntityArrow ? 1.0f : 0.0f);
            }
            if (itemHeldByPlayer == Items.field_151011_C || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.shovelSilver")) {
                damageTaken = 3.0f;
            } else if (itemHeldByPlayer == Items.field_151013_M || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("BiomesOPlenty:scytheGold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("battlegear2:dagger.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("battlegear2:waraxe.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.sickleGold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.hoeSilver") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.sickleSilver") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.shovelElectrum") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:knife.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:musketbayonet.gold")) {
                damageTaken = 6.0f;
            } else if (itemHeldByPlayer == Items.field_151005_D || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.pickaxeSilver") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.hoeElectrum") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.sickleElectrum")) {
                damageTaken = 7.0f;
            } else if (itemHeldByPlayer == Items.field_151006_E || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("battlegear2:mace.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("battlegear2:spear.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.pickaxeElectrum") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:spear.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:halberd.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:battleaxe.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:warhammer.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.axeSilver")) {
                damageTaken = 8.0f;
            } else if (itemHeldByPlayer == Items.field_151010_B || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.axeElectrum") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("weaponmod:katana.gold") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("witchery:silversword") || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.swordSilver")) {
                damageTaken = 9.0f;
            } else if (itemHeldByPlayer == MoCreatures.silverSword || Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).equals("ThermalFoundation:tool.swordElectrum")) {
                damageTaken = 10.0f;
            } else if (damageTaken == 1.0f && itemHeldByPlayer instanceof ItemSword) {
                if (Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).contains("gold")) {
                    damageTaken = (float)((double)((ItemSword)itemHeldByPlayer).func_150931_i() * 1.1) * 2.0f;
                }
                if (Item.field_150901_e.func_148750_c((Object)itemHeldByPlayer).contains("silver")) {
                    damageTaken = (float)((double)((ItemSword)itemHeldByPlayer).func_150931_i() * 1.3) * 2.0f;
                }
            }
        }
        return damageTaken;
    }

    public static boolean doesPlayerHaveSilverBoltsAndNoOtherTypesOfBoltsInTheirInventory(EntityPlayer player) {
        ItemStack[] inventoryOfPlayerThatShotThisWerewolf = player.field_71071_by.field_70462_a;
        boolean doesPlayerHaveSilverBoltsInInventory = false;
        boolean doesPlayerHaveOtherTypesOfBoltsInInventory = false;
        int iterationLength = inventoryOfPlayerThatShotThisWerewolf.length;
        if (iterationLength > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Item itemInInventorySlot;
                String stringNameForItemInInventorySlot;
                ItemStack itemstackInInventorySlot = inventoryOfPlayerThatShotThisWerewolf[index];
                if (itemstackInInventorySlot == null || !(stringNameForItemInInventorySlot = Item.field_150901_e.func_148750_c((Object)(itemInInventorySlot = itemstackInInventorySlot.func_77973_b()))).equals("witchery:ingredient")) continue;
                if (itemstackInInventorySlot.func_77960_j() == 155) {
                    doesPlayerHaveSilverBoltsInInventory = true;
                }
                if (itemstackInInventorySlot.func_77960_j() != 132 && itemstackInInventorySlot.func_77960_j() != 133 && itemstackInInventorySlot.func_77960_j() != 134 && itemstackInInventorySlot.func_77960_j() != 135) continue;
                doesPlayerHaveOtherTypesOfBoltsInInventory = true;
            }
        }
        return doesPlayerHaveSilverBoltsInInventory && !doesPlayerHaveOtherTypesOfBoltsInInventory;
    }

    @Override
    protected Entity func_70782_k() {
        if (this.getIsHumanForm()) {
            return null;
        }
        EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 16.0);
        if (entityPlayer != null && this.func_70685_l((Entity)entityPlayer)) {
            if (MoCTools.isPlayerInWolfForm(entityPlayer) || MoCTools.isPlayerInWerewolfForm(entityPlayer) || this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) {
                EntityLivingBase entityThatAttackedMaxLevelWerewolfPlayer;
                if ((MoCTools.isPlayerInWerewolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 60.0f || MoCTools.isPlayerInWolfForm(entityPlayer) && entityPlayer.func_110138_aP() == 32.0f || this.getNameOfPlayerThatRecruitedThisCreature().length() > 0 && entityPlayer.func_70005_c_() == this.getNameOfPlayerThatRecruitedThisCreature()) && (entityThatAttackedMaxLevelWerewolfPlayer = entityPlayer.func_70643_av()) != null) {
                    return entityThatAttackedMaxLevelWerewolfPlayer;
                }
                return null;
            }
            return entityPlayer;
        }
        if (entityLiving != null && !(entityLiving instanceof EntityPlayer) && this.func_70685_l((Entity)entityLiving)) {
            return entityLiving;
        }
        return null;
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityVillager) || entity instanceof MoCEntityWerewolfVillagerWitchery || entity instanceof MoCEntityWerewolfMinecraftComesAliveVillagerWitchery;
    }

    protected Item func_146068_u() {
        int randomNumber = this.field_70146_Z.nextInt(12);
        if (this.getIsHumanForm()) {
            switch (randomNumber) {
                case 0: {
                    return Items.field_151038_n;
                }
                case 1: {
                    return Items.field_151053_p;
                }
                case 2: {
                    return Items.field_151041_m;
                }
                case 3: {
                    return Items.field_151017_I;
                }
                case 4: {
                    return Items.field_151039_o;
                }
            }
            return Items.field_151055_y;
        }
        switch (randomNumber) {
            case 0: {
                return Items.field_151019_K;
            }
            case 1: {
                return Items.field_151037_a;
            }
            case 2: {
                return Items.field_151036_c;
            }
            case 3: {
                return Items.field_151035_b;
            }
            case 4: {
                return Items.field_151040_l;
            }
            case 5: {
                return Items.field_151018_J;
            }
            case 6: {
                return Items.field_151051_r;
            }
            case 7: {
                return Items.field_151049_t;
            }
            case 8: {
                return Items.field_151050_s;
            }
            case 9: {
                return Items.field_151052_q;
            }
        }
        return Items.field_151153_ao;
    }

    private void followPlayer() {
        EntityPlayerMP playerToFollow = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getNameOfPlayerThatRecruitedThisCreature());
        if (playerToFollow == null) {
            return;
        }
        double distanceFromPlayerToFollow = MoCTools.getSqDistanceTo((Entity)this, playerToFollow.field_70165_t, playerToFollow.field_70163_u, playerToFollow.field_70161_v);
        if (distanceFromPlayerToFollow > 5.0) {
            this.setHunched(true);
            PathEntity pathEntity = this.field_70170_p.func_72865_a((Entity)this, (Entity)playerToFollow, 16.0f, true, false, false, true);
            this.func_70778_a(pathEntity);
        }
    }

    public void playRecruitmentParticleEffect(boolean par1) {
        String particleName = "happyVillager";
        for (int index = 0; index < 7; ++index) {
            double xVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            double yVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            double zVelocity = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(particleName, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, xVelocity, yVelocity, zVelocity);
        }
    }

    protected String func_70621_aR() {
        if (this.getIsHumanForm()) {
            if (MoCreatures.proxy.useRealisticHumanSoundsForWerewolf) {
                return "mocreatures:werehumanhurt";
            }
            return "game.neutral.hurt";
        }
        return "mocreatures:werewolfhurt";
    }

    protected String func_70639_aQ() {
        if (this.getIsHumanForm()) {
            return null;
        }
        return "mocreatures:werewolfgrunt";
    }

    protected String func_70673_aS() {
        if (this.getIsHumanForm()) {
            if (MoCreatures.proxy.useRealisticHumanSoundsForWerewolf) {
                return "mocreatures:werehumandying";
            }
            return "game.neutral.die";
        }
        return "mocreatures:werewolfdying";
    }

    public boolean getIsUndead() {
        return true;
    }

    public boolean IsNight() {
        return !this.field_70170_p.func_72935_r();
    }

    @Override
    public void func_70612_e(float f, float f1) {
        if (!this.getIsHumanForm() && this.field_70122_E) {
            this.field_70159_w *= 1.2;
            this.field_70179_y *= 1.2;
        }
        super.func_70612_e(f, f1);
    }

    public void func_70645_a(DamageSource damageSource) {
        EntityPlayer player;
        Entity entity = damageSource.func_76346_g();
        if (this.field_70744_aE > 0 && entity != null) {
            entity.func_70084_c((Entity)this, this.field_70744_aE);
        }
        if (entity != null) {
            entity.func_70074_a((EntityLivingBase)this);
        }
        if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer && !this.getIsHumanForm() && (player = (EntityPlayer)damageSource.func_76346_g()) != null) {
            player.func_71064_a((StatBase)MoCAchievements.kill_werewolf, 1);
        }
        if (!this.field_70170_p.field_72995_K && this.getNameOfPlayerThatRecruitedThisCreature().length() == 0) {
            for (int index = 0; index < 2; ++index) {
                Item item = this.func_146068_u();
                if (item == null) continue;
                this.func_145779_a(item, 1);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getType() == 4 && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if ((this.IsNight() && this.getIsHumanForm() || !this.IsNight() && !this.getIsHumanForm()) && this.field_70146_Z.nextInt(250) == 0) {
                this.isTransforming = true;
            }
            if (this.getIsHumanForm() && this.field_70789_a != null) {
                this.field_70789_a = null;
            }
            if (this.field_70789_a != null && !this.getIsHumanForm() && this.field_70789_a.field_70165_t - this.field_70165_t > 3.0 && this.field_70789_a.field_70161_v - this.field_70161_v > 3.0) {
                this.setHunched(true);
            }
            if (this.getIsHunched() && this.field_70146_Z.nextInt(50) == 0) {
                this.setHunched(false);
            }
            if (this.isTransforming && this.field_70146_Z.nextInt(3) == 0) {
                ++this.transformCounter;
                if (this.transformCounter % 2 == 0) {
                    this.field_70165_t += 0.3;
                    this.field_70163_u += (double)(this.transformCounter / 30);
                    this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.0f);
                }
                if (this.transformCounter % 2 != 0) {
                    this.field_70165_t -= 0.3;
                }
                if (MoCreatures.proxy.useRealisticHumanSoundsForWerewolf && this.transformCounter == 10) {
                    this.func_85030_a("mocreatures:weretransform", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                if (this.transformCounter > 30) {
                    this.transform();
                    this.transformCounter = 0;
                    this.isTransforming = false;
                }
            }
            if (this.field_70146_Z.nextInt(300) == 0) {
                this.field_70708_bq -= 100 * this.field_70170_p.field_73013_u.func_151525_a();
                if (this.field_70708_bq < 0) {
                    this.field_70708_bq = 0;
                }
            }
            if (!this.func_70780_i() && this.field_70789_a == null) {
                this.followPlayer();
            }
        }
    }

    private void transform() {
        if (this.field_70725_aQ > 0) {
            return;
        }
        if (this.getIsHumanForm()) {
            this.setHumanForm(false);
            if (this.func_110138_aP() != 40.0f) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            }
            this.func_70606_j(this.func_110138_aP());
            this.isTransforming = false;
            MoCTools.playCustomSound((Entity)this, "werewolfhowl", this.field_70170_p);
        } else {
            this.setHumanForm(true);
            this.setNameOfPlayerThatRecruitedThisCreature("");
            this.setSitting(false);
            float healthForHumanForm = Math.round((double)(this.func_110143_aJ() / this.func_110138_aP()) * 16.0);
            if (this.func_110138_aP() != 16.0f) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
            }
            this.func_70606_j(healthForHumanForm);
            this.isTransforming = false;
        }
    }

    @Override
    protected void func_70626_be() {
        if (!this.isTransforming) {
            super.func_70626_be();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setHumanForm(nbtTagCompound.func_74767_n("HumanForm"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("HumanForm", this.getIsHumanForm());
    }

    @Override
    public float getMoveSpeed() {
        if (this.getIsHunched()) {
            return 0.9f;
        }
        return 0.7f;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

