/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageExplode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityOgre
extends MoCEntityMob {
    public int attackFrequency;
    public int attackCounterLeftArm;
    public int attackCounterRightArm;
    private int movingHead;
    public boolean isPendingSmashAttack;

    public MoCEntityOgre(World world) {
        super(world);
        this.func_70105_a(1.9f, 3.0f);
        this.attackFrequency = 30;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getType() > 4 ? 50.0 : 35.0);
    }

    @Override
    protected double getAttackStrength() {
        return 3.0;
    }

    @Override
    public void selectType() {
        if (this.field_70170_p.field_73011_w.field_76575_d) {
            this.setType(this.field_70146_Z.nextInt(2) + 3);
            this.func_70606_j(this.func_110138_aP());
            this.field_70178_ae = true;
        } else if (this.getType() == 0) {
            short fireOgreChance = MoCreatures.proxy.fireOgreChance;
            short caveOgreChance = MoCreatures.proxy.caveOgreChance;
            int typeChance = this.field_70146_Z.nextInt(100);
            if (this.canCaveOgreSpawn() && typeChance >= 100 - caveOgreChance) {
                this.setType(this.field_70146_Z.nextInt(2) + 5);
            } else if (typeChance >= 100 - fireOgreChance) {
                this.setType(this.field_70146_Z.nextInt(2) + 3);
                this.field_70178_ae = true;
            } else {
                this.setType(this.field_70146_Z.nextInt(2) + 1);
            }
            this.func_70606_j(this.func_110138_aP());
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: 
            case 2: {
                return MoCreatures.proxy.getTexture("ogregreen.png");
            }
            case 3: 
            case 4: {
                return MoCreatures.proxy.getTexture("ogrered.png");
            }
            case 5: 
            case 6: {
                return MoCreatures.proxy.getTexture("ogreblue.png");
            }
        }
        return MoCreatures.proxy.getTexture("ogregreen.png");
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && distanceToEntity < 2.5f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            this.field_70724_aR = 20;
            this.func_70652_k(entity);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    public void destroyBlocksNearby() {
        if (this.field_70725_aQ > 0) {
            return;
        }
        MoCTools.destroyBlast((Entity)this, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, this.getDestroyForce(), this.isFireOgre());
    }

    @Override
    protected Entity func_70782_k() {
        EntityPlayer closestEntityPlayer;
        float brightness = this.func_70013_c(1.0f);
        if (brightness < 0.5f && (closestEntityPlayer = this.field_70170_p.func_72856_b((Entity)this, (double)this.getAttackRange())) != null && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            return closestEntityPlayer;
        }
        return null;
    }

    protected String func_70673_aS() {
        return "mocreatures:ogredying";
    }

    protected Item func_146068_u() {
        if (this.getType() < 3) {
            return Item.func_150898_a((Block)Blocks.field_150343_Z);
        }
        if (this.isFireOgre()) {
            boolean shouldDroupRareItem;
            boolean bl = shouldDroupRareItem = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
            if (!shouldDroupRareItem) {
                return Item.func_150898_a((Block)Blocks.field_150480_ab);
            }
            return Items.field_151043_k;
        }
        return Items.field_151045_i;
    }

    protected String func_70621_aR() {
        return "mocreatures:ogrehurt";
    }

    protected String func_70639_aQ() {
        return "mocreatures:ogre";
    }

    public boolean isFireOgre() {
        return this.getType() == 3 || this.getType() == 4;
    }

    public float getDestroyForce() {
        int type = this.getType();
        if (type < 3) {
            return MoCreatures.proxy.ogreStrength;
        }
        if (type < 5) {
            return MoCreatures.proxy.fireOgreStrength;
        }
        return MoCreatures.proxy.caveOgreStrength;
    }

    public int getAttackRange() {
        return MoCreatures.proxy.ogreAttackRange;
    }

    @Override
    public void func_70636_d() {
        if (this.isFireOgre() && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
        if (MoCreatures.isServer()) {
            float brightness;
            if (this.field_70789_a != null && this.field_70146_Z.nextInt(this.attackFrequency) == 0 && this.field_70724_aR == 0 && this.attackCounterLeftArm == 0 && this.attackCounterRightArm == 0) {
                this.startOgreAttack();
            }
            if (this.field_70724_aR <= 0 && this.isPendingSmashAttack) {
                this.isPendingSmashAttack = false;
                this.destroyBlocksNearby();
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageExplode(this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
            if (!this.isFireOgre() && this.field_70170_p.func_72935_r() && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 5.0f);
            }
        }
        if (this.attackCounterLeftArm > 0 && ++this.attackCounterLeftArm > 30) {
            this.attackCounterLeftArm = 0;
        }
        if (this.attackCounterRightArm > 0 && ++this.attackCounterRightArm > 30) {
            this.attackCounterRightArm = 0;
        }
        super.func_70636_d();
    }

    private void startOgreAttack() {
        if (MoCreatures.isServer()) {
            boolean leftArmW;
            this.field_70724_aR = 15;
            this.isPendingSmashAttack = true;
            boolean bl = leftArmW = (this.getType() == 2 || this.getType() == 4 || this.getType() == 6) && this.field_70146_Z.nextInt(2) == 0;
            if (leftArmW) {
                this.attackCounterLeftArm = 1;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            } else {
                this.attackCounterRightArm = 1;
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.attackCounterLeftArm = 1;
        }
        if (animationType == 2) {
            this.attackCounterRightArm = 1;
        }
    }

    public void func_70645_a(DamageSource damageSource) {
        EntityPlayer player;
        if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof EntityPlayer && (player = (EntityPlayer)damageSource.func_76346_g()) != null) {
            player.func_71064_a((StatBase)MoCAchievements.kill_ogre, 1);
        }
        super.func_70645_a(damageSource);
    }

    public int getMovingHead() {
        if (this.getType() == 1 || this.getType() == 3 || this.getType() == 5) {
            return 1;
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.movingHead = this.field_70146_Z.nextInt(2) + 2;
        }
        return this.movingHead;
    }

    private boolean canCaveOgreSpawn() {
        return !this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70163_u < 50.0;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

