/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.item.MoCEntityThrowableBlockForGolem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MoCEntityMiniGolem
extends MoCEntityMob {
    public int throwCounter;
    public MoCEntityThrowableBlockForGolem tempBlock;

    public MoCEntityMiniGolem(World world) {
        super(world);
        this.texture = "minigolem.png";
        this.func_70105_a(1.0f, 1.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public boolean getIsAngry() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    public void setIsAngry(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(22, (Object)input);
    }

    public boolean getHasBlock() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setHasBlock(boolean flag) {
        byte input = (byte)(flag ? 1 : 0);
        this.field_70180_af.func_75692_b(23, (Object)input);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            float brightness;
            if (this.field_70789_a == null) {
                if (this.getIsAngry()) {
                    this.setIsAngry(false);
                }
            } else if (!this.getIsAngry()) {
                this.setIsAngry(true);
            }
            if (this.field_70170_p.func_72935_r() && (brightness = this.func_70013_c(1.0f)) > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f) {
                this.func_70015_d(8);
            }
            if (this.getIsAngry() && this.field_70789_a != null) {
                if (!this.getHasBlock() && this.field_70146_Z.nextInt(30) == 0) {
                    this.acquireTileBlock();
                }
                if (this.getHasBlock()) {
                    this.attackWithEntityBlock();
                }
            }
        }
    }

    protected void acquireTileBlock() {
        int[] tileBlockInfo = MoCTools.destroyRandomBlockWithMetadata((Entity)this, 3.0);
        if (tileBlockInfo[0] == -1 || tileBlockInfo[0] == 0 || tileBlockInfo[0] == 7 || tileBlockInfo[0] == 8 || tileBlockInfo[0] == 9 || tileBlockInfo[0] == 10 || tileBlockInfo[0] == 11) {
            this.throwCounter = 1;
            this.setHasBlock(false);
            return;
        }
        MoCEntityThrowableBlockForGolem entityBlock = new MoCEntityThrowableBlockForGolem(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)entityBlock);
        entityBlock.setType(tileBlockInfo[0]);
        entityBlock.setMetadata(tileBlockInfo[1]);
        entityBlock.setBehavior(1);
        this.tempBlock = entityBlock;
        this.setHasBlock(true);
    }

    protected boolean func_70780_i() {
        return this.getHasBlock() && this.field_70789_a != null;
    }

    protected void attackWithEntityBlock() {
        ++this.throwCounter;
        if (this.throwCounter < 50) {
            this.tempBlock.field_70165_t = this.field_70165_t;
            this.tempBlock.field_70163_u = this.field_70163_u + 1.0;
            this.tempBlock.field_70161_v = this.field_70161_v;
        }
        if (this.throwCounter >= 50) {
            if (this.field_70789_a != null && this.func_70032_d(this.field_70789_a) < 48.0f) {
                this.throwBlockAtEntity(this.field_70789_a, this.tempBlock.getType(), this.tempBlock.getMetadata());
            }
            this.tempBlock.func_70106_y();
            this.setHasBlock(false);
            this.throwCounter = 0;
        }
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.0 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
    }

    @Override
    protected Entity func_70782_k() {
        EntityPlayer closestEntityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return closestEntityPlayer != null && this.func_70685_l((Entity)closestEntityPlayer) ? closestEntityPlayer : null;
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    protected void throwBlockAtEntity(Entity targetEntity, int blockType, int metadata) {
        this.throwBlockAtCoordinates((int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v, blockType, metadata);
    }

    protected void throwBlockAtCoordinates(int X, int Y, int Z, int blockType, int metadata) {
        MoCEntityThrowableBlockForGolem entityBlock = new MoCEntityThrowableBlockForGolem(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)entityBlock);
        entityBlock.setType(blockType);
        entityBlock.setMetadata(metadata);
        entityBlock.setBehavior(0);
        entityBlock.field_70159_w = ((double)X - this.field_70165_t) / 20.0;
        entityBlock.field_70181_x = ((double)Y - this.field_70163_u) / 20.0 + 0.5;
        entityBlock.field_70179_y = ((double)Z - this.field_70161_v) / 20.0;
    }

    protected String func_70673_aS() {
        return "mocreatures:golemgrunt";
    }

    protected String func_70621_aR() {
        return "mocreatures:golemgrunt";
    }

    protected String func_70639_aQ() {
        return null;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

