/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityHorseMob
extends MoCEntityMob {
    public int mouthCounter;
    public int textureCounter;
    public int standCounter;
    public int tailCounter;
    public int eatingCounter;
    private int transparencyCounter;
    private float trasparency = 0.2f;
    public int wingFlapCounter;

    public MoCEntityHorseMob(World world) {
        super(world);
        this.func_70105_a(1.4f, 1.6f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public boolean func_70067_L() {
        return !(this.field_70153_n instanceof EntitySkeleton);
    }

    @Override
    public void selectType() {
        if (this.field_70170_p.field_73011_w.field_76575_d) {
            this.setType(38);
            this.field_70178_ae = true;
        } else if (this.getType() == 0) {
            int typeSelector = this.field_70146_Z.nextInt(100);
            if (typeSelector <= 40) {
                this.setType(23);
            } else if (typeSelector <= 80) {
                this.setType(26);
            } else {
                this.setType(32);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 23: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getTexture("horseundead.png");
                }
                String baseTex = "horseundead";
                int max = 79;
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textureCounter;
                }
                if (this.textureCounter < 10) {
                    this.textureCounter = 10;
                }
                if (this.textureCounter > max) {
                    this.textureCounter = 10;
                }
                String iteratorTexture = "" + this.textureCounter;
                iteratorTexture = iteratorTexture.substring(0, 1);
                String decayTexture = "" + this.getMoCAge() / 100;
                decayTexture = decayTexture.substring(0, 1);
                return MoCreatures.proxy.getTexture(baseTex + decayTexture + iteratorTexture + ".png");
            }
            case 26: {
                return MoCreatures.proxy.getTexture("horseskeleton.png");
            }
            case 32: {
                return MoCreatures.proxy.getTexture("horsebat.png");
            }
            case 38: {
                if (!MoCreatures.proxy.getAnimateTextures()) {
                    return MoCreatures.proxy.getTexture("horsenightmare1.png");
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    ++this.textureCounter;
                }
                if (this.textureCounter < 10) {
                    this.textureCounter = 10;
                }
                if (this.textureCounter > 59) {
                    this.textureCounter = 10;
                }
                String textureNamePartA = "horsenightmare";
                String textureNamePartB = "" + this.textureCounter;
                textureNamePartB = textureNamePartB.substring(0, 1);
                String textureNamePartC = ".png";
                return MoCreatures.proxy.getTexture(textureNamePartA + textureNamePartB + textureNamePartC);
            }
        }
        return MoCreatures.proxy.getTexture("horseundead.png");
    }

    protected String func_70673_aS() {
        this.openMouth();
        return "mocreatures:horsedyingundead";
    }

    protected String func_70621_aR() {
        this.openMouth();
        this.stand();
        return "mocreatures:horsehurtundead";
    }

    protected String func_70639_aQ() {
        this.openMouth();
        if (this.field_70146_Z.nextInt(10) == 0) {
            this.stand();
        }
        return "mocreatures:horsegruntundead";
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_147437_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getType() == 38 && !this.field_70178_ae) {
            this.field_70178_ae = true;
        }
        if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
            this.mouthCounter = 0;
        }
        if (this.standCounter > 0 && ++this.standCounter > 20) {
            this.standCounter = 0;
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.eatingCounter > 0 && ++this.eatingCounter > 50) {
            this.eatingCounter = 0;
        }
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
    }

    public float transparency() {
        if (++this.transparencyCounter > 60) {
            this.transparencyCounter = 0;
            this.trasparency = this.field_70146_Z.nextFloat() * 0.3f + 0.3f;
        }
        return this.trasparency;
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 16 || this.getType() == 40 || this.getType() == 34 || this.getType() == 36 || this.getType() == 32 || this.getType() == 21 || this.getType() == 25;
    }

    public boolean isUnicorned() {
        return this.getType() == 18 || this.getType() == 34 || this.getType() == 36 || this.getType() == 40 || this.getType() == 24;
    }

    public boolean isGhost() {
        return this.getType() == 21 || this.getType() == 22;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isOnAir() && this.isFlyer() && this.field_70146_Z.nextInt(5) == 0) {
            this.wingFlapCounter = 1;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        if (!this.isOnAir() && this.field_70153_n == null && this.field_70146_Z.nextInt(250) == 0) {
            this.stand();
        }
        if (this.getType() == 38 && this.field_70146_Z.nextInt(50) == 0 && !MoCreatures.isServer()) {
            this.LavaFX();
        }
        if (this.getType() == 23 && this.field_70146_Z.nextInt(50) == 0 && !MoCreatures.isServer()) {
            this.UndeadFX();
        }
        if (!this.field_70170_p.field_72995_K && this.isFlyer() && this.func_70777_m() != null) {
            double xDistance = this.func_70777_m().field_70165_t - this.field_70165_t;
            double yDistance = this.func_70777_m().field_70163_u - this.field_70163_u;
            double zDistance = this.func_70777_m().field_70161_v - this.field_70161_v;
            double overallDistanceSquared = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
            double flySpeed = this.getMoveSpeed();
            if (yDistance != 0.0) {
                this.field_70181_x += yDistance / overallDistanceSquared * 0.3;
            }
            if (this.isOnAir() && overallDistanceSquared > 3.0) {
                this.func_70625_a(this.func_70777_m(), 10.0f, 10.0f);
                this.field_70159_w = xDistance / overallDistanceSquared * flySpeed;
                this.field_70179_y = zDistance / overallDistanceSquared * flySpeed;
            }
        }
        if (MoCreatures.isServer()) {
            if (this.isFlyer() && this.field_70146_Z.nextInt(500) == 0) {
                this.wingFlap();
            }
            if (this.field_70170_p.func_72935_r()) {
                float brightness = this.func_70013_c(1.0f);
                if (this.getType() != 38 && brightness > 0.5f && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70146_Z.nextFloat() * 30.0f < (brightness - 0.4f) * 2.0f) {
                    this.func_70015_d(8);
                }
            }
            if (!this.isOnAir() && this.field_70153_n == null && this.field_70146_Z.nextInt(300) == 0) {
                this.setEating();
            }
            if (this.field_70153_n == null) {
                List listOfEntitiesNearby = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.0, 3.0, 4.0));
                for (int index = 0; index < listOfEntitiesNearby.size(); ++index) {
                    Entity entityNearby = (Entity)listOfEntitiesNearby.get(index);
                    if (!(entityNearby instanceof EntityMob)) continue;
                    EntityMob entityMobNearby = (EntityMob)entityNearby;
                    if (entityMobNearby.field_70154_o != null || !(entityMobNearby instanceof EntitySkeleton) && !(entityMobNearby instanceof EntityZombie)) continue;
                    entityMobNearby.func_70078_a((Entity)this);
                    break;
                }
            }
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    private void setEating() {
        this.eatingCounter = 1;
    }

    private void stand() {
        this.standCounter = 1;
    }

    public void wingFlap() {
        this.wingFlapCounter = 1;
    }

    protected Item func_146068_u() {
        boolean shouldDropRareItem;
        boolean bl = shouldDropRareItem = this.field_70146_Z.nextInt(100) < MoCreatures.proxy.rareItemDropChance;
        if (this.getType() == 32 && MoCreatures.proxy.rareItemDropChance < 25) {
            boolean bl2 = shouldDropRareItem = this.field_70146_Z.nextInt(100) < 25;
        }
        if (shouldDropRareItem && (this.getType() == 36 || this.getType() >= 50 && this.getType() < 60)) {
            return MoCreatures.unicornHorn;
        }
        if (this.getType() == 39) {
            return Items.field_151008_G;
        }
        if (this.getType() == 40) {
            return Items.field_151008_G;
        }
        if (this.getType() == 38 && shouldDropRareItem && this.field_70170_p.field_73011_w.field_76575_d) {
            return MoCreatures.heartFire;
        }
        if (this.getType() == 32 && shouldDropRareItem) {
            return MoCreatures.heartDarkness;
        }
        if (this.getType() == 26) {
            return Items.field_151103_aS;
        }
        if (this.getType() == 23 || this.getType() == 24 || this.getType() == 25) {
            if (shouldDropRareItem) {
                return MoCreatures.heartundead;
            }
            return Items.field_151078_bh;
        }
        if (this.getType() == 21 || this.getType() == 22) {
            return Items.field_151073_bk;
        }
        return Items.field_151116_aA;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (this.field_70724_aR <= 0 && distanceToEntity < 2.5f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.stand();
            this.openMouth();
            MoCTools.playCustomSound((Entity)this, "horsemad", this.field_70170_p);
            this.func_70652_k(entity);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (MoCreatures.isServer()) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n != null && entityThatAttackedThisCreature == this.field_70153_n) {
                return false;
            }
        }
        return super.func_70097_a(damageSource, damageTaken);
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.5;
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n == null) {
            return;
        }
        ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70177_z;
        ((EntityLivingBase)this.field_70153_n).field_70760_ar = this.field_70177_z;
    }

    @Override
    public boolean func_70601_bi() {
        if (this.field_70163_u < 50.0 && !this.field_70170_p.field_73011_w.field_76575_d) {
            this.setType(32);
        }
        return super.func_70601_bi();
    }

    public void UndeadFX() {
        MoCreatures.proxy.UndeadFX((Entity)this);
    }

    public void LavaFX() {
        MoCreatures.proxy.LavaFX((Entity)this);
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getType() == 23) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

