/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.monster;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.achievements.MoCAchievements;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.item.MoCEntityThrowableBlockForGolem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageTwoBytes;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;

public class MoCEntityBigGolem
extends MoCEntityMob
implements IEntityAdditionalSpawnData {
    public int throwBlockCounter;
    public MoCEntityThrowableBlockForGolem tempBlock;
    private byte[] golemCubes;
    private int hurtCounter = 0;
    private int smokeCounter;

    public MoCEntityBigGolem(World world) {
        super(world);
        this.texture = "golemt.png";
        this.func_70105_a(1.5f, 4.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public void writeSpawnData(ByteBuf data) {
        for (int index = 0; index < 23; ++index) {
            data.writeByte((int)this.golemCubes[index]);
        }
    }

    public void readSpawnData(ByteBuf data) {
        for (int index = 0; index < 23; ++index) {
            this.golemCubes[index] = data.readByte();
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.initGolemCubes();
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public int getGolemState() {
        return this.field_70180_af.func_75683_a(23);
    }

    public void setGolemState(int b) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)b));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (MoCreatures.isServer()) {
            EntityPlayer entityPlayer1;
            if (this.getGolemState() == 0 && (entityPlayer1 = this.field_70170_p.func_72890_a((Entity)this, 8.0)) != null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() == 1 && !this.isMissingCubes()) {
                this.setGolemState(2);
            }
            if (this.getGolemState() > 2 && this.getGolemState() != 4 && this.field_70789_a == null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() > 1 && this.field_70789_a != null && this.field_70146_Z.nextInt(20) == 0) {
                if (this.func_110143_aJ() >= 30.0f) {
                    this.setGolemState(2);
                }
                if (this.func_110143_aJ() < 30.0f && this.func_110143_aJ() >= 10.0f) {
                    this.setGolemState(3);
                }
                if (this.func_110143_aJ() < 10.0f) {
                    this.setGolemState(4);
                }
            }
            if (this.getGolemState() != 0 && this.getGolemState() != 4 && this.isMissingCubes()) {
                int freq = 21 - this.getGolemState() * this.field_70170_p.field_73013_u.func_151525_a();
                if (this.getGolemState() == 1) {
                    freq = 10;
                }
                if (this.field_70146_Z.nextInt(freq) == 0) {
                    this.acquireBlock(2);
                }
            }
            if (this.getGolemState() == 4) {
                this.func_70778_a(null);
                ++this.hurtCounter;
                if (this.hurtCounter < 80 && this.field_70146_Z.nextInt(3) == 0) {
                    this.acquireBlock(4);
                }
                if (this.hurtCounter == 120) {
                    MoCTools.playCustomSound((Entity)this, "golemdying", this.field_70170_p, 3.0f);
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
                }
                if (this.hurtCounter > 140) {
                    MoCTools.playCustomSound((Entity)this, "golemexplode", this.field_70170_p, 3.0f);
                    this.destroyGolem();
                }
            }
        }
        if (this.throwBlockCounter != 0) {
            if (this.throwBlockCounter++ == 50) {
                if (MoCreatures.isServer()) {
                    this.shootBlock(this.field_70789_a);
                }
            } else if (this.throwBlockCounter > 70) {
                this.throwBlockCounter = 0;
            }
        }
        if (MoCreatures.proxy.getParticleFX() > 0 && this.getGolemState() == 4 && this.smokeCounter > 0) {
            for (int index = 0; index < 10; ++index) {
                this.field_70170_p.func_72869_a("explode", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian());
            }
        }
    }

    private void destroyGolem() {
        EntityPlayer player;
        List usedBlocks = this.usedCubes();
        if (!usedBlocks.isEmpty() && MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
            for (int index = 0; index < usedBlocks.size(); ++index) {
                Block block = Block.func_149729_e((int)this.generateBlock(this.golemCubes[(Integer)usedBlocks.get(index)]));
                EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(block, 1, 0));
                entityItem.field_145804_b = 10;
                this.field_70170_p.func_72838_d((Entity)entityItem);
            }
        }
        if ((player = this.field_70170_p.func_72890_a((Entity)this, 8.0)) != null) {
            player.func_71064_a((StatBase)MoCAchievements.kill_big_golem, 1);
        }
        this.func_70106_y();
    }

    protected boolean func_70780_i() {
        return this.getGolemState() == 4;
    }

    protected void acquireBlock(int type) {
        int[] myBlockCoords = new int[]{-9999, -1, -1};
        myBlockCoords = MoCTools.getRandomBlockCoords((Entity)this, 24.0);
        if (myBlockCoords[0] == -9999) {
            return;
        }
        boolean canDestroyBlocks = MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks;
        Block block = this.field_70170_p.func_147439_a(myBlockCoords[0], myBlockCoords[1], myBlockCoords[2]);
        int tileBlockID = Block.func_149682_b((Block)this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)myBlockCoords[0]), MathHelper.func_76128_c((double)myBlockCoords[1]), MathHelper.func_76128_c((double)myBlockCoords[2])));
        if (tileBlockID == 0 || tileBlockID == 7) {
            return;
        }
        int tileBlockMetadata = this.field_70170_p.func_72805_g(MathHelper.func_76128_c((double)myBlockCoords[0]), MathHelper.func_76128_c((double)myBlockCoords[1]), MathHelper.func_76128_c((double)myBlockCoords[2]));
        BlockEvent.BreakEvent event = null;
        if (!this.field_70170_p.field_72995_K) {
            event = new BlockEvent.BreakEvent(myBlockCoords[0], myBlockCoords[1], myBlockCoords[2], this.field_70170_p, block, tileBlockMetadata, (EntityPlayer)FakePlayerFactory.get((WorldServer)((WorldServer)this.field_70170_p), (GameProfile)MoCreatures.MOC_FAKE_PLAYER));
        }
        if (canDestroyBlocks && event != null && !event.isCanceled()) {
            this.field_70170_p.func_147465_d(myBlockCoords[0], myBlockCoords[1], myBlockCoords[2], Blocks.field_150350_a, 0, 3);
        }
        MoCEntityThrowableBlockForGolem entityBlock = new MoCEntityThrowableBlockForGolem(this.field_70170_p, (Entity)this, myBlockCoords[0], myBlockCoords[1] + 1, myBlockCoords[2]);
        if (!canDestroyBlocks) {
            tileBlockID = this.returnRandomCheapBlock();
            tileBlockMetadata = 0;
        }
        entityBlock.setType(tileBlockID);
        entityBlock.setMetadata(tileBlockMetadata);
        entityBlock.setBehavior(type);
        this.field_70170_p.func_72838_d((Entity)entityBlock);
    }

    private int returnRandomCheapBlock() {
        int random_number = this.field_70146_Z.nextInt(4);
        switch (random_number) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 79;
            }
        }
        return 3;
    }

    public void receiveBlock(int ID, int Metadata) {
        if (MoCreatures.isServer()) {
            byte myBlock = this.translateOre(ID);
            byte slot = (byte)this.getRandomCubeAdj();
            if (slot != -1 && slot < 23 && myBlock != -1 && this.getGolemState() != 4) {
                MoCTools.playCustomSound((Entity)this, "golemattach", this.field_70170_p, 3.0f);
                int worldDifficulty = this.field_70170_p.field_73013_u.func_151525_a();
                this.func_70606_j(this.func_110143_aJ() + (float)worldDifficulty);
                if (this.func_110143_aJ() > this.func_110138_aP()) {
                    this.func_70606_j(this.func_110138_aP());
                }
                this.saveGolemCube(slot, myBlock);
            } else {
                MoCTools.playCustomSound((Entity)this, "turtlehurt", this.field_70170_p, 2.0f);
                if (MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
                    EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Block.func_149729_e((int)ID), 1, Metadata));
                    entityItem.field_145804_b = 10;
                    entityItem.field_70292_b = 4000;
                }
            }
        }
    }

    protected void attackWithEntityBlock() {
        ++this.throwBlockCounter;
        if (this.throwBlockCounter == 5) {
            MoCEntityThrowableBlockForGolem entityBlock = new MoCEntityThrowableBlockForGolem(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)entityBlock);
            entityBlock.setType(MoCTools.destroyRandomBlock((Entity)this, 5.0));
            entityBlock.setBehavior(1);
            this.tempBlock = entityBlock;
        }
        if (this.throwBlockCounter >= 5 && this.throwBlockCounter < 200) {
            this.tempBlock.field_70165_t = this.field_70165_t;
            this.tempBlock.field_70163_u = this.field_70163_u + 3.0;
            this.tempBlock.field_70161_v = this.field_70161_v;
        }
        if (this.throwBlockCounter >= 200) {
            if (this.field_70789_a != null) {
                this.throwBlockAtEntity(this.field_70789_a, this.tempBlock.getType(), 0);
            }
            this.tempBlock.func_70106_y();
            this.throwBlockCounter = 0;
        }
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (distanceToEntity > 5.0f && entity != null && this.throwBlockCounter == 0 && this.canShoot()) {
            this.throwBlockCounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            return;
        }
        if (this.field_70724_aR <= 0 && (double)distanceToEntity < 2.5 && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.throwBlockCounter = 1;
        }
        if (animationType == 1) {
            this.smokeCounter = 1;
        }
    }

    private void shootBlock(Entity entity) {
        int tempBlockId;
        if (entity == null) {
            return;
        }
        ArrayList<Integer> armBlocks = new ArrayList<Integer>();
        for (int index = 9; index < 15; ++index) {
            if (this.golemCubes[index] == 30) continue;
            armBlocks.add(index);
        }
        if (armBlocks.isEmpty()) {
            return;
        }
        int idOfLastBlockInArm = this.field_70146_Z.nextInt(armBlocks.size());
        int idOfBlockToBeThrown = tempBlockId = ((Integer)armBlocks.get(idOfLastBlockInArm)).intValue();
        if (tempBlockId == 9 || tempBlockId == 12) {
            if (this.golemCubes[tempBlockId + 2] != 30) {
                idOfBlockToBeThrown = tempBlockId + 2;
            } else if (this.golemCubes[tempBlockId + 1] != 30) {
                idOfBlockToBeThrown = tempBlockId + 1;
            }
        }
        if ((tempBlockId == 10 || tempBlockId == 13) && this.golemCubes[tempBlockId + 1] != 30) {
            idOfBlockToBeThrown = tempBlockId + 1;
        }
        MoCTools.playCustomSound((Entity)this, "golemshoot", this.field_70170_p, 3.0f);
        this.throwBlockAtEntity(entity, this.generateBlock(this.golemCubes[idOfBlockToBeThrown]), 0);
        this.saveGolemCube((byte)idOfBlockToBeThrown, (byte)30);
        this.throwBlockCounter = 0;
    }

    private boolean canShoot() {
        int amountOfBlockThatCanBeThrown = 0;
        for (int index = 9; index < 15; index = (int)((byte)(index + 1))) {
            if (this.golemCubes[index] == 30) continue;
            ++amountOfBlockThatCanBeThrown;
        }
        return amountOfBlockThatCanBeThrown != 0 && this.getGolemState() != 4 && this.getGolemState() != 1;
    }

    @Override
    protected Entity func_70782_k() {
        EntityPlayer closestEntityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return closestEntityPlayer != null && this.func_70685_l((Entity)closestEntityPlayer) ? closestEntityPlayer : null;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        boolean isChestUncovered;
        if (this.getGolemState() == 4) {
            return false;
        }
        List missingChestBlocks = this.missingChestCubes();
        boolean bl = isChestUncovered = missingChestBlocks.size() == 4;
        if (!this.openChest() && !isChestUncovered && this.getGolemState() != 1) {
            int worldDifficulty = this.field_70170_p.field_73013_u.func_151525_a();
            if (MoCreatures.isServer() && this.field_70146_Z.nextInt(worldDifficulty) == 0) {
                this.destroyRandomGolemCube();
            } else {
                MoCTools.playCustomSound((Entity)this, "turtlehurt", this.field_70170_p, 2.0f);
            }
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        if (damageTaken > 5.0f) {
            damageTaken = 5.0f;
        }
        if (this.getGolemState() != 1 && super.func_70097_a(damageSource, damageTaken)) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        if (this.getGolemState() == 1) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (entityThatAttackedThisCreature != this && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    private void destroyRandomGolemCube() {
        int listPositionOfUsedCube = this.getRandomUsedCube();
        if (listPositionOfUsedCube == 4) {
            return;
        }
        int listPositionOfUsedCubeToDestroy = listPositionOfUsedCube;
        if ((listPositionOfUsedCube == 10 || listPositionOfUsedCube == 13 || listPositionOfUsedCube == 16 || listPositionOfUsedCube == 19) && this.golemCubes[listPositionOfUsedCube + 1] != 30) {
            listPositionOfUsedCubeToDestroy = listPositionOfUsedCube + 1;
        }
        if (listPositionOfUsedCube == 9 || listPositionOfUsedCube == 12 || listPositionOfUsedCube == 15 || listPositionOfUsedCube == 18) {
            if (this.golemCubes[listPositionOfUsedCube + 2] != 30) {
                listPositionOfUsedCubeToDestroy = listPositionOfUsedCube + 2;
            } else if (this.golemCubes[listPositionOfUsedCube + 1] != 30) {
                listPositionOfUsedCubeToDestroy = listPositionOfUsedCube + 1;
            }
        }
        if (listPositionOfUsedCubeToDestroy != -1 && this.golemCubes[listPositionOfUsedCubeToDestroy] != 30) {
            Block block = Block.func_149729_e((int)this.generateBlock(this.golemCubes[listPositionOfUsedCubeToDestroy]));
            this.saveGolemCube((byte)listPositionOfUsedCubeToDestroy, (byte)30);
            MoCTools.playCustomSound((Entity)this, "golemhurt", this.field_70170_p, 3.0f);
            if (MoCTools.mobGriefing(this.field_70170_p) && MoCreatures.proxy.golemDestroyBlocks) {
                EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(block, 1, 0));
                entityItem.field_145804_b = 10;
                this.field_70170_p.func_72838_d((Entity)entityItem);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.golemCubes[17] != 30 || this.golemCubes[20] != 30) {
            return 0.0f;
        }
        if (this.golemCubes[16] != 30 || this.golemCubes[19] != 30) {
            return 0.4f;
        }
        if (this.golemCubes[15] != 30 || this.golemCubes[18] != 30) {
            return 0.7f;
        }
        if (this.golemCubes[1] != 30 || this.golemCubes[3] != 30) {
            return 0.8f;
        }
        return 1.45f;
    }

    @Override
    public float getSizeFactor() {
        return 1.8f;
    }

    protected void throwBlockAtEntity(Entity targetEntity, int blockType, int metadata) {
        this.throwBlockAtCoordinates((int)targetEntity.field_70165_t, (int)targetEntity.field_70163_u, (int)targetEntity.field_70161_v, blockType, metadata);
    }

    protected void throwBlockAtCoordinates(int X, int Y, int Z, int blockType, int metadata) {
        MoCEntityThrowableBlockForGolem entityBlock = new MoCEntityThrowableBlockForGolem(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)entityBlock);
        entityBlock.setType(blockType);
        entityBlock.setMetadata(metadata);
        entityBlock.setBehavior(0);
        entityBlock.field_70159_w = ((double)X - this.field_70165_t) / 20.0;
        entityBlock.field_70181_x = ((double)Y - this.field_70163_u) / 20.0 + 0.5;
        entityBlock.field_70179_y = ((double)Z - this.field_70161_v) / 20.0;
    }

    public byte getBlockTexture(int i) {
        return this.golemCubes[i];
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("golemState", this.getGolemState());
        NBTTagList cubeLists = new NBTTagList();
        for (int index = 0; index < 23; ++index) {
            NBTTagCompound nbttag = new NBTTagCompound();
            nbttag.func_74774_a("Slot", this.golemCubes[index]);
            cubeLists.func_74742_a((NBTBase)nbttag);
        }
        nbtTagCompound.func_74782_a("GolemBlocks", (NBTBase)cubeLists);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setGolemState(nbtTagCompound.func_74762_e("golemState"));
        NBTTagList nbttaglist = nbtTagCompound.func_150295_c("GolemBlocks", 10);
        for (int i = 0; i < 23; ++i) {
            NBTTagCompound var4 = nbttaglist.func_150305_b(i);
            this.golemCubes[i] = var4.func_74771_c("Slot");
        }
    }

    private void initGolemCubes() {
        this.golemCubes = new byte[23];
        for (int index = 0; index < 23; ++index) {
            this.golemCubes[index] = 30;
        }
        int j = this.field_70146_Z.nextInt(4);
        switch (j) {
            case 0: {
                j = 7;
                break;
            }
            case 1: {
                j = 11;
                break;
            }
            case 2: {
                j = 15;
                break;
            }
            case 3: {
                j = 21;
            }
        }
        this.saveGolemCube((byte)4, (byte)j);
    }

    public void saveGolemCube(byte slot, byte value) {
        this.golemCubes[slot] = value;
        if (MoCreatures.isServer() && MoCreatures.proxy.worldInitDone) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageTwoBytes(this.func_145782_y(), slot, value), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    private List missingCubes() {
        ArrayList<Integer> emptyBlocks = new ArrayList<Integer>();
        for (int index = 0; index < 23; ++index) {
            if (this.golemCubes[index] != 30) continue;
            emptyBlocks.add(index);
        }
        return emptyBlocks;
    }

    public boolean isMissingCubes() {
        for (int index = 0; index < 23; ++index) {
            if (this.golemCubes[index] != 30) continue;
            return true;
        }
        return false;
    }

    private List missingChestCubes() {
        ArrayList<Integer> emptyChestBlocks = new ArrayList<Integer>();
        for (int index = 0; index < 4; ++index) {
            if (this.golemCubes[index] != 30) continue;
            emptyChestBlocks.add(index);
        }
        return emptyChestBlocks;
    }

    private List usedCubes() {
        ArrayList<Integer> usedBlocks = new ArrayList<Integer>();
        for (int index = 0; index < 23; ++index) {
            if (this.golemCubes[index] == 30) continue;
            usedBlocks.add(index);
        }
        return usedBlocks;
    }

    private int getRandomUsedCube() {
        List usedBlocks = this.usedCubes();
        if (usedBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.field_70146_Z.nextInt(usedBlocks.size());
        return (Integer)usedBlocks.get(randomEmptyBlock);
    }

    private int getRandomMissingCube() {
        List emptyChestBlocks = this.missingChestCubes();
        if (!emptyChestBlocks.isEmpty()) {
            int randomEmptyBlock = this.field_70146_Z.nextInt(emptyChestBlocks.size());
            return (Integer)emptyChestBlocks.get(randomEmptyBlock);
        }
        List emptyBlocks = this.missingCubes();
        if (emptyBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.field_70146_Z.nextInt(emptyBlocks.size());
        return (Integer)emptyBlocks.get(randomEmptyBlock);
    }

    private int getRandomCubeAdj() {
        int emptyCubePosition = this.getRandomMissingCube();
        if (emptyCubePosition == 10 || emptyCubePosition == 13 || emptyCubePosition == 16 || emptyCubePosition == 19) {
            if (this.golemCubes[emptyCubePosition - 1] == 30) {
                return emptyCubePosition - 1;
            }
            this.saveGolemCube((byte)emptyCubePosition, this.golemCubes[emptyCubePosition - 1]);
            return emptyCubePosition - 1;
        }
        if (emptyCubePosition == 11 || emptyCubePosition == 14 || emptyCubePosition == 17 || emptyCubePosition == 20) {
            if (this.golemCubes[emptyCubePosition - 2] == 30 && this.golemCubes[emptyCubePosition - 1] == 30) {
                return emptyCubePosition - 2;
            }
            if (this.golemCubes[emptyCubePosition - 1] == 30) {
                this.saveGolemCube((byte)(emptyCubePosition - 1), this.golemCubes[emptyCubePosition - 2]);
                return emptyCubePosition - 2;
            }
            this.saveGolemCube((byte)emptyCubePosition, this.golemCubes[emptyCubePosition - 1]);
            this.saveGolemCube((byte)(emptyCubePosition - 1), this.golemCubes[emptyCubePosition - 2]);
            return emptyCubePosition - 2;
        }
        return emptyCubePosition;
    }

    @Override
    public int rollRotationOffset() {
        int leftLeg = 0;
        int rightLeg = 0;
        if (this.golemCubes[15] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[16] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[17] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[18] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[19] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[20] != 30) {
            ++rightLeg;
        }
        return (leftLeg - rightLeg) * 10;
    }

    public boolean openChest() {
        List entitiesNearbyList;
        int iterationLength;
        if (this.isMissingCubes() && (iterationLength = (entitiesNearbyList = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(2.0, 2.0, 2.0))).size()) > 0) {
            for (int index = 0; index < iterationLength; ++index) {
                Entity entityNearby = (Entity)entitiesNearbyList.get(index);
                if (!(entityNearby instanceof MoCEntityThrowableBlockForGolem)) continue;
                if (MoCreatures.proxy.getParticleFX() > 0) {
                    MoCreatures.proxy.VacuumFX(this);
                }
                return true;
            }
        }
        return false;
    }

    private byte translateOre(int blockType) {
        switch (blockType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 18: {
                return 10;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 48: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 16: 
            case 21: 
            case 56: 
            case 73: 
            case 74: {
                return 24;
            }
            case 14: 
            case 41: {
                return 7;
            }
            case 15: 
            case 42: {
                return 11;
            }
            case 57: {
                return 15;
            }
            case 17: {
                return 6;
            }
            case 20: {
                return 8;
            }
            case 22: 
            case 35: {
                return 9;
            }
            case 45: {
                return 12;
            }
            case 49: {
                return 14;
            }
            case 58: {
                return 16;
            }
            case 61: 
            case 62: {
                return 17;
            }
            case 78: 
            case 79: {
                return 18;
            }
            case 81: {
                return 19;
            }
            case 82: {
                return 20;
            }
            case 86: 
            case 91: 
            case 103: {
                return 22;
            }
            case 87: {
                return 23;
            }
            case 89: {
                return 25;
            }
            case 98: {
                return 26;
            }
            case 112: {
                return 27;
            }
            case 129: 
            case 133: {
                return 21;
            }
        }
        return -1;
    }

    private int generateBlock(int golemBlock) {
        switch (golemBlock) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 17;
            }
            case 7: {
                return 41;
            }
            case 8: {
                return 20;
            }
            case 9: {
                return 35;
            }
            case 10: {
                return 18;
            }
            case 11: {
                return 42;
            }
            case 12: {
                return 45;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 49;
            }
            case 15: {
                return 57;
            }
            case 16: {
                return 58;
            }
            case 17: {
                return 51;
            }
            case 18: {
                return 79;
            }
            case 19: {
                return 81;
            }
            case 20: {
                return 82;
            }
            case 21: {
                return 133;
            }
            case 22: {
                return 86;
            }
            case 23: {
                return 87;
            }
            case 24: {
                return 56;
            }
            case 25: {
                return 89;
            }
            case 26: {
                return 98;
            }
            case 27: {
                return 112;
            }
        }
        return 2;
    }

    @Override
    public float getMoveSpeed() {
        return 0.4f * ((float)this.countLegBlocks() / 6.0f);
    }

    private int countLegBlocks() {
        int amountOfLegBlocks = 0;
        for (int index = 15; index < 21; index = (int)((byte)(index + 1))) {
            if (this.golemCubes[index] == 30) continue;
            ++amountOfLegBlocks;
        }
        return amountOfLegBlocks;
    }

    public ResourceLocation getEffectTexture() {
        switch (this.getGolemState()) {
            case 1: {
                return MoCreatures.proxy.getTexture("golemeffect1.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("golemeffect2.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("golemeffect3.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("golemeffect4.png");
            }
        }
        return null;
    }

    public float colorFX(int i) {
        switch (this.getGolemState()) {
            case 1: {
                if (i == 1) {
                    return 0.25490198f;
                }
                if (i == 2) {
                    return 0.6156863f;
                }
                if (i == 3) {
                    return 0.99607843f;
                }
            }
            case 2: {
                if (i == 1) {
                    return 0.95686275f;
                }
                if (i == 2) {
                    return 0.972549f;
                }
                if (i == 3) {
                    return 0.14117648f;
                }
            }
            case 3: {
                if (i == 1) {
                    return 1.0f;
                }
                if (i == 2) {
                    return 0.6039216f;
                }
                if (i == 3) {
                    return 0.08235294f;
                }
            }
            case 4: {
                if (i == 1) {
                    return 0.972549f;
                }
                if (i == 2) {
                    return 0.039215688f;
                }
                if (i != 3) break;
                return 0.039215688f;
            }
        }
        return 0.0f;
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.func_85030_a("mocreatures:golemwalk", 1.0f, 1.0f);
    }

    protected String func_70673_aS() {
        return null;
    }

    protected String func_70621_aR() {
        return "mocreatures:golemgrunt";
    }

    protected String func_70639_aQ() {
        return null;
    }

    @Override
    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && this.field_70163_u > 50.0;
    }

    @Override
    public boolean entitiesThatAreScary(Entity entityNearby) {
        return false;
    }
}

