/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.MoCEntityTameableAquatic;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.aquatic.MoCEntityDolphin;
import drzhark.mocreatures.entity.aquatic.MoCEntityJellyFish;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class MoCEntityShark
extends MoCEntityTameableAquatic {
    public MoCEntityShark(World world) {
        super(world);
        this.texture = "shark.png";
        this.func_70105_a(1.5f, 0.8f);
        this.setMoCAge(100 + this.field_70146_Z.nextInt(100));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.getIsTamed() && this.field_70173_aa > 2400;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (!((double)distanceToEntity < 3.5) || !(entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b) || !(entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) || this.getMoCAge() < 100) return;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_70154_o != null) {
            Entity entityThatPlayerIsRiding = ((EntityPlayer)entity).field_70154_o;
            if (entityThatPlayerIsRiding instanceof MoCEntityDolphin) {
                return;
            }
            if (this.isPlayerRidingBoat((EntityPlayer)entity)) {
                if (this.field_70170_p.field_73013_u.func_151525_a() <= 2) return;
                if (!((double)distanceToEntity < 2.0) || this.field_70146_Z.nextInt(100) >= 10) return;
                if (this.field_70146_Z.nextInt(100) < 10) {
                    for (int index = 0; index < 2; ++index) {
                        entityThatPlayerIsRiding.func_145778_a(Items.field_151055_y, 1, 0.0f);
                    }
                    this.field_70170_p.func_72956_a(entityThatPlayerIsRiding, "mob.zombie.woodbreak", 1.0f, 1.0f);
                    entityThatPlayerIsRiding.func_70106_y();
                } else {
                    this.field_70170_p.func_72956_a(entityThatPlayerIsRiding, "mob.zombie.wood", 1.0f, 1.0f);
                    return;
                }
            }
        }
        this.field_70724_aR = 20;
        entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken) && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this && !(entityThatAttackedThisCreature instanceof EntityMob)) {
                this.field_70789_a = entityThatAttackedThisCreature;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void func_70628_a(boolean flag, int x) {
        block3: {
            int dropChance;
            block2: {
                dropChance = this.field_70146_Z.nextInt(100);
                if (dropChance >= 90) break block2;
                int amountOfTeethToDrop = this.field_70146_Z.nextInt(3) + 1;
                for (int index = 0; index < amountOfTeethToDrop; ++index) {
                    this.func_70099_a(new ItemStack(MoCreatures.sharkTeeth, 1, 0), 0.0f);
                }
                break block3;
            }
            if (this.field_70170_p.field_73013_u.func_151525_a() <= 0 || this.getMoCAge() <= 150 || dropChance >= 40) break block3;
            int amountOfEggsToDrop = this.field_70146_Z.nextInt(3);
            for (int index1 = 0; index1 < amountOfEggsToDrop; ++index1) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, 11), 0.0f);
            }
        }
    }

    protected Entity func_70782_k() {
        EntityLivingBase entityThatAttackedOwner;
        double distanceToOwner;
        EntityPlayerMP ownerOfEntityThatIsOnline;
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0 && this.getMoCAge() >= 100) {
            EntityLivingBase entityLiving;
            EntityPlayer closestEntityPlayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            if (!(closestEntityPlayer == null || !closestEntityPlayer.func_70090_H() || this.getIsTamed() || closestEntityPlayer.field_70154_o instanceof MoCEntityDolphin || this.isPlayerRidingBoat(closestEntityPlayer) && this.field_70170_p.field_73013_u.func_151525_a() < 3 && this.field_70146_Z.nextInt(100) > 40)) {
                return closestEntityPlayer;
            }
            if (this.field_70146_Z.nextInt(200) == 0 && (entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 16.0)) != null && !(entityLiving instanceof EntityPlayer)) {
                return entityLiving;
            }
        }
        if (MoCreatures.proxy.specialPetsDefendOwner && this.getIsTamed() && (ownerOfEntityThatIsOnline = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.getOwnerName())) != null && (distanceToOwner = MoCTools.getSqDistanceTo((Entity)this, ownerOfEntityThatIsOnline.field_70165_t, ownerOfEntityThatIsOnline.field_70163_u, ownerOfEntityThatIsOnline.field_70161_v)) < 20.0 && (entityThatAttackedOwner = ownerOfEntityThatIsOnline.func_70643_av()) != null) {
            return entityThatAttackedOwner;
        }
        return null;
    }

    private boolean isPlayerRidingBoat(EntityPlayer player) {
        Entity entityThatPlayerIsRiding = player.field_70154_o;
        return entityThatPlayerIsRiding != null && (entityThatPlayerIsRiding instanceof EntityBoat || MoCreatures.isEtFuturumRequiemLoaded && (EntityList.func_75621_b((Entity)entityThatPlayerIsRiding).equals("etfuturum.new_boat") || EntityList.func_75621_b((Entity)entityThatPlayerIsRiding).equals("etfuturum.chest_boat")));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.getIsAdult() && this.field_70146_Z.nextInt(50) == 0) {
            this.setMoCAge(this.getMoCAge() + 1);
            if (this.getMoCAge() >= 200) {
                this.setAdult(true);
            }
        }
    }

    @Override
    public boolean shouldRenderName() {
        return this.getShouldDisplayName();
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !(entity instanceof EntityLivingBase) || !(entity instanceof MoCEntityAquatic) && !(entity instanceof MoCEntityTameableAquatic) && !entity.func_70090_H() || entity instanceof MoCEntityShark || entity == entity.field_70153_n || entity == entity.field_70154_o || entity instanceof IMob || entity instanceof EntityMob || entity instanceof MoCEntityMob || entity instanceof MoCEntityDolphin || entity instanceof MoCEntityJellyFish || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }
}

