/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.animal.MoCEntityHorse;
import drzhark.mocreatures.entity.aquatic.MoCEntitySmallFish;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityPiranha
extends MoCEntitySmallFish {
    public static final String[] fishNames = new String[]{"Piranha"};

    public MoCEntityPiranha(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
        this.setMoCAge(30 + this.field_70146_Z.nextInt(70));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    @Override
    public boolean isPredator() {
        return true;
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture("smallfish_piranha.png");
    }

    protected Entity func_70782_k() {
        if (this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            EntityPlayer entityPlayer = this.field_70170_p.func_72856_b((Entity)this, 12.0);
            if (entityPlayer != null && entityPlayer.func_70090_H() && !this.getIsTamed()) {
                return entityPlayer;
            }
            if (this.field_70146_Z.nextInt(80) == 0) {
                EntityLivingBase entityLiving = MoCTools.getClosestEntityLivingThatCanBeTargetted((Entity)this, 4.0);
                return entityLiving;
            }
        }
        return null;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damageTaken) {
        if (super.func_70097_a(damageSource, damageTaken) && this.field_70170_p.field_73013_u.func_151525_a() > 0) {
            Entity entityThatAttackedThisCreature = damageSource.func_76346_g();
            if (this.field_70153_n == entityThatAttackedThisCreature || this.field_70154_o == entityThatAttackedThisCreature) {
                return true;
            }
            if (entityThatAttackedThisCreature != this) {
                this.field_70789_a = entityThatAttackedThisCreature;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    protected void func_70785_a(Entity entity, float distanceToEntity) {
        if (entity.func_70090_H() && (double)distanceToEntity < 0.8) {
            Entity playerMount;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_70154_o != null && (playerMount = ((EntityPlayer)entity).field_70154_o) instanceof EntityBoat) {
                return;
            }
            this.field_70724_aR = 20;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int x) {
        int fishDropChance = this.field_70146_Z.nextInt(100);
        if (fishDropChance < 70) {
            this.func_70099_a(new ItemStack(Items.field_151115_aP, 1, 0), 0.0f);
        } else {
            int amountOfEggsToDrop = this.field_70146_Z.nextInt(2);
            for (int index = 0; index < amountOfEggsToDrop; ++index) {
                this.func_70099_a(new ItemStack(MoCreatures.mocegg, 1, 90), 0.0f);
            }
        }
    }

    @Override
    public boolean shouldEntityBeIgnored(Entity entity) {
        return !entity.func_70090_H() || !(entity instanceof EntityLivingBase) || entity instanceof MoCEntityPiranha || entity == entity.field_70153_n || entity == entity.field_70154_o || entity instanceof MoCEntityAmbient || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || entity instanceof IMob || entity instanceof MoCEntityMob || entity instanceof EntityPlayer || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity instanceof EntityWolf && !MoCreatures.proxy.attackWolves;
    }

    @Override
    public boolean isMyHealFood(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            List<String> oreDictionaryNameArray = MoCTools.getOreDictionaryEntries(itemStack);
            return item == Items.field_151115_aP && itemStack.func_77960_j() != 3 || oreDictionaryNameArray.contains("listAllfishraw");
        }
        return false;
    }
}

